/***************************************************************************
 *   Copyright (C) 2010 Nicolas Hadacek <hadacek@kde.org>                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef NOKDE_DOCKWINDOW_H
#define NOKDE_DOCKWINDOW_H

#include <QMainWindow>
#include <QDockWidget>

#include "nokde_misc_ui.h"

//-----------------------------------------------------------------------------
class KDockWidget : public QDockWidget
{
Q_OBJECT
public:
    enum DockPosition { DockCenter, DockCorner, DockNone, DockLeft, DockRight, DockBottom, DockTop };
  QString tabPageLabel() const;
  void setDockSite(int pos);
  void setEnableDocking(int pos);
  void changeHideShowState();
  bool mayBeHide();
  void manualDock(KDockWidget* target, int pos, int spliPos);
};

//-----------------------------------------------------------------------------
class KXMLGUIClient
{
public:
  KAction* action(const char* name) const;
  KActionCollection* actionCollection() const;
};

//-----------------------------------------------------------------------------
class KXMLGUIFactory
{
public:
  QWidget* container(const QString& name, KXMLGUIClient* client);
  void addClient(KXMLGUIClient* client);
  void removeClient(KXMLGUIClient* client);
};

//-----------------------------------------------------------------------------
class KDockManager : public QObject
{
Q_OBJECT
public:
  KDockWidget* getDockWidgetFromName(const QString& name);
};

//-----------------------------------------------------------------------------
class KDockMainWindow : public QMainWindow, public KXMLGUIClient
{
Q_OBJECT
public:
  KXMLGUIFactory* guiFactory() const;
  KDockWidget* createDockWidget(const QString& name, const QPixmap& pixmap,
                                QWidget* parent = NULL, const QString& caption = QString::null);
  void setView(QWidget* widget);
  void setMainDockWidget(KDockWidget* widget);
  void setupGUI();
  void makeWidgetDockVisible(QWidget* widget);
  KDockManager* manager();
};

#endif
