/***************************************************************************
 *   Copyright (C) 2010 Nicolas Hadacek <hadacek@kde.org>                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "nokde_misc_ui.h"

#include "common/gui/misc_gui.h"

//-----------------------------------------------------------------------------
KLineEdit::KLineEdit(QWidget* parent, const char* name)
: QLineEdit(parent, name)
{
}

KLineEdit::KLineEdit(const QString& text, QWidget* parent, const char* name)
: QLineEdit(text, parent, name)
{
}

//-----------------------------------------------------------------------------
KPushButton::KPushButton(QWidget* parent, const char* name)
: QPushButton(parent, name)
{
}

KPushButton::KPushButton(const KGuiItem& item, QWidget* parent, const char* name)
: QPushButton(IconLoader::loadIcon(item._icon, IconLoader::Small), item._label, parent, name)
{
}

KPushButton::KPushButton(const QString& text, QWidget* parent, const char* name)
: QPushButton(text, parent, name)
{
}

KPushButton::KPushButton(const QPixmap& icon, const QString& text, QWidget* parent, const char* name)
: QPushButton(icon, text, parent, name)
{
}

//-----------------------------------------------------------------------------
