/***************************************************************************
 *   Copyright (C) 2005-2007 Nicolas Hadacek <hadacek@kde.org>             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "toplevel_ui.h"
#include "toplevel_ui.moc"

#include "common/gui/misc_gui.h"

//----------------------------------------------------------------------------
VoltageStatusWidget::VoltageStatusWidget(const QString &label, QWidget *parent)
  : QLabel(parent), _label(label)
{}

void VoltageStatusWidget::setVoltage(const Device::VoltageValue &v)
{
  setText(i18n("%1: %2").arg(_label).arg(v.label()));
}

//----------------------------------------------------------------------------
ViewMenuAction::ViewMenuAction(KDockWidget *widget)
  : KToggleAction(widget->tabPageLabel()), _widget(widget)
{}

void ViewMenuAction::slotActivated()
{
  KAction::slotActivated();
  emit activated(_widget);
}

//----------------------------------------------------------------------------
MenuBarButton::MenuBarButton(const QString &icon, QWidget *parent)
  : QToolButton(parent, "menu_bar_button")
{
  QFontMetrics fm(font());
  int h = fm.height();
#ifdef NO_KDE
  setIconSet(IconLoader::loadIcon(icon, IconLoader::Small));
#else
  h += 2*style().pixelMetric(QStyle::PM_DefaultFrameWidth, this);
  KIconLoader loader;
  setIconSet(loader.loadIcon(icon, KIcon::Small, fm.height()-2));
#endif
  setFixedHeight(h);
  setUsesTextLabel(false);
  setAutoRaise(true);
}

QSize MenuBarButton::sizeHint() const
{
  return QSize(QToolButton::sizeHint().width(), height());
}
