/***************************************************************************
 *   Copyright (C) 2005 Nicolas Hadacek <hadacek@kde.org>                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "libgui/toplevel.h"
#include "common/global/about.h"

#ifndef NO_KDE
#  include "libgui/likeback.h"
#endif

const KCmdLineOptions OPTIONS[] = {
  { "+[file]", I18N_NOOP("Optional filenames to be opened upon startup."), NULL },
  { NULL, NULL, NULL}
};

int main(int argc, char **argv)
{
  Piklab::AboutData about("piklab", I18N_NOOP("Piklab"),
                          I18N_NOOP( "Graphical development environment for applications based on PIC and dsPIC microcontrollers."));
  Piklab::initArgs(about, argc, argv, *OPTIONS);
  const bool gui = true;
  Piklab::createApplication(about.appName(), argc, argv, gui, NULL);
#ifdef NO_KDE
  MainWindow::self().show();
  return QApplication::exec();
#else
  LikeBack::init(true);
  LikeBack::setServer("piklab.sourceforge.net", "/likeback/send.php");
  LikeBack::setAllowFeatureWishes(true);
  if ( kapp->isRestored() && KMainWindow::canBeRestored(1) ) MainWindow::self().restore(1);
  else MainWindow::self().show();
  return kapp->exec();
#endif
}
