/***************************************************************************
 *   Copyright (C) 2005-2006 Nicolas Hadacek <hadacek@kde.org>             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "common/global/pfile.h"

#include <qfile.h>
#include <kio/netaccess.h>
#include <ktemporaryfile.h>
#include "common/gui/misc_gui.h"

//-----------------------------------------------------------------------------
bool PURL::File::openForWrite()
{
  close();
  _tmp.reset(new KTemporaryFile);
  if (!_extension.isEmpty()) {
    _tmp->setSuffix("." + _extension);
  }
  if (!_tmp->open()) {
    _error = i18n("Could not create temporary file.");
    _log.sorry(_error, i18n("File: %1").arg(_tmp->name()));
    return false;
  }
  return true;
}

bool PURL::File::close()
{
  if (_tmp.get() != NULL) _tmp->close();
  else _file->close();
  if ( !_file->name().isEmpty() ) {
    KIO::NetAccess::removeTempFile(_file->name());
    _file->setName(QString::null);
  }
  _stream.reset(NULL);
  bool ok = true;
  if (_tmp.get() != NULL
      && !_url.isEmpty()
      && !KIO::NetAccess::upload(_tmp->name(), _url.kurl(), qApp->mainWidget())) {
    _error = KIO::NetAccess::lastErrorString();
    ok = false;
    _log.sorry(i18n("Could not save file."), errorString());
  }
  _tmp.reset(NULL);
  return ok;
}

bool PURL::File::openForRead()
{
  close();
  QString tmp;
  if ( !KIO::NetAccess::download(_url.kurl(), tmp, qApp->mainWidget()) ) {
    _error = KIO::NetAccess::lastErrorString();
    _log.sorry(i18n("Could not open file for reading."), errorString());
    return false;
  }
  _file->setName(tmp);
  if ( !_file->open(IO_ReadOnly) ) {
    _error = i18n("Could not open temporary file.");
    _log.sorry(_error, i18n("File: %1").arg(_file->name()));
    return false;
  }
  return true;
}

bool PURL::File::remove()
{
  close();
  if ( !_url.isEmpty() ) return _url.del(_log);
  return false;
}
