/***************************************************************************
 *   Copyright (C) 2005-2006 Nicolas Hadacek <hadacek@kde.org>             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "common/global/purl.h"

#include <qfile.h>
#include <kio/netaccess.h>
#include <ktemporaryfile.h>

#include "common/global/pfile.h"

//-----------------------------------------------------------------------------
bool PURL::Url::copyTo(const Url &destination, Log::Generic &log) const
{
  // do not overwrite
  bool ok = KIO::NetAccess::file_copy(_url, destination._url, qApp->mainWidget());
  if ( !ok ) log.sorry(i18n("Could not copy file"), KIO::NetAccess::lastErrorString());
  return ok;
}

bool PURL::Url::create(Log::Generic &log) const
{
  // assume file does not exist if ioslave cannot tell...
  if ( KIO::NetAccess::exists(_url, KIO::NetAccess::DestinationSide, qApp->mainWidget()) ) return false;
  KTemporaryFile tmp;
  if (!tmp.open()) return false;
  // do not overwrite
  bool ok = KIO::NetAccess::file_copy(tmp.name(), _url, qApp->mainWidget());
  if ( !ok ) log.sorry(i18n("Could not create file"), KIO::NetAccess::lastErrorString());
  return ok;
}

bool PURL::Url::del(Log::Generic &log) const
{
  bool ok = KIO::NetAccess::del(_url, qApp->mainWidget());
  if ( !ok ) log.sorry(i18n("Could not delete file."), KIO::NetAccess::lastErrorString());
  return ok;
}

//-----------------------------------------------------------------------------
bool PURL::Directory::create(Log::Generic &log) const
{
  // assume dir do no exist if ioslave cannot tell...
  if ( KIO::NetAccess::exists(_url, KIO::NetAccess::DestinationSide, qApp->mainWidget()) ) return false;
  bool ok = KIO::NetAccess::mkdir(_url, qApp->mainWidget());
  if ( !ok ) log.sorry(i18n("Could not create directory"), KIO::NetAccess::lastErrorString());
  return ok;
}
