/***************************************************************************
 *   Copyright (C) 2005-2006 Nicolas Hadacek <hadacek@kde.org>             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "common/global/purl.h"

//-----------------------------------------------------------------------------
bool PURL::Url::copyTo(const Url &destination, Log::Generic &log) const
{
  if (!isLocal()) {
    log.sorry(i18n("Could not copy non-local file"), pretty());
    return false;
  }
  if (!destination.isLocal()) {
    log.sorry(i18n("Could not copy to non-local destination"), destination.pretty());
    return false;
  }

  // do not overwrite
  bool ok = QFile::copy(filepath(), destination.filepath());
  if (!ok) log.sorry(i18n("Could not copy file"), destination.pretty());
  return ok;
}

bool PURL::Url::create(Log::Generic &log) const
{
  if (!isLocal()) {
    log.sorry(i18n("Could not create non-local file"), pretty());
    return false;
  }
  // do not overwrite
  QFile file(filepath());
  if (file.exists()) {
    return false;
  }
  bool ok = file.open(QIODevice::WriteOnly);
  if (!ok) log.sorry(i18n("Could not create file"), pretty());
  return ok;
}

bool PURL::Url::del(Log::Generic &log) const
{
  if (!isLocal()) {
    log.sorry(i18n("Could not delete non-local file"), pretty());
    return false;
  }
  bool ok = QFile::remove(filepath());
  if (!ok) log.sorry(i18n("Could not delete file"), pretty());
  return ok;
}

//-----------------------------------------------------------------------------
bool PURL::Directory::create(Log::Generic &log) const
{
  if (!isLocal()) {
    log.sorry(i18n("Could not create non-local directory"), pretty());
    return false;
  }
  QDir root = QDir::root();
  bool ok = root.mkpath(path());
  if (!ok) log.sorry(i18n("Could not create directory"), pretty());
  return ok;
}
