/*
 * Copyright (c) 2011-2018 Montel Laurent <montel@kde.org>
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of this program with any edition of
 *  the Qt library by Trolltech AS, Norway (or with modified versions
 *  of Qt that use the same license as Qt), and distribute linked
 *  combinations including the two.  You must obey the GNU General
 *  Public License in all respects for all of the code used other than
 *  Qt.  If you modify this file, you may extend this exception to
 *  your version of the file, but you are not obligated to do so.  If
 *  you do not wish to do so, delete this exception statement from
 *  your version.
 */

#ifndef RENAMEFILEDIALOG_H
#define RENAMEFILEDIALOG_H

#include <QDialog>
#include <QUrl>

#include "pimcommon_export.h"

namespace PimCommon {
class RenameFileDialogPrivate;
class PIMCOMMON_EXPORT RenameFileDialog : public QDialog
{
    Q_OBJECT
public:
    explicit RenameFileDialog(const QUrl &url, bool multiFiles, QWidget *parent);
    ~RenameFileDialog();

    enum RenameFileDialogResult {
        RENAMEFILE_IGNORE = 0,
        RENAMEFILE_IGNOREALL = 1,
        RENAMEFILE_RENAME = 2,
        RENAMEFILE_OVERWRITE = 3,
        RENAMEFILE_OVERWRITEALL = 4
    };

    Q_REQUIRED_RESULT QUrl newName() const;

private:
    void slotOverwritePressed();
    void slotIgnorePressed();
    void slotRenamePressed();
    void slotApplyAllPressed();
    void slotSuggestNewNamePressed();
    //@cond PRIVATE
    class RenameFileDialogPrivate;
    RenameFileDialogPrivate *const d;
};
}

#endif /* RENAMEFILEDIALOG_H */
