#lang scheme/base
(require scheme/contract)

(define (string-len-one? x)
  (and (string? x)
       (= 1 (string-length x))))
  
(provide/contract
 [tex-shortcut-table
  (listof (list/c string? string-len-one?))])

(define tex-shortcut-table
  '(("Downarrow" "⇓")
    ("nwarrow" "↖")
    ("downarrow" "↓")
    ("Rightarrow" "⇒")
    ("rightarrow" "→")
    ("mapsto" "↦")
    ("searrow" "↘")
    ("swarrow" "↙")
    ("leftarrow" "←")
    ("uparrow" "↑")
    ("Leftarrow" "⇐")
    ("longrightarrow" "−")
    ("Uparrow" "⇑")
    ("Leftrightarrow" "⇔")
    ("updownarrow" "↕")
    ("leftrightarrow" "↔")
    ("nearrow" "↗")
    ("Updownarrow" "⇕")
   
    ;; arrows that didn't come out right in copy & paste
    ;←− \longleftarrow
    ;⇐= \Longleftarrow 
    ;← 􏰂 \hookleftarrow
    ;←→ \longleftrightarrow 
    ;􏰁 → \hookrightarrow
    ;⇐⇒ \Longleftrightarrow
    ;􏴲 \leadsto∗ 
    ;􏰃−→ \longmapsto
    ;=⇒ \Longrightarrow 
    ;􏰃→ \mapsto
    
    
    ("aleph" "א")
    ("prime" "′")
    ("emptyset" "∅")
    ("nabla" "∇")
    ("diamondsuit" "♦")
    ("spadesuit" "♠")
    ("clubsuit" "♣")
    ("heartsuit" "♥")
    ("sharp" "♯")
    ("flat" "♭")
    ("natural" "♮")
    ("surd" "√")
    ("neg" "¬")
    ("triangle" "△")
    ("forall" "∀")
    ("exists" "∃")
    ("infty" "∞")
    ("circ" "∘")
    ("alpha" "α")
    ("theta" "θ")
    ("tau" "τ")
    ("beta" "β")
    ("vartheta" "θ")
    ("pi" "π")
    ("upsilon" "υ")
    ("gamma" "γ")
    ("varpi" "π")
    ("phi" "φ")
    ("delta" "δ")
    ("kappa" "κ")
    ("rho" "ρ")
    ("varphi" "φ")
    ("epsilon" "ε")
    ("lambda" "λ")
    ("varrho" "ρ")
    ("chi" "χ")
    ("varepsilon" "ε")
    ("mu" "μ")
    ("sigma" "σ")
    ("psi" "ψ")
    ("zeta" "ζ")
    ("nu" "ν")
    ("varsigma" "ς")
    ("omega" "ω")
    ("eta" "η")
    ("xi" "ξ")
    ("Gamma" "Γ")
    ("Lambda" "Λ")
    ("Sigma" "Σ")
    ("Psi" "Ψ")
    ("Delta" "∆")
    ("Xi" "Ξ")
    ("Upsilon" "Υ")
    ("Omega" "Ω")
    ("Theta" "Θ")
    ("Pi" "Π")
    ("Phi" "Φ")
    ("pm" "±")
    ("cap" "∩")
    ("diamond" "◇")
    ("oplus" "⊕")
    ("mp" "∓")
    ("cup" "∪")
    ("bigtriangleup" "△")
    ("ominus" "⊖")
    ("times" "×")
    ("uplus" "⊎")
    ("bigtriangledown" "▽")
    ("otimes" "⊗")
    ("div" "÷")
    ("sqcap" "⊓")
    ("triangleleft" "▹")
    ("oslash" "⊘")
    ("ast" "∗")
    ("sqcup" "⊔")
    ("vee" "∨")
    ("wedge" "∧")
    ("triangleright" "◃")
    ("odot" "⊙")
    ("star" "★")
    ("dagger" "†")
    ("bullet" "•")
    ("ddagger" "‡")
    ("wr" "≀")
    ("amalg" "⨿")
    ("leq" "≤")
    ("geq" "≥")
    ("equiv" "≡")
    ("models" "⊨")
    ("prec" "≺")
    ("succ" "≻")
    ("sim" "∼")
    ("perp" "⊥")
    ("top" "⊤")
    ("preceq" "≼")
    ("succeq" "≽")
    ("simeq" "≃")
    ("ll" "≪")
    ("gg" "≫")
    ("asymp" "≍")
    ("parallel" "∥")
    ("subset" "⊂")
    ("supset" "⊃")
    ("approx" "≈")
    ("bowtie" "⋈")
    ("subseteq" "⊆")
    ("supseteq" "⊇")
    ("cong" "≌")
    ("sqsubsetb" "⊏")
    ("sqsupsetb" "⊐")
    ("neq" #;"≠" "≠")
    ("smile" "⌣")
    ("sqsubseteq" "⊑")
    ("sqsupseteq" "⊒")
    ("doteq" "≐")
    ("frown" "⌢")
    ("in" "∈")
    ("ni" "∋")
    ("propto" "∝")
    ("vdash" "⊢")
    ("dashv" "⊣")
    
    ("sqrt" "√")
    
    ("skull" "☠") 
    ("smiley" "☺")
    ("blacksmiley" "☻")
    ("frownie" "☹")
    ))

;; checks to see if there are duplicates
#;
(define (find-dups)
  (let ([ht (make-hash-table 'equal)])
    (for-each
     (λ (line)
       (let ([name (list-ref line 0)]
             [obj (list-ref line 1)])
         (hash-table-put! ht name (cons obj (hash-table-get ht name '())))))
     tex-shortcut-table)
    (hash-table-for-each
     ht
     (λ (k v)
       (unless (= 1 (length v))
         (printf "~s -> ~s\n" k v))))))
