/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.StringReader;
import java.util.Properties;
import net.sourceforge.pmd.TargetJDK1_4;
import net.sourceforge.pmd.ast.JavaParserTokenManager;
import net.sourceforge.pmd.ast.Token;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.Tokenizer;
import net.sourceforge.pmd.cpd.Tokens;

public class JavaTokenizer
implements Tokenizer {
    public static final String IGNORE_LITERALS = "ignore_literals";
    public static final String IGNORE_IDENTIFIERS = "ignore_identifiers";
    private boolean ignoreLiterals;
    private boolean ignoreIdentifiers;

    public void setProperties(Properties properties) {
        this.ignoreLiterals = Boolean.valueOf(properties.getProperty(IGNORE_LITERALS, "false"));
        this.ignoreIdentifiers = Boolean.valueOf(properties.getProperty(IGNORE_IDENTIFIERS, "false"));
    }

    public void tokenize(SourceCode tokens, Tokens tokenEntries) {
        StringBuffer buffer = tokens.getCodeBuffer();
        JavaParserTokenManager tokenMgr = new TargetJDK1_4().createJavaParserTokenManager(new StringReader(buffer.toString()));
        Token currentToken = tokenMgr.getNextToken();
        boolean inDiscardingState = false;
        while (currentToken.image.length() > 0) {
            if (currentToken.kind == 35 || currentToken.kind == 43) {
                inDiscardingState = true;
                currentToken = tokenMgr.getNextToken();
                continue;
            }
            if (inDiscardingState && currentToken.kind == 81) {
                inDiscardingState = false;
            }
            if (inDiscardingState) {
                currentToken = tokenMgr.getNextToken();
                continue;
            }
            if (currentToken.kind != 81) {
                String image = currentToken.image;
                if (this.ignoreLiterals && (currentToken.kind == 71 || currentToken.kind == 70 || currentToken.kind == 64 || currentToken.kind == 67)) {
                    image = String.valueOf(currentToken.kind);
                }
                if (this.ignoreIdentifiers && currentToken.kind == 72) {
                    image = String.valueOf(currentToken.kind);
                }
                tokenEntries.add(new TokenEntry(image, tokens.getFileName(), currentToken.beginLine));
            }
            currentToken = tokenMgr.getNextToken();
        }
        tokenEntries.add(TokenEntry.getEOF());
    }

    public void setIgnoreLiterals(boolean ignore) {
        this.ignoreLiterals = ignore;
    }

    public void setIgnoreIdentifiers(boolean ignore) {
        this.ignoreIdentifiers = ignore;
    }
}

