/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util;

import java.math.BigDecimal;
import net.sourceforge.pmd.util.CollectionUtil;
import net.sourceforge.pmd.util.TypeMap;

public class ClassUtil {
    private static final TypeMap primitiveTypesByName = new TypeMap(new Class[]{Integer.TYPE, Byte.TYPE, Long.TYPE, Short.TYPE, Float.TYPE, Double.TYPE, Character.TYPE, Boolean.TYPE});
    private static final TypeMap typesByNames = new TypeMap(new Class[]{Integer.class, Byte.class, Long.class, Short.class, Float.class, Double.class, Character.class, Boolean.class, BigDecimal.class, String.class, Object.class});

    private ClassUtil() {
    }

    public static Class getPrimitiveTypeFor(String name) {
        return primitiveTypesByName.typeFor(name);
    }

    public static Class getTypeFor(String shortName) {
        Class type = typesByNames.typeFor(shortName);
        if (type != null) {
            return type;
        }
        type = primitiveTypesByName.typeFor(shortName);
        if (type != null) {
            return type;
        }
        return CollectionUtil.getCollectionTypeFor(shortName);
    }

    public static String withoutPackageName(String fullTypeName) {
        int dotPos = fullTypeName.lastIndexOf(46);
        return dotPos > 0 ? fullTypeName.substring(dotPos + 1) : fullTypeName;
    }
}

