/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import net.sourceforge.pmd.util.TypeMap;

public class CollectionUtil {
    public static final TypeMap collectionInterfacesByNames = new TypeMap(new Class[]{List.class, Collection.class, Map.class, Set.class});
    public static final TypeMap collectionClassesByNames = new TypeMap(new Class[]{ArrayList.class, LinkedList.class, Vector.class, HashMap.class, LinkedHashMap.class, TreeMap.class, TreeSet.class, HashSet.class, LinkedHashSet.class});

    private CollectionUtil() {
    }

    public static Class getCollectionTypeFor(String shortName) {
        Class cls = collectionClassesByNames.typeFor(shortName);
        if (cls != null) {
            return cls;
        }
        return collectionInterfacesByNames.typeFor(shortName);
    }

    public static boolean isCollectionType(String typeName, boolean includeInterfaces) {
        if (collectionClassesByNames.contains(typeName)) {
            return true;
        }
        return includeInterfaces && collectionInterfacesByNames.contains(typeName);
    }

    public static boolean isCollectionType(Class clazzType, boolean includeInterfaces) {
        if (collectionClassesByNames.contains(clazzType)) {
            return true;
        }
        return includeInterfaces && collectionInterfacesByNames.contains(clazzType);
    }

    public static Set asSet(Object[] items) {
        HashSet<Object> set = new HashSet<Object>(items.length);
        for (int i = 0; i < items.length; ++i) {
            set.add(items[i]);
        }
        return set;
    }

    public static Map mapFrom(Object[][] keyValueSets) {
        HashMap<Object, Object> map = new HashMap<Object, Object>(keyValueSets.length);
        for (int i = 0; i < keyValueSets.length; ++i) {
            map.put(keyValueSets[i][0], keyValueSets[i][1]);
        }
        return map;
    }

    public static Map invertedMapFrom(Map source) {
        HashMap map = new HashMap(source.size());
        Iterator iter = source.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            map.put(entry.getValue(), entry.getKey());
        }
        return map;
    }

    public static final boolean arraysAreEqual(Object value, Object otherValue) {
        if (value instanceof Object[]) {
            if (otherValue instanceof Object[]) {
                return CollectionUtil.valuesAreTransitivelyEqual((Object[])value, (Object[])otherValue);
            }
            return false;
        }
        return false;
    }

    public static final boolean valuesAreTransitivelyEqual(Object[] thisArray, Object[] thatArray) {
        if (thisArray == thatArray) {
            return true;
        }
        if (thisArray == null || thatArray == null) {
            return false;
        }
        if (thisArray.length != thatArray.length) {
            return false;
        }
        for (int i = 0; i < thisArray.length; ++i) {
            if (CollectionUtil.areEqual(thisArray[i], thatArray[i])) continue;
            return false;
        }
        return true;
    }

    public static final boolean areEqual(Object value, Object otherValue) {
        if (value == otherValue) {
            return true;
        }
        if (value == null) {
            return false;
        }
        if (otherValue == null) {
            return false;
        }
        if (value.getClass().getComponentType() != null) {
            return CollectionUtil.arraysAreEqual(value, otherValue);
        }
        return value.equals(otherValue);
    }
}

