/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.retroweaver.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.retroweaver.RefVerifier;
import net.sourceforge.retroweaver.RetroWeaver;
import net.sourceforge.retroweaver.event.VerifierListener;
import net.sourceforge.retroweaver.event.WeaveListener;
import net.sourceforge.retroweaver.runtime.java.lang.Integer_;
import net.sourceforge.retroweaver.translator.NameSpace;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.ExitStatusException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.DirSet;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.commons.EmptyVisitor;

public class RetroWeaverTask
extends Task {
    private File itsDestDir;
    private boolean itsFailOnError = true;
    private final List<FileSet> itsFileSets = new ArrayList<FileSet>();
    private final List<DirSet> itsDirSets = new ArrayList<DirSet>();
    private String inputJar;
    private String outputJar;
    private boolean itsLazy = true;
    private boolean stripSignatures;
    private boolean stripAttributes;
    private boolean itsVerbose = false;
    private Path verifyClasspath;
    private boolean verify = true;
    private int itsVersion = 48;
    private static final Map<String, Integer> itsVersionMap = new HashMap<String, Integer>();
    private List<Namespace> namespaces = new ArrayList<Namespace>();

    public void setDestDir(File pDir) {
        if (!pDir.isDirectory()) {
            throw new BuildException("The destination directory doesn't exist: " + pDir, this.getLocation());
        }
        this.itsDestDir = pDir;
    }

    public void setFailOnError(boolean pFailOnError) {
        this.itsFailOnError = pFailOnError;
    }

    public void addFileSet(FileSet pFileSet) {
        this.itsFileSets.add(pFileSet);
    }

    public void addDirSet(DirSet pFileSet) {
        this.itsDirSets.add(pFileSet);
    }

    public void setLazy(boolean pLazy) {
        this.itsLazy = pLazy;
    }

    public void setSrcDir(File pDir) {
        FileSet fileSet = new FileSet();
        fileSet.setDir(pDir);
        fileSet.setIncludes("**/*.class");
        this.addFileSet(fileSet);
    }

    public void setVerbose(boolean pVerbose) {
        this.itsVerbose = pVerbose;
    }

    public void setTarget(String target) {
        Integer v = itsVersionMap.get(target);
        if (v == null) {
            throw new BuildException("Unknown target: " + target, this.getLocation());
        }
        this.itsVersion = v;
    }

    public void setClasspath(Path classpath) {
        if (this.verifyClasspath == null) {
            this.verifyClasspath = classpath;
        } else {
            this.verifyClasspath.append(classpath);
        }
    }

    public Path createClasspath() {
        if (this.verifyClasspath == null) {
            this.verifyClasspath = new Path(this.getProject());
        }
        return this.verifyClasspath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void setVerify(boolean newVerify) {
        this.verify = newVerify;
    }

    public boolean doVerify() {
        return this.verify;
    }

    public Namespace createNameSpace() {
        Namespace n = new Namespace();
        this.namespaces.add(n);
        return n;
    }

    public void execute() throws BuildException {
        boolean hasFileSet;
        int i$;
        int len$;
        String[] arr$;
        Iterator<DirSet> i$2 = this.itsDirSets.iterator();
        while (i$2.hasNext()) {
            DirSet set = i$2.next();
            File baseDir = set.getDir(this.getProject());
            DirectoryScanner scanner = set.getDirectoryScanner(this.getProject());
            arr$ = scanner.getIncludedDirectories();
            len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                String fileName = arr$[i$];
                FileSet fileSet = new FileSet();
                fileSet.setDir(new File(baseDir, fileName));
                fileSet.setIncludes("*.class");
                this.addFileSet(fileSet);
            }
        }
        boolean bl = hasFileSet = !this.itsFileSets.isEmpty() || !this.itsDirSets.isEmpty();
        if (this.inputJar != null) {
            if (this.outputJar == null) {
                throw new BuildException("'outputjar' must be set.");
            }
            if (hasFileSet) {
                throw new BuildException("'inputjar' is incompatible with filesets and dirsets");
            }
        } else if (!hasFileSet) {
            throw new BuildException("Either attribute 'srcdir' or 'inputjar' must be used or atleast one fileset or dirset must be embedded.", this.getLocation());
        }
        RetroWeaver weaver = new RetroWeaver(this.itsVersion);
        weaver.setLazy(this.itsLazy);
        weaver.setStripSignatures(this.stripSignatures);
        weaver.setStripAttributes(this.stripAttributes);
        ArrayList<NameSpace> l = new ArrayList<NameSpace>();
        Iterator<Namespace> i$3 = this.namespaces.iterator();
        while (i$3.hasNext()) {
            Namespace n = i$3.next();
            l.add(new NameSpace(n.getFrom(), n.getTo()));
        }
        weaver.addNameSpaces(l);
        weaver.setListener(new WeaveListener(){

            public void weavingStarted(String msg) {
                RetroWeaverTask.this.getProject().log((Task)RetroWeaverTask.this, msg, 2);
            }

            public void weavingCompleted(String msg) {
                RetroWeaverTask.this.getProject().log((Task)RetroWeaverTask.this, msg, 2);
            }

            public void weavingError(String msg) {
                RetroWeaverTask.this.getProject().log((Task)RetroWeaverTask.this, msg, 0);
                throw new ExitStatusException("weaving error", 1);
            }

            public void weavingPath(String pPath) {
                if (RetroWeaverTask.this.itsVerbose) {
                    RetroWeaverTask.this.getProject().log((Task)RetroWeaverTask.this, "Weaving " + pPath, 2);
                }
            }
        });
        if (this.verifyClasspath != null && this.doVerify()) {
            ArrayList<String> refPath = new ArrayList<String>();
            arr$ = this.verifyClasspath.list();
            len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                String pathItem = arr$[i$];
                refPath.add(pathItem);
            }
            if (this.itsDestDir != null) {
                refPath.add(this.itsDestDir.getPath());
            }
            RefVerifier rv = new RefVerifier(this.itsVersion, (ClassVisitor)new EmptyVisitor(), refPath, new VerifierListener(){

                public void verifyPathStarted(String msg) {
                    RetroWeaverTask.this.getProject().log((Task)RetroWeaverTask.this, msg, 2);
                }

                public void verifyClassStarted(String msg) {
                    if (RetroWeaverTask.this.itsVerbose) {
                        RetroWeaverTask.this.getProject().log((Task)RetroWeaverTask.this, msg, 2);
                    }
                }

                public void acceptWarning(String msg) {
                    RetroWeaverTask.this.getProject().log((Task)RetroWeaverTask.this, msg, 1);
                }

                public void displaySummary(int warningCount) {
                    String msg = "Verification complete, " + warningCount + " warning(s).";
                    RetroWeaverTask.this.getProject().log((Task)RetroWeaverTask.this, msg, 1);
                    if (RetroWeaverTask.this.itsFailOnError) {
                        throw new ExitStatusException(Integer.toString(warningCount) + " warning(s)", 1);
                    }
                }
            });
            weaver.setVerifier(rv);
        }
        try {
            if (this.inputJar != null) {
                weaver.weaveJarFile(this.inputJar, this.outputJar);
            } else {
                String[][] fileSets = new String[this.itsFileSets.size()][];
                File[] baseDirs = new File[this.itsFileSets.size()];
                int i = 0;
                Iterator<FileSet> i$4 = this.itsFileSets.iterator();
                while (i$4.hasNext()) {
                    FileSet fileSet = i$4.next();
                    File baseDir = fileSet.getDir(this.getProject());
                    DirectoryScanner scanner = fileSet.getDirectoryScanner(this.getProject());
                    fileSets[i] = scanner.getIncludedFiles();
                    baseDirs[i++] = baseDir;
                }
                weaver.weave(baseDirs, fileSets, this.itsDestDir);
            }
        }
        catch (BuildException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new BuildException((Throwable)ex, this.getLocation());
        }
    }

    public String getInputJar() {
        return this.inputJar;
    }

    public void setInputJar(String inputJar) {
        this.inputJar = inputJar;
    }

    public String getOutputJar() {
        return this.outputJar;
    }

    public void setOutputJar(String outputJar) {
        this.outputJar = outputJar;
    }

    public void setStripSignatures(boolean stripSignatures) {
        this.stripSignatures = stripSignatures;
    }

    public void setStripAttributes(boolean stripAttributes) {
        this.stripAttributes = stripAttributes;
    }

    static {
        itsVersionMap.put("1.2", Integer_.valueOf((int)46));
        itsVersionMap.put("1.3", Integer_.valueOf((int)47));
        itsVersionMap.put("1.4", Integer_.valueOf((int)48));
        itsVersionMap.put("1.5", Integer_.valueOf((int)49));
    }

    public static final class Namespace {
        private String from;
        private String to;

        public String getFrom() {
            return this.from;
        }

        public void setFrom(String from) {
            this.from = from;
        }

        public String getTo() {
            return this.to;
        }

        public void setTo(String to) {
            this.to = to;
        }
    }
}

