/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.retroweaver.runtime.java.lang.annotation;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.retroweaver.runtime.java.lang.annotation.Annotation;
import net.sourceforge.retroweaver.runtime.java.lang.annotation.AnnotationFormatError;
import net.sourceforge.retroweaver.runtime.java.lang.annotation.IncompleteAnnotationException;
import net.sourceforge.retroweaver.runtime.java.util.Arrays_;

/*
 * This class specifies class file version 46.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationImpl
implements InvocationHandler,
Annotation {
    private final Class<? extends Annotation> annotationType_;
    private final Map<String, Object> attributes;
    private static final Method cloneMethod;
    private static final /* synthetic */ Class class$java$lang$Object;
    private static final /* synthetic */ Class class$net$sourceforge$retroweaver$runtime$java$lang$annotation$AnnotationImpl;
    private static final /* synthetic */ Class class$net$sourceforge$retroweaver$runtime$java$lang$annotation$Annotation;

    public static Annotation createAnnotation(Class<? extends Annotation> annotationType, Map<String, Object> attributes) {
        try {
            Class<?> clazz = class$net$sourceforge$retroweaver$runtime$java$lang$annotation$AnnotationImpl;
            if (clazz == null) {
                clazz = class$net$sourceforge$retroweaver$runtime$java$lang$annotation$AnnotationImpl = new AnnotationImpl[0].getClass().getComponentType();
            }
            ClassLoader classLoader = clazz.getClassLoader();
            Class[] classArray = new Class[2];
            Class<?> clazz2 = class$net$sourceforge$retroweaver$runtime$java$lang$annotation$Annotation;
            if (clazz2 == null) {
                clazz2 = class$net$sourceforge$retroweaver$runtime$java$lang$annotation$Annotation = new Annotation[0].getClass().getComponentType();
            }
            classArray[0] = clazz2;
            classArray[1] = annotationType;
            return (Annotation)Proxy.newProxyInstance(classLoader, classArray, (InvocationHandler)new AnnotationImpl(annotationType, attributes));
        }
        catch (IllegalArgumentException e) {
            throw new AnnotationFormatError(new StringBuffer().append("Unexpected exception while trying to create an annotation of type: ").append(annotationType).toString(), e);
        }
    }

    private AnnotationImpl(Class<? extends Annotation> annotationType, Map<String, Object> attributes) {
        this.attributes = new HashMap<String, Object>(attributes);
        this.annotationType_ = annotationType;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass().equals(this.annotationType_)) {
            String name = method.getName();
            if (this.attributes.containsKey(name)) {
                Object o = this.attributes.get(name);
                if (o == null) {
                    return null;
                }
                if (o.getClass().isArray()) {
                    o = cloneMethod.invoke(o, new Object[0]);
                }
                return o;
            }
            throw new IncompleteAnnotationException(this.annotationType_, name);
        }
        return method.invoke((Object)this, args);
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return this.annotationType_;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof AnnotationImpl && ((AnnotationImpl)obj).annotationType_ == this.annotationType_;
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public String toString() {
        StringBuffer msg = new StringBuffer();
        msg.append('@').append(this.annotationType_.getName()).append('(');
        boolean first = true;
        for (Map.Entry<String, Object> e : this.attributes.entrySet()) {
            if (first) {
                first = false;
            } else {
                msg.append(", ");
            }
            msg.append(e.getKey()).append('=');
            Object o = e.getValue();
            if (o.getClass().isArray()) {
                msg.append(Arrays_.deepToString((Object[])o));
                continue;
            }
            msg.append(o);
        }
        msg.append(')');
        return msg.toString();
    }

    static {
        try {
            Class<?> clazz = class$java$lang$Object;
            if (clazz == null) {
                clazz = class$java$lang$Object = new Object[0].getClass().getComponentType();
            }
            cloneMethod = clazz.getDeclaredMethod("clone", new Class[0]);
            cloneMethod.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

