# getpkg.py -- Portage binary-package helper functions
# Copyright 2003 Gentoo Technologies, Inc.
# Distributed under the GNU Public License v2
# $Id: $

import types
#from portage.dep.utils import *

class Package:
	"""Data and functional definitions of a package."""
	def __init__(self):
		"""Constructor"""
		self.dict = {}
	
	def __getitem__(self,key):
		if type(key) == types.StringType:
			key = catpkgsplit(key)
			if not key:
				raise KeyError, "Not a valid cpv string '%s'" % key
		elif type(key) == types.ListType:
			if not valid_cpv(key):
				raise KeyError, "Not a valid cpv list '%s'" % key
		else:
			raise KeyError, "Not a valid cpv element '%s'" % key
		myitem = self.dict
		next   = key.pop(0)
		while myitem.has_key(next):
			if myitem.has_key(next):
				myitem = myitem[next]
				next = key.pop(0)
			else:
				raise KeyError, next

	def __setitem__(self,key):
		if type(key) == types.StringType:
			key = catpkgsplit(key)
			if not key:
				raise KeyError, "Not a valid cpv string '%s'" % key
		elif type(key) == types.ListType:
			if not valid_cpv(key):
				raise KeyError, "Not a valid cpv list '%s'" % key
		else:
			raise KeyError, "Not a valid cpv element '%s'" % key
		myitem = self.dict
		while (len(key) > 0):
			myitem = myitem[key.pop(0)]
			next   = key.pop(0)












