# Copyright 1998-2004 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /var/cvsroot/gentoo-src/portage/pym/output.py,v 1.24 2004/10/04 14:07:40 vapier Exp $

import os,sys,re

havecolor=1
dotitles=1

codes={}
codes["reset"]="\x1b[0m"
codes["bold"]="\x1b[01m"

codes["teal"]="\x1b[36;06m"
codes["turquoise"]="\x1b[36;01m"

codes["fuchsia"]="\x1b[35;01m"
codes["purple"]="\x1b[35;06m"

codes["blue"]="\x1b[34;01m"
codes["darkblue"]="\x1b[34;06m"

codes["green"]="\x1b[32;01m"
codes["darkgreen"]="\x1b[32;06m"

codes["yellow"]="\x1b[33;01m"
codes["brown"]="\x1b[33;06m"

codes["red"]="\x1b[31;01m"
codes["darkred"]="\x1b[31;06m"

def nc_len(mystr):
	tmp = re.sub("\x1b[^m]+m", "", mystr);
	return len(tmp)

def xtermTitle(mystr):
	if havecolor and dotitles and os.environ.has_key("TERM"):
		myt=os.environ["TERM"]
		legal_terms = ["xterm","Eterm","aterm","rxvt","screen","kterm","rxvt-unicode"]
		if (myt in legal_terms) or myt.startswith("xterm"):
			sys.stderr.write("\x1b]2;"+str(mystr)+"\x07")
			sys.stderr.flush()

def xtermTitleReset():
	if havecolor and dotitles and os.environ.has_key("TERM"):
		myt=os.environ["TERM"]
		xtermTitle(os.environ["TERM"])


def notitles():
	"turn off title setting"
	dotitles=0

def nocolor():
	"turn off colorization"
	havecolor=0
	for x in codes.keys():
		codes[x]=""

def resetColor():
	return codes["reset"]

def ctext(color,text):
	return codes[ctext]+text+codes["reset"]

def bold(text):
	return codes["bold"]+text+codes["reset"]
def white(text):
	return bold(text)

def teal(text):
	return codes["teal"]+text+codes["reset"]
def turquoise(text):
	return codes["turquoise"]+text+codes["reset"]
def darkteal(text):
	return turquoise(text)

def fuscia(text): # Don't use this one. It's spelled wrong!
	return codes["fuchsia"]+text+codes["reset"]
def fuchsia(text):
	return codes["fuchsia"]+text+codes["reset"]
def purple(text):
	return codes["purple"]+text+codes["reset"]

def blue(text):
	return codes["blue"]+text+codes["reset"]
def darkblue(text):
	return codes["darkblue"]+text+codes["reset"]

def green(text):
	return codes["green"]+text+codes["reset"]
def darkgreen(text):
	return codes["darkgreen"]+text+codes["reset"]

def yellow(text):
	return codes["yellow"]+text+codes["reset"]
def brown(text):
	return codes["brown"]+text+codes["reset"]
def darkyellow(text):
	return brown(text)

def red(text):
	return codes["red"]+text+codes["reset"]
def darkred(text):
	return codes["darkred"]+text+codes["reset"]
