/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.decorator;

import gnu.trove.TFloatHashSet;
import gnu.trove.TFloatIterator;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;

public class TFloatHashSetDecorator
extends AbstractSet
implements Set {
    protected final TFloatHashSet _set;

    public TFloatHashSetDecorator(TFloatHashSet set) {
        this._set = set;
    }

    public Object clone() {
        TFloatHashSet copy = (TFloatHashSet)this._set.clone();
        return new TFloatHashSetDecorator(copy);
    }

    public boolean add(Object value) {
        return this._set.add(this.unwrap(value));
    }

    public boolean equals(Object other) {
        if (this._set.equals(other)) {
            return true;
        }
        if (other instanceof Set) {
            Set that = (Set)other;
            if (that.size() != this._set.size()) {
                return false;
            }
            Iterator it = that.iterator();
            int i = that.size();
            while (i-- > 0) {
                Object val = it.next();
                if (val instanceof Float) {
                    float v = this.unwrap(val);
                    if (this._set.contains(v)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public void clear() {
        this._set.clear();
    }

    public boolean remove(Object value) {
        return this._set.remove(this.unwrap(value));
    }

    public Iterator iterator() {
        return new Iterator(){
            private final TFloatIterator it;
            {
                this.it = TFloatHashSetDecorator.this._set.iterator();
            }

            public Object next() {
                return TFloatHashSetDecorator.this.wrap(this.it.next());
            }

            public boolean hasNext() {
                return this.it.hasNext();
            }

            public void remove() {
                this.it.remove();
            }
        };
    }

    public int size() {
        return this._set.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    protected Float wrap(float k) {
        return new Float(k);
    }

    protected float unwrap(Object value) {
        return ((Float)value).floatValue();
    }
}

