/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.Enumeration;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.AbstractFolder;
import org.openide.filesystems.ExternalUtil;
import org.openide.filesystems.FSException;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.filesystems.StreamPool;
import org.openide.util.enum.EmptyEnumeration;

final class AbstractFileObject
extends AbstractFolder {
    static final long serialVersionUID = -2343651324897646809L;
    private static final char EXT_SEP = '.';
    private static final char PATH_SEP = '/';
    private Reference lock;
    private Boolean folder;
    private Date lastModified = this.lastModified();

    public AbstractFileObject(AbstractFileSystem fs, AbstractFileObject parent, String name) {
        super(fs, parent, name);
    }

    private AbstractFileSystem getAbstractFileSystem() {
        return (AbstractFileSystem)this.getFileSystem();
    }

    private AbstractFileObject getAbstractChild(String name) {
        return (AbstractFileObject)this.getChild(name);
    }

    protected final String[] list() {
        return this.getAbstractFileSystem().list.children(this.getPath());
    }

    protected final AbstractFolder createFile(String name) {
        return this.getAbstractFileSystem().createFileObject(this, name);
    }

    public boolean isFolder() {
        if (this.folder == null) {
            if (this.parent == null || this.getAbstractFileSystem().info.folder(this.getPath())) {
                this.folder = Boolean.TRUE;
                return true;
            }
            this.folder = Boolean.FALSE;
            return false;
        }
        return this.folder;
    }

    public final boolean isData() {
        return !this.isFolder();
    }

    public Date lastModified() {
        if (this.lastModified == null || !this.getAbstractFileSystem().isLastModifiedCacheEnabled()) {
            this.lastModified = this.getAbstractFileSystem().info.lastModified(this.getPath());
        }
        return this.lastModified;
    }

    public boolean isReadOnly() {
        AbstractFileSystem fs = this.getAbstractFileSystem();
        return fs.isReadOnly() || fs.info.readOnly(this.getPath());
    }

    public String getMIMEType() {
        String retVal = this.getAbstractFileSystem().info.mimeType(this.getPath());
        if (retVal == null) {
            retVal = FileUtil.getMIMETypeOrDefault(this);
        }
        return retVal;
    }

    public long getSize() {
        return this.getAbstractFileSystem().info.size(this.getPath());
    }

    public InputStream getInputStream() throws FileNotFoundException {
        InputStream is = this.getAbstractFileSystem().info.inputStream(this.getPath());
        return StreamPool.createInputStream(this, is);
    }

    public OutputStream getOutputStream(FileLock lock) throws IOException {
        return this.getOutputStream(lock, true);
    }

    synchronized OutputStream getOutputStream(FileLock lock, boolean fireFileChanged) throws IOException {
        AbstractFileSystem fs = this.getAbstractFileSystem();
        if (fs.isReadOnly()) {
            FSException.io("EXC_FSisRO", ((FileSystem)fs).getDisplayName());
        }
        if (this.isReadOnly()) {
            FSException.io("EXC_FisRO", this.name, ((FileSystem)fs).getDisplayName());
        }
        this.testLock(lock);
        OutputStream os = this.getAbstractFileSystem().info.outputStream(this.getPath());
        return StreamPool.createOutputStream(this, os, fireFileChanged);
    }

    public synchronized FileLock lock() throws IOException {
        FileLock f;
        if (this.lock != null && (f = (FileLock)this.lock.get()) != null) {
            throw new FileAlreadyLockedException();
        }
        this.getAbstractFileSystem().info.lock(this.getPath());
        AfLock l = new AfLock();
        this.lock = new WeakReference<AfLock>(l);
        return l;
    }

    synchronized void unlock(FileLock fLock) {
        FileLock currentLock = null;
        if (this.lock != null) {
            currentLock = (FileLock)this.lock.get();
        }
        if (currentLock == fLock) {
            this.getAbstractFileSystem().info.unlock(this.getPath());
            this.lastModified = null;
            this.lock = null;
        }
    }

    private void testLock(FileLock l) throws IOException {
        if (this.lock == null) {
            FSException.io("EXC_InvalidLock", l, this.getPath(), this.getAbstractFileSystem().getDisplayName(), this.lock);
        }
        if (this.lock.get() != l) {
            FSException.io("EXC_InvalidLock", l, this.getPath(), this.getAbstractFileSystem().getDisplayName(), this.lock.get());
        }
    }

    public void setImportant(boolean b) {
        this.getAbstractFileSystem().markImportant(this.getPath(), b);
    }

    public Object getAttribute(String attrName) {
        return this.getAttribute(attrName, this.getPath());
    }

    final Object getAttribute(String attrName, String path) {
        return this.getAbstractFileSystem().attr.readAttribute(path, attrName);
    }

    public void setAttribute(String attrName, Object value) throws IOException {
        this.setAttribute(attrName, value, true);
    }

    void setAttribute(String attrName, Object value, boolean fire) throws IOException {
        Object oldValue = null;
        if (fire) {
            oldValue = this.getAttribute(attrName);
        }
        this.getAbstractFileSystem().attr.writeAttribute(this.getPath(), attrName, value);
        if (fire && oldValue != value && this.hasAtLeastOneListeners()) {
            this.fileAttributeChanged0(new FileAttributeEvent(this, attrName, oldValue, value));
        }
    }

    public Enumeration getAttributes() {
        return this.getAttributes(this.getPath());
    }

    final Enumeration getAttributes(String path) {
        return this.getAbstractFileSystem().attr.attributes(path);
    }

    protected final Reference createReference(FileObject fo) {
        return this.getAbstractFileSystem().createReference(fo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject createFolder(String name) throws IOException {
        AbstractFileObject fo;
        try {
            this.getFileSystem().beginAtomicAction();
            AbstractFileObject abstractFileObject = this;
            synchronized (abstractFileObject) {
                AbstractFileSystem fs = this.getAbstractFileSystem();
                if (fs.isReadOnly()) {
                    FSException.io("EXC_FSisRO", fs.getDisplayName());
                }
                if (this.isReadOnly()) {
                    FSException.io("EXC_FisRO", name, fs.getDisplayName());
                }
                if (!this.isFolder()) {
                    FSException.io("EXC_FoNotFolder", name, this.getPath(), fs.getDisplayName());
                }
                this.getAbstractFileSystem().change.createFolder(this.getPath() + '/' + name);
                this.registerChild(name);
                fo = this.getAbstractChild(name);
                if (fo == null) {
                    throw new FileStateInvalidException(FileSystem.getString("EXC_ApplicationCreateError", this.getPath(), name));
                }
                if (this.hasListeners()) {
                    this.fileCreated0(new FileEvent(this, fo), false);
                }
            }
        }
        finally {
            this.getFileSystem().finishAtomicAction();
        }
        return fo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject createData(String name, String ext) throws IOException {
        if (name.indexOf(47) != -1) {
            throw new IllegalArgumentException("Use FileUtil.createData() instead!");
        }
        try {
            this.getFileSystem().beginAtomicAction();
            AbstractFileObject abstractFileObject = this;
            synchronized (abstractFileObject) {
                String n;
                AbstractFileSystem fs = this.getAbstractFileSystem();
                if (fs.isReadOnly()) {
                    FSException.io("EXC_FSisRO", fs.getDisplayName());
                }
                if (this.isReadOnly()) {
                    FSException.io("EXC_FisRO", name, fs.getDisplayName());
                }
                String string = n = ext == null || "".equals(ext) ? name : name + '.' + ext;
                if (!this.isFolder()) {
                    FSException.io("EXC_FoNotFolder", n, this.getPath(), fs.getDisplayName());
                }
                this.getAbstractFileSystem().change.createData(this.getPath() + '/' + n);
                this.registerChild(n);
                AbstractFileObject fo = this.getAbstractChild(n);
                if (fo == null) {
                    throw new FileStateInvalidException(FileSystem.getString("EXC_ApplicationCreateError", this.getPath(), n));
                }
                if (this.hasListeners()) {
                    this.fileCreated0(new FileEvent(this, fo), true);
                }
                AbstractFileObject abstractFileObject2 = fo;
                return abstractFileObject2;
            }
        }
        finally {
            this.getFileSystem().finishAtomicAction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(FileLock lock, String name, String ext) throws IOException {
        if (this.parent == null) {
            FSException.io("EXC_CannotRenameRoot", this.getAbstractFileSystem().getDisplayName());
        }
        if (name.indexOf(47) != -1 || ext != null && ext.indexOf(47) != -1 || name.indexOf(92) != -1 || ext != null && ext.indexOf(92) != -1) {
            FSException.io("EXC_CannotRename", this.getPath(), this.getAbstractFileSystem().getDisplayName(), name + "." + ext);
        }
        try {
            this.getFileSystem().beginAtomicAction();
            String newFullName = null;
            String oldFullName = null;
            AbstractFolder abstractFolder = this.parent;
            synchronized (abstractFolder) {
                this.testLock(lock);
                if (this.isData() && ext != null) {
                    name = name + '.' + ext;
                }
                newFullName = this.parent.getPath() + '/' + name;
                oldFullName = this.getPath();
                if (this.isReadOnly()) {
                    FSException.io("EXC_CannotRename", this.getPath(), this.getAbstractFileSystem().getDisplayName(), newFullName);
                }
                if (this.getFileSystem().isReadOnly()) {
                    FSException.io("EXC_FSisRO", this.getAbstractFileSystem().getDisplayName());
                }
                String on = this.getName();
                String oe = this.getExt();
                this.getAbstractFileSystem().change.rename(oldFullName, newFullName);
                String oldName = this.name;
                this.name = name;
                this.parent.refresh(name, oldName);
                if (this.hasAtLeastOneListeners()) {
                    this.fileRenamed0(new FileRenameEvent((FileObject)this, on, oe));
                }
            }
            this.getAbstractFileSystem().attr.renameAttributes(oldFullName, newFullName);
        }
        finally {
            this.getFileSystem().finishAtomicAction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleDelete(FileLock lock) throws IOException {
        if (this.parent == null) {
            FSException.io("EXC_CannotDeleteRoot", this.getAbstractFileSystem().getDisplayName());
        }
        try {
            String fullName;
            this.getFileSystem().beginAtomicAction();
            AbstractFolder abstractFolder = this.parent;
            synchronized (abstractFolder) {
                this.testLock(lock);
                fullName = this.getPath();
                try {
                    this.getAbstractFileSystem().change.delete(fullName);
                }
                catch (IOException ex) {
                    StreamPool p = StreamPool.find(this);
                    if (p != null) {
                        p.annotate(ex);
                    }
                    throw ex;
                }
                String n = this.name;
                this.validFlag = false;
                this.parent.refresh(null, n, true);
            }
            this.getAbstractFileSystem().attr.deleteAttributes(fullName);
            if (this.hasAtLeastOneListeners()) {
                this.fileDeleted0(new FileEvent(this));
            }
        }
        finally {
            this.getFileSystem().finishAtomicAction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject copy(FileObject target, String name, String ext) throws IOException {
        AbstractFileSystem.Transfer from = this.getAbstractFileSystem().transfer;
        if (from == null || !(target instanceof AbstractFileObject)) {
            return super.copy(target, name, ext);
        }
        AbstractFileObject abstractTarget = (AbstractFileObject)target;
        AbstractFileSystem abstractFS = abstractTarget.getAbstractFileSystem();
        AbstractFileSystem.Transfer to = abstractFS.transfer;
        if (to != null) {
            try {
                this.getFileSystem().beginAtomicAction();
                AbstractFileObject abstractFileObject = abstractTarget;
                synchronized (abstractFileObject) {
                    block14: {
                        String n;
                        if (abstractFS.isReadOnly()) {
                            FSException.io("EXC_FSisRO", abstractFS.getDisplayName());
                        }
                        if (!target.canWrite()) {
                            FSException.io("EXC_FisRO", target.getPath(), abstractFS.getDisplayName());
                        }
                        String string = n = "".equals(ext) ? name : name + '.' + ext;
                        if (!from.copy(this.getPath(), to, target.getPath() + '/' + n)) break block14;
                        abstractTarget.registerChild(n);
                        AbstractFileObject fo = abstractTarget.getAbstractChild(n);
                        if (fo == null) {
                            throw new FileStateInvalidException(FileSystem.getString("EXC_ApplicationCreateError", abstractTarget.getPath(), n));
                        }
                        if (abstractTarget.hasListeners()) {
                            abstractTarget.fileCreated0(new FileEvent(abstractTarget, fo), true);
                        }
                        AbstractFileObject abstractFileObject2 = fo;
                        return abstractFileObject2;
                    }
                }
            }
            finally {
                this.getFileSystem().finishAtomicAction();
            }
        }
        return super.copy(target, name, ext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject move(FileLock lock, FileObject target, String name, String ext) throws IOException {
        AbstractFileSystem.Transfer from;
        AbstractFileSystem fs = this.getAbstractFileSystem();
        if (this.parent == null) {
            FSException.io("EXC_CannotDeleteRoot", fs.getDisplayName());
        }
        if ((from = this.getAbstractFileSystem().transfer) == null || !(target instanceof AbstractFileObject)) {
            return super.move(lock, target, name, ext);
        }
        AbstractFileObject abstractTarget = (AbstractFileObject)target;
        AbstractFileSystem abstractFS = abstractTarget.getAbstractFileSystem();
        AbstractFileSystem.Transfer to = abstractFS.transfer;
        if (to != null) {
            try {
                this.getFileSystem().beginAtomicAction();
                AbstractFolder abstractFolder = this.parent;
                synchronized (abstractFolder) {
                    block16: {
                        this.testLock(lock);
                        if (abstractFS.isReadOnly()) {
                            FSException.io("EXC_FSisRO", abstractFS.getDisplayName());
                        }
                        if (!target.canWrite()) {
                            FSException.io("EXC_FisRO", target.getPath(), abstractFS.getDisplayName());
                        }
                        String n = "".equals(ext) ? name : name + '.' + ext;
                        String fullName = this.getPath();
                        if (!from.move(fullName, to, target.getPath() + '/' + n)) break block16;
                        String oldN = name;
                        this.validFlag = false;
                        this.parent.refresh(null, oldN);
                        abstractTarget.registerChild(n);
                        AbstractFileObject fo = abstractTarget.getAbstractChild(n);
                        if (fo == null) {
                            throw new FileStateInvalidException(FileSystem.getString("EXC_ApplicationCreateError", abstractTarget.getPath(), n));
                        }
                        if (this.hasAtLeastOneListeners()) {
                            this.fileDeleted0(new FileEvent(this));
                        }
                        if (abstractTarget.hasListeners()) {
                            abstractTarget.fileCreated0(new FileEvent(abstractTarget, fo), true);
                        }
                        AbstractFileObject abstractFileObject = fo;
                        return abstractFileObject;
                    }
                }
            }
            finally {
                this.getFileSystem().finishAtomicAction();
            }
        }
        return super.move(lock, target, name, ext);
    }

    public boolean isVirtual() {
        return this.getAbstractFileSystem().checkVirtual(this.getPath());
    }

    protected void refresh(String added, String removed, boolean fire, boolean expected) {
        this.refresh(added, removed, fire, expected, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void refresh(String added, String removed, boolean fire, boolean expected, String[] list) {
        block16: {
            ev = null;
            refreshParent = false;
            this.getFileSystem().beginAtomicAction();
            var8_8 = this;
            synchronized (var8_8) {
                if (this.isFolder()) {
                    super.refresh(added, removed, fire, expected, list);
                    break block16;
                }
                strPool = StreamPool.find(this);
                if (strPool != null && strPool.isOutputStreamOpen()) {
                    // MONITOREXIT @DISABLED, blocks:[0, 5, 14] lbl12 : MonitorExitStatement: MONITOREXIT : var8_8
                    this.getFileSystem().finishAtomicAction();
                    return;
                }
                l = null;
                if (this.lastModified != null) ** break block17
                this.lastModified = l = this.getAbstractFileSystem().info.lastModified(this.getPath());
            }
            this.getFileSystem().finishAtomicAction();
            return;
            {
                ** try [egrp 3[TRYBLOCK] [6 : 113->278)] { 
lbl25:
                // 1 sources

                l = this.getAbstractFileSystem().info.lastModified(this.getPath());
                if (Math.abs(this.lastModified.getTime() - l.getTime()) != 0L) {
                    this.lastModified = l;
                    if (fire && this.hasAtLeastOneListeners()) {
                        ev = new FileEvent((FileObject)this, (FileObject)this, expected);
                    }
                    if (l.getTime() == 0L) {
                        this.validFlag = false;
                        if (ev != null) {
                            this.fileDeleted0(ev);
                        }
                        refreshParent = true;
                    } else if (ev != null) {
                        this.fileChanged0(ev);
                    }
                }
            }
        }
        if (refreshParent == false) return;
        if (this.parent.getFileObject(this.getName(), this.getExt()) == null) return;
        this.parent.refreshFolder(null, this.getNameExt(), fire, expected, null);
        return;
lbl-1000:
        // 1 sources

        {
            finally {
                this.getFileSystem().finishAtomicAction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void outputStreamClosed(boolean fireFileChanged) {
        AbstractFileObject abstractFileObject = this;
        synchronized (abstractFileObject) {
            this.lastModified = null;
            this.lastModified();
        }
        super.outputStreamClosed(fireFileChanged);
    }

    public boolean canWrite() {
        AbstractFileSystem fs = this.getAbstractFileSystem();
        return fs.canWrite(this.getPath());
    }

    public boolean canRead() {
        AbstractFileSystem fs = this.getAbstractFileSystem();
        return fs.canRead(this.getPath());
    }

    final boolean superCanWrite() {
        return super.canWrite();
    }

    final boolean superCanRead() {
        return super.canRead();
    }

    static final class Replace
    implements Serializable {
        static final long serialVersionUID = -8543432135435542113L;
        private String fsName;
        private String fileName;

        public Replace(String fsName, String fileName) {
            this.fsName = fsName;
            this.fileName = fileName;
        }

        public Object readResolve() {
            Repository rep = ExternalUtil.getRepository();
            FileSystem fs = rep.findFileSystem(this.fsName);
            FileObject fo = null;
            if (fs != null) {
                fo = fs.findResource(this.fileName);
            }
            if (fo == null) {
                return new Invalid(this.fsName, this.fileName);
            }
            return fo;
        }
    }

    static final class Invalid
    extends FileObject {
        static final long serialVersionUID = -4558997829579415276L;
        private String name;
        private String fileSystemName;
        private static final Invalid ROOT = new Invalid("");

        public Invalid(String name) {
            int i = name.lastIndexOf(47) + 1;
            this.name = i == 0 || i == name.length() ? name : name.substring(i);
        }

        public Invalid(String fs, String name) {
            this(name);
            this.fileSystemName = fs;
        }

        public String getName() {
            int i = this.name.lastIndexOf(46);
            return i <= 0 ? this.name : this.name.substring(0, i);
        }

        public String getExt() {
            int i = this.name.lastIndexOf(46) + 1;
            return i <= 1 || i == this.name.length() ? "" : this.name.substring(i);
        }

        public FileSystem getFileSystem() throws FileStateInvalidException {
            throw new FileStateInvalidException(null, this.name + "[" + this.fileSystemName + "]");
        }

        public boolean isRoot() {
            return this == ROOT;
        }

        public boolean isFolder() {
            return this == ROOT;
        }

        public Date lastModified() {
            return new Date();
        }

        public boolean isData() {
            return false;
        }

        public boolean isReadOnly() {
            return false;
        }

        public boolean isValid() {
            return false;
        }

        public String getMIMEType() {
            return "content/unknown";
        }

        public long getSize() {
            return 0L;
        }

        public InputStream getInputStream() throws FileNotFoundException {
            throw new FileNotFoundException();
        }

        public synchronized OutputStream getOutputStream(FileLock lock) throws IOException {
            throw new IOException();
        }

        public synchronized FileLock lock() throws IOException {
            throw new IOException();
        }

        public void setImportant(boolean b) {
        }

        public Object getAttribute(String attrName) {
            return null;
        }

        public void setAttribute(String attrName, Object value) throws IOException {
            throw new IOException();
        }

        public Enumeration getAttributes() {
            return EmptyEnumeration.EMPTY;
        }

        public synchronized FileObject createFolder(String name) throws IOException {
            throw new IOException();
        }

        public synchronized FileObject createData(String name, String ext) throws IOException {
            throw new IOException();
        }

        public void rename(FileLock lock, String name, String ext) throws IOException {
            throw new IOException();
        }

        public void delete(FileLock lock) throws IOException {
            throw new IOException();
        }

        public FileObject getParent() {
            return this == ROOT ? null : ROOT;
        }

        public synchronized FileObject[] getChildren() {
            return new FileObject[0];
        }

        public synchronized FileObject getFileObject(String name, String ext) {
            return null;
        }

        public void refresh() {
        }

        public void addFileChangeListener(FileChangeListener fcl) {
        }

        public void removeFileChangeListener(FileChangeListener fcl) {
        }
    }

    private class AfLock
    extends FileLock {
        AfLock() {
        }

        public void releaseLock() {
            if (this.isValid()) {
                super.releaseLock();
                AbstractFileObject.this.unlock(this);
            }
        }
    }
}

