/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SyncFailedException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLStreamHandler;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.openide.ErrorManager;
import org.openide.filesystems.AbstractFileObject;
import org.openide.filesystems.DefaultAttributes;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileURL;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.MIMESupport;
import org.openide.filesystems.URLMapper;
import org.openide.filesystems.XMLMapAttr;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public final class FileUtil {
    private static byte[] ZIP_HEADER;
    static final Set transientAttributes;
    private static Dictionary map;
    private static final Map archiveFileCache;
    static final /* synthetic */ boolean $assertionsDisabled;

    private FileUtil() {
    }

    public static void copy(InputStream is, OutputStream os) throws IOException {
        byte[] BUFFER = new byte[4096];
        int len;
        while ((len = is.read(BUFFER)) != -1) {
            os.write(BUFFER, 0, len);
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FileObject copyFileImpl(FileObject source, FileObject destFolder, String newName, String newExt) throws IOException {
        OutputStream bufOut;
        FileLock lock;
        FileObject dest;
        block7: {
            dest = destFolder.createData(newName, newExt);
            lock = null;
            InputStream bufIn = null;
            bufOut = null;
            try {
                lock = dest.lock();
                bufIn = source.getInputStream();
                bufOut = dest instanceof AbstractFileObject ? ((AbstractFileObject)dest).getOutputStream(lock, false) : dest.getOutputStream(lock);
                FileUtil.copy(bufIn, bufOut);
                FileUtil.copyAttributes(source, dest);
                Object var9_8 = null;
                if (bufIn == null) break block7;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (bufIn != null) {
                    bufIn.close();
                }
                if (bufOut != null) {
                    bufOut.close();
                }
                if (lock != null) {
                    lock.releaseLock();
                }
                throw throwable;
            }
            bufIn.close();
        }
        if (bufOut != null) {
            bufOut.close();
        }
        if (lock != null) {
            lock.releaseLock();
        }
        return dest;
    }

    public static FileObject copyFile(FileObject source, FileObject destFolder, String newName, String newExt) throws IOException {
        return source.copy(destFolder, newName, newExt);
    }

    public static FileObject copyFile(FileObject source, FileObject destFolder, String newName) throws IOException {
        return FileUtil.copyFile(source, destFolder, newName, source.getExt());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileObject moveFile(FileObject source, FileObject destFolder, String newName) throws IOException {
        FileLock lock = null;
        try {
            lock = source.lock();
            FileObject fileObject = source.move(lock, destFolder, newName, source.getExt());
            return fileObject;
        }
        finally {
            if (lock != null) {
                lock.releaseLock();
            }
        }
    }

    public static FileObject createFolder(FileObject folder, String name) throws IOException {
        String separators = File.separatorChar != '/' ? "/" + File.separatorChar : "/";
        StringTokenizer st = new StringTokenizer(name, separators);
        while (st.hasMoreElements()) {
            FileObject f;
            block4: {
                name = st.nextToken();
                if (name.length() <= 0) continue;
                f = folder.getFileObject(name);
                if (f == null) {
                    try {
                        f = folder.createFolder(name);
                    }
                    catch (SyncFailedException ex) {
                        folder.refresh();
                        f = folder.getFileObject(name);
                        if (f != null) break block4;
                        throw ex;
                    }
                }
            }
            folder = f;
        }
        return folder;
    }

    public static FileObject createData(FileObject folder, String name) throws IOException {
        FileObject data;
        block11: {
            String ext;
            String fname;
            String dataname;
            if (folder == null) {
                throw new IllegalArgumentException("Null folder");
            }
            if (name == null) {
                throw new IllegalArgumentException("Null name");
            }
            int index = name.lastIndexOf(47);
            if (index >= name.length()) {
                throw new IOException("Wrong file name.");
            }
            if (index != -1) {
                String foldername = name.substring(0, index);
                dataname = name.substring(index + 1);
                folder = FileUtil.createFolder(folder, foldername);
                if (!$assertionsDisabled && folder == null) {
                    throw new AssertionError();
                }
            } else {
                dataname = name;
            }
            if ((index = dataname.lastIndexOf(46)) != -1) {
                fname = dataname.substring(0, index);
                ext = dataname.substring(index + 1);
            } else {
                fname = dataname;
                ext = "";
            }
            data = folder.getFileObject(fname, ext);
            if (data == null) {
                try {
                    data = folder.createData(fname, ext);
                }
                catch (SyncFailedException ex) {
                    folder.refresh();
                    data = folder.getFileObject(fname, ext);
                    if (data != null) break block11;
                    throw ex;
                }
            }
        }
        return data;
    }

    public static File toFile(FileObject fo) {
        File retVal = (File)fo.getAttribute("java.io.File");
        if (retVal == null) {
            URL fileURL = null;
            int[] types = new int[]{0, 1};
            for (int i = 0; (fileURL == null || "file".equals(fileURL.getProtocol())) && i < types.length; ++i) {
                fileURL = URLMapper.findURL(fo, types[i]);
            }
            if (fileURL != null && "file".equals(fileURL.getProtocol())) {
                retVal = new File(URI.create(fileURL.toExternalForm()));
            }
            retVal = retVal != null ? FileUtil.normalizeFile(retVal) : null;
        }
        return retVal;
    }

    public static FileObject toFileObject(File file) throws IllegalArgumentException {
        FileObject retVal;
        if (!file.equals(FileUtil.normalizeFile(file))) {
            throw new IllegalArgumentException("Parameter file was not normalized. Was " + file + " instead of " + FileUtil.normalizeFile(file));
        }
        try {
            retVal = URLMapper.findFileObject(FileUtil.fileToURL(file));
        }
        catch (MalformedURLException e) {
            retVal = null;
        }
        return retVal;
    }

    static URL fileToURL(File file) throws MalformedURLException {
        URL retVal = null;
        retVal = !FileUtil.isWindowsDriveRoot(file) ? file.toURI().toURL() : new URL("file:/" + file.getAbsolutePath());
        return retVal;
    }

    private static boolean isWindowsDriveRoot(File file) {
        return Utilities.isWindows() && file.getParent() == null;
    }

    public static FileObject[] fromFile(File file) {
        FileObject[] retVal;
        if (!file.equals(FileUtil.normalizeFile(file))) {
            throw new IllegalArgumentException("Parameter file was not normalized. Was " + file + " instead of " + FileUtil.normalizeFile(file));
        }
        try {
            retVal = URLMapper.findFileObjects(file.toURI().toURL());
        }
        catch (MalformedURLException e) {
            retVal = null;
        }
        return retVal;
    }

    public static void copyAttributes(FileObject source, FileObject dest) throws IOException {
        Enumeration attrKeys = source.getAttributes();
        while (attrKeys.hasMoreElements()) {
            Object value;
            String key = (String)attrKeys.nextElement();
            if (transientAttributes.contains(key) || FileUtil.isTransient(source, key) || (value = source.getAttribute(key)) == null) continue;
            dest.setAttribute(key, value);
        }
    }

    static boolean isTransient(FileObject fo, String attrName) {
        return XMLMapAttr.ModifiedAttribute.isTransient(fo, attrName);
    }

    public static void extractJar(final FileObject fo, final InputStream is) throws IOException {
        FileSystem fs = fo.getFileSystem();
        fs.runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                FileUtil.extractJarImpl(fo, is);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractJarImpl(FileObject fo, InputStream is) throws IOException {
        JarEntry je;
        HashMap<String, DefaultAttributes.Table> attributes = new HashMap<String, DefaultAttributes.Table>(7);
        JarInputStream jis = new JarInputStream(is);
        while ((je = jis.getNextJarEntry()) != null) {
            String name = je.getName();
            if (name.toLowerCase().startsWith("meta-inf/")) continue;
            if (je.isDirectory()) {
                FileUtil.createFolder(fo, name);
                continue;
            }
            if (DefaultAttributes.acceptName(name)) {
                DefaultAttributes.Table table = DefaultAttributes.loadTable(jis, name);
                attributes.put(name, table);
                continue;
            }
            FileObject fd = FileUtil.createData(fo, name);
            FileLock lock = fd.lock();
            try {
                OutputStream os = fd.getOutputStream(lock);
                try {
                    FileUtil.copy(jis, os);
                }
                finally {
                    os.close();
                }
            }
            finally {
                lock.releaseLock();
            }
        }
        Iterator it = attributes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String fileName = (String)entry.getKey();
            int last = fileName.lastIndexOf(47);
            String dirName = last != -1 ? fileName.substring(0, last + 1) : "";
            String prefix = fo.isRoot() ? dirName : fo.getPath() + '/' + dirName;
            DefaultAttributes.Table t = (DefaultAttributes.Table)entry.getValue();
            Iterator files = t.keySet().iterator();
            while (files.hasNext()) {
                String orig = (String)files.next();
                String fn = prefix + orig;
                FileObject obj = fo.getFileSystem().findResource(fn);
                if (obj == null) continue;
                Enumeration attrEnum = t.attrs(orig);
                while (attrEnum.hasMoreElements()) {
                    String attrName = (String)attrEnum.nextElement();
                    Object value = t.getAttr(orig, attrName);
                    if (value == null) continue;
                    obj.setAttribute(attrName, value);
                }
            }
        }
    }

    public static String getExtension(String fileName) {
        int index = fileName.lastIndexOf(".");
        if (index == -1) {
            return "";
        }
        return fileName.substring(index + 1);
    }

    public static String findFreeFileName(FileObject folder, String name, String ext) {
        if (FileUtil.checkFreeName(folder, name, ext)) {
            return name;
        }
        int i = 1;
        String destName;
        while (!FileUtil.checkFreeName(folder, destName = name + "_" + i, ext)) {
            ++i;
        }
        return destName;
    }

    public static String findFreeFolderName(FileObject folder, String name) {
        if (FileUtil.checkFreeName(folder, name, null)) {
            return name;
        }
        int i = 1;
        String destName;
        while (!FileUtil.checkFreeName(folder, destName = name + "_" + i, null)) {
            ++i;
        }
        return destName;
    }

    public static String getRelativePath(FileObject folder, FileObject fo) {
        if (!FileUtil.isParentOf(folder, fo) && folder != fo) {
            return null;
        }
        String result = fo.getPath().substring(folder.getPath().length());
        if (result.startsWith("/")) {
            result = result.substring(1);
        }
        return result;
    }

    private static boolean checkFreeName(FileObject fo, String name, String ext) {
        if (Utilities.isWindows()) {
            Enumeration en = fo.getChildren(false);
            while (en.hasMoreElements()) {
                fo = (FileObject)en.nextElement();
                String n = fo.getName();
                String e = fo.getExt();
                if (!n.equalsIgnoreCase(name)) continue;
                if (!(ext != null && ext.trim().length() != 0 || e != null && e.trim().length() != 0)) {
                    return fo.isVirtual();
                }
                if (ext == null || e == null || !ext.equalsIgnoreCase(e)) continue;
                return fo.isVirtual();
            }
            return true;
        }
        if (ext == null) {
            if ((fo = fo.getFileObject(name)) == null) {
                return true;
            }
            return fo.isVirtual();
        }
        if ((fo = fo.getFileObject(name, ext)) == null) {
            return true;
        }
        return fo.isVirtual();
    }

    public static FileObject findBrother(FileObject fo, String ext) {
        if (fo == null) {
            return null;
        }
        FileObject parent = fo.getParent();
        if (parent == null) {
            return null;
        }
        return parent.getFileObject(fo.getName(), ext);
    }

    public static String getMIMEType(String ext) {
        String s = (String)map.get(ext);
        if (s != null) {
            return s;
        }
        return (String)map.get(ext.toLowerCase());
    }

    public static String getMIMEType(FileObject fo) {
        String retVal = MIMESupport.findMIMEType(fo, null);
        if (retVal == null) {
            retVal = FileUtil.getMIMEType(fo.getExt());
        }
        return retVal;
    }

    static String getMIMETypeOrDefault(FileObject fo) {
        String def = FileUtil.getMIMEType(fo.getExt());
        String t = MIMESupport.findMIMEType(fo, def);
        if (t == null) {
            t = "content/unknown";
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMIMEType(String ext, String mimeType) {
        Dictionary dictionary = map;
        synchronized (dictionary) {
            String old = (String)map.get(ext);
            if (old == null) {
                map.put(ext, mimeType);
            } else if (!old.equals(mimeType)) {
                throw new IllegalArgumentException("Cannot overwrite existing MIME type mapping for extension `" + ext + "' with " + mimeType + " (was " + old + ")");
            }
        }
    }

    public static URLStreamHandler nbfsURLStreamHandler() {
        return FileURL.HANDLER;
    }

    public static boolean isParentOf(FileObject folder, FileObject fo) {
        if (folder.isData()) {
            return false;
        }
        try {
            if (folder.getFileSystem() != fo.getFileSystem()) {
                return false;
            }
        }
        catch (FileStateInvalidException e) {
            return false;
        }
        for (FileObject parent = fo.getParent(); parent != null; parent = parent.getParent()) {
            if (parent != folder) continue;
            return true;
        }
        return false;
    }

    public static FileChangeListener weakFileChangeListener(FileChangeListener l, Object source) {
        return (FileChangeListener)WeakListeners.create((Class)FileChangeListener.class, (EventListener)l, (Object)source);
    }

    public static FileStatusListener weakFileStatusListener(FileStatusListener l, Object source) {
        return (FileStatusListener)WeakListeners.create((Class)FileStatusListener.class, (EventListener)l, (Object)source);
    }

    public static File normalizeFile(File file) {
        if (Utilities.isWindows()) {
            if (!FileUtil.isWindowsDriveRoot(file)) {
                try {
                    file = file.getCanonicalFile();
                }
                catch (IOException e) {
                    ErrorManager.getDefault().log(65536, "getCanonicalFile() on file " + file + " failed. " + e.toString());
                    file = file.getAbsoluteFile();
                }
            } else {
                file = file.getAbsoluteFile();
            }
        } else {
            file = new File(file.toURI().normalize()).getAbsoluteFile();
        }
        return file;
    }

    public static FileObject getArchiveRoot(FileObject fo) {
        URL archiveURL = URLMapper.findURL(fo, 1);
        if (archiveURL == null) {
            return null;
        }
        return URLMapper.findFileObject(FileUtil.getArchiveRoot(archiveURL));
    }

    public static URL getArchiveRoot(URL url) {
        try {
            return new URL("jar:" + url + "!/");
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static FileObject getArchiveFile(FileObject fo) {
        try {
            FileSystem fs = fo.getFileSystem();
            if (fs instanceof JarFileSystem) {
                File jarFile = ((JarFileSystem)fs).getJarFile();
                return FileUtil.toFileObject(jarFile);
            }
        }
        catch (FileStateInvalidException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        return null;
    }

    public static URL getArchiveFile(URL url) {
        String path;
        int index;
        String protocol = url.getProtocol();
        if ("jar".equals(protocol) && (index = (path = url.getPath()).indexOf("!/")) >= 0) {
            try {
                return new URL(path.substring(0, index));
            }
            catch (MalformedURLException mue) {
                ErrorManager.getDefault().notify((Throwable)mue);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isArchiveFile(FileObject fo) {
        if (fo == null) {
            throw new IllegalArgumentException("Cannot pass null to FileUtil.isArchiveFile");
        }
        if (fo.isFolder()) {
            return false;
        }
        Boolean b = (Boolean)archiveFileCache.get(fo);
        if (b == null) {
            try {
                InputStream in = fo.getInputStream();
                try {
                    byte[] buffer = new byte[4];
                    int len = in.read(buffer, 0, 4);
                    b = len == 4 ? Boolean.valueOf(Arrays.equals(ZIP_HEADER, buffer)) : Boolean.FALSE;
                }
                finally {
                    in.close();
                }
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify(1, (Throwable)ioe);
                b = Boolean.FALSE;
            }
            archiveFileCache.put(fo, b);
        }
        return b;
    }

    public static boolean isArchiveFile(URL url) {
        FileObject fo = URLMapper.findFileObject(url);
        if (fo != null) {
            return FileUtil.isArchiveFile(fo);
        }
        String urlPath = url.getPath();
        int index = urlPath.lastIndexOf(46);
        return index != -1 && index > urlPath.lastIndexOf(47);
    }

    static {
        $assertionsDisabled = !FileUtil.class.desiredAssertionStatus();
        ZIP_HEADER = new byte[]{80, 75, 3, 4};
        transientAttributes = new HashSet();
        transientAttributes.add("templateWizardURL");
        transientAttributes.add("templateWizardIterator");
        transientAttributes.add("templateWizardDescResource");
        transientAttributes.add("SystemFileSystem.localizingBundle");
        transientAttributes.add("SystemFileSystem.icon");
        transientAttributes.add("SystemFileSystem.icon32");
        map = new Hashtable();
        FileUtil.setMIMEType("uu", "application/octet-stream");
        FileUtil.setMIMEType("exe", "application/octet-stream");
        FileUtil.setMIMEType("ps", "application/postscript");
        FileUtil.setMIMEType("zip", "application/zip");
        FileUtil.setMIMEType("class", "application/octet-stream");
        FileUtil.setMIMEType("jar", "application/x-jar");
        FileUtil.setMIMEType("sh", "application/x-shar");
        FileUtil.setMIMEType("tar", "application/x-tar");
        FileUtil.setMIMEType("snd", "audio/basic");
        FileUtil.setMIMEType("au", "audio/basic");
        FileUtil.setMIMEType("wav", "audio/x-wav");
        FileUtil.setMIMEType("gif", "image/gif");
        FileUtil.setMIMEType("jpg", "image/jpeg");
        FileUtil.setMIMEType("jpeg", "image/jpeg");
        FileUtil.setMIMEType("htm", "text/html");
        FileUtil.setMIMEType("html", "text/html");
        FileUtil.setMIMEType("xml", "text/xml");
        FileUtil.setMIMEType("xsl", "text/xml");
        FileUtil.setMIMEType("xsd", "text/xml");
        FileUtil.setMIMEType("dtd", "text/x-dtd");
        FileUtil.setMIMEType("css", "text/css");
        FileUtil.setMIMEType("text", "text/plain");
        FileUtil.setMIMEType("pl", "text/plain");
        FileUtil.setMIMEType("txt", "text/plain");
        FileUtil.setMIMEType("properties", "text/plain");
        FileUtil.setMIMEType("java", "text/x-java");
        FileUtil.setMIMEType("ra", "audio/x-pn-realaudio");
        FileUtil.setMIMEType("ram", "audio/x-pn-realaudio");
        FileUtil.setMIMEType("rm", "audio/x-pn-realaudio");
        FileUtil.setMIMEType("rpm", "audio/x-pn-realaudio");
        FileUtil.setMIMEType("mov", "video/quicktime");
        FileUtil.setMIMEType("jsp", "text/plain");
        archiveFileCache = new WeakHashMap();
    }
}

