/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jdom.Comment;
import org.jdom.DocType;
import org.jdom.Element;
import org.jdom.IllegalAddException;
import org.jdom.PartialList;
import org.jdom.ProcessingInstruction;

public class Document
implements Serializable,
Cloneable {
    protected List content;
    protected Element rootElement;
    protected DocType docType;

    protected Document() {
    }

    public Document(Element rootElement) {
        this(rootElement, null);
    }

    public Document(Element rootElement, DocType docType) {
        this.rootElement = rootElement;
        this.docType = docType;
        this.content = new LinkedList();
        if (rootElement != null) {
            rootElement.setDocument(this);
            this.content.add(rootElement);
        }
    }

    public Document addComment(Comment c) {
        return this.addContent(c);
    }

    public Document addContent(Comment comment) {
        this.content.add(comment);
        return this;
    }

    public Document addContent(Element element) {
        if (this.getRootElement() != null) {
            throw new IllegalAddException(this, element, "The document already has a root element");
        }
        this.setRootElement(element);
        return this;
    }

    public Document addContent(ProcessingInstruction pi) {
        this.content.add(pi);
        return this;
    }

    public Document addProcessingInstruction(String target, String data) {
        return this.addContent(new ProcessingInstruction(target, data));
    }

    public Document addProcessingInstruction(String target, Map data) {
        return this.addContent(new ProcessingInstruction(target, data));
    }

    public Document addProcessingInstruction(ProcessingInstruction pi) {
        return this.addContent(pi);
    }

    public final Object clone() {
        Document doc = new Document(null);
        Iterator i = this.content.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (obj instanceof Element) {
                Element e = (Element)obj;
                doc.addContent((Element)e.clone());
                continue;
            }
            if (obj instanceof Comment) {
                Comment c = (Comment)obj;
                doc.addContent((Comment)c.clone());
                continue;
            }
            if (!(obj instanceof ProcessingInstruction)) continue;
            ProcessingInstruction pi = (ProcessingInstruction)obj;
            doc.addContent((ProcessingInstruction)pi.clone());
        }
        if (this.docType != null) {
            doc.docType = (DocType)this.docType.clone();
        }
        return doc;
    }

    public final boolean equals(Object ob) {
        return ob == this;
    }

    public DocType getDocType() {
        return this.docType;
    }

    public List getMixedContent() {
        return this.content;
    }

    public ProcessingInstruction getProcessingInstruction(String target) {
        Iterator i = this.content.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (!(obj instanceof ProcessingInstruction) || !((ProcessingInstruction)obj).getTarget().equals(target)) continue;
            return (ProcessingInstruction)obj;
        }
        return null;
    }

    public List getProcessingInstructions() {
        PartialList pis = new PartialList(this.content);
        Iterator i = this.content.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (!(obj instanceof ProcessingInstruction)) continue;
            pis.addPartial(obj);
        }
        return pis;
    }

    public List getProcessingInstructions(String target) {
        PartialList pis = new PartialList(this.content);
        Iterator i = this.content.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (!(obj instanceof ProcessingInstruction) || !((ProcessingInstruction)obj).getTarget().equals(target)) continue;
            pis.addPartial(obj);
        }
        return pis;
    }

    public Element getRootElement() {
        return this.rootElement;
    }

    public final String getSerializedForm() {
        throw new RuntimeException("Document.getSerializedForm() is not yet implemented");
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public boolean removeProcessingInstruction(String target) {
        ProcessingInstruction pi = this.getProcessingInstruction(target);
        if (pi == null) {
            return false;
        }
        return this.content.remove(pi);
    }

    public boolean removeProcessingInstruction(ProcessingInstruction pi) {
        return this.getMixedContent().remove(pi);
    }

    public boolean removeProcessingInstructions(String target) {
        boolean deletedSome = false;
        Iterator i = this.content.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (!(obj instanceof ProcessingInstruction) || !((ProcessingInstruction)obj).getTarget().equals(target)) continue;
            deletedSome = true;
            i.remove();
        }
        return deletedSome;
    }

    public Document setDocType(DocType docType) {
        this.docType = docType;
        return this;
    }

    public Document setMixedContent(List content) {
        content.clear();
        this.rootElement = null;
        Iterator i = content.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (obj instanceof Element) {
                this.addContent((Element)obj);
                continue;
            }
            if (obj instanceof Comment) {
                this.addContent((Comment)obj);
                continue;
            }
            if (obj instanceof ProcessingInstruction) {
                this.addContent((ProcessingInstruction)obj);
                continue;
            }
            throw new IllegalAddException("A Document may contain only objects of type Element, Comment, and ProcessingInstruction");
        }
        return this;
    }

    public Document setProcessingInstructions(List pis) {
        List current = this.getProcessingInstructions();
        Iterator i = current.iterator();
        while (i.hasNext()) {
            i.remove();
        }
        this.content.addAll(pis);
        return this;
    }

    public Document setRootElement(Element rootElement) {
        int rootLocation = this.content.size();
        if (this.rootElement != null) {
            this.rootElement.setDocument(null);
            rootLocation = this.content.indexOf(this.rootElement);
            this.content.remove(rootLocation);
        }
        if (rootElement != null) {
            rootElement.setDocument(this);
            this.content.add(rootLocation, rootElement);
        }
        this.rootElement = rootElement;
        return this;
    }

    public final String toString() {
        StringBuffer stringForm = new StringBuffer().append("[Document: ");
        if (this.docType != null) {
            stringForm.append(this.docType.toString()).append(" ");
        } else {
            stringForm.append(" No DOCTYPE declaration. ");
        }
        if (this.rootElement != null) {
            stringForm.append("Root - ").append(this.rootElement.toString());
        } else {
            stringForm.append(" No Root Element.");
        }
        stringForm.append("]");
        return stringForm.toString();
    }
}

