/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.activities;

import edu.umd.cs.piccolo.activities.PActivityScheduler;
import edu.umd.cs.piccolo.util.PUtil;

public class PActivity {
    private PActivityScheduler scheduler;
    private long startTime;
    private long duration;
    private long stepRate;
    private PActivityDelegate delegate;
    private boolean stepping;
    private long nextStepTime;

    public PActivity(long aDuration) {
        this(aDuration, PUtil.DEFAULT_ACTIVITY_STEP_RATE);
    }

    public PActivity(long aDuration, long aStepRate) {
        this(aDuration, aStepRate, System.currentTimeMillis());
    }

    public PActivity(long aDuration, long aStepRate, long aStartTime) {
        this.duration = aDuration;
        this.stepRate = aStepRate;
        this.startTime = aStartTime;
        this.nextStepTime = aStartTime;
        this.stepping = false;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long aTriggerTime) {
        this.startTime = aTriggerTime;
    }

    public long getStepRate() {
        return this.stepRate;
    }

    public void setStepRate(long aStepRate) {
        this.stepRate = aStepRate;
    }

    public long getNextStepTime() {
        return this.nextStepTime;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long aDuration) {
        this.duration = aDuration;
    }

    public PActivityScheduler getActivityScheduler() {
        return this.scheduler;
    }

    public void setActivityScheduler(PActivityScheduler aScheduler) {
        this.scheduler = aScheduler;
    }

    public boolean isStepping() {
        return this.stepping;
    }

    protected boolean isAnimation() {
        return false;
    }

    protected void activityStarted() {
        if (this.delegate != null) {
            this.delegate.activityStarted(this);
        }
    }

    protected void activityStep(long elapsedTime) {
        if (this.delegate != null) {
            this.delegate.activityStepped(this);
        }
    }

    protected void activityFinished() {
        if (this.delegate != null) {
            this.delegate.activityFinished(this);
        }
    }

    public PActivityDelegate getDelegate() {
        return this.delegate;
    }

    public void setDelegate(PActivityDelegate delegate) {
        this.delegate = delegate;
    }

    public void startAfter(PActivity first) {
        this.setStartTime(first.getStartTime() + first.getDuration());
    }

    public void terminate() {
        if (this.scheduler != null) {
            this.scheduler.removeActivity(this);
        }
        if (this.stepping) {
            this.stepping = false;
            this.activityFinished();
        }
    }

    public long processStep(long currentTime) {
        if (currentTime < this.startTime) {
            return this.startTime - currentTime;
        }
        if (currentTime > this.getStopTime()) {
            if (this.stepping) {
                this.stepping = false;
                this.scheduler.removeActivity(this);
                this.activityFinished();
            } else {
                this.activityStarted();
                this.scheduler.removeActivity(this);
                this.activityFinished();
            }
            return -1L;
        }
        if (!this.stepping) {
            this.activityStarted();
            this.stepping = true;
        }
        if (currentTime >= this.nextStepTime) {
            this.activityStep(currentTime - this.startTime);
            this.nextStepTime = currentTime + this.stepRate;
        }
        return this.stepRate;
    }

    public long getStopTime() {
        if (this.duration == -1L) {
            return Long.MAX_VALUE;
        }
        return this.startTime + this.duration;
    }

    public String toString() {
        String result = super.toString().replaceAll(".*\\.", "");
        return result + "[" + this.paramString() + "]";
    }

    protected String paramString() {
        StringBuffer result = new StringBuffer();
        result.append("startTime=" + this.startTime);
        result.append(",duration=" + this.duration);
        result.append(",stepRate=" + this.stepRate);
        if (this.stepping) {
            result.append(",stepping");
        }
        result.append(",nextStepTime=" + this.nextStepTime);
        return result.toString();
    }

    public static interface PActivityDelegate {
        public void activityStarted(PActivity var1);

        public void activityStepped(PActivity var1);

        public void activityFinished(PActivity var1);
    }
}

