/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.nodes;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolo.util.PUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class PPath
extends PNode {
    public static final String PROPERTY_STROKE_PAINT = "strokePaint";
    public static final String PROPERTY_STROKE = "stroke";
    public static final String PROPERTY_PATH = "path";
    private static final Rectangle2D.Float TEMP_RECTANGLE = new Rectangle2D.Float();
    private static final Ellipse2D.Float TEMP_ELLIPSE = new Ellipse2D.Float();
    private static final PAffineTransform TEMP_TRANSFORM = new PAffineTransform();
    private static final BasicStroke DEFAULT_STROKE = new BasicStroke(1.0f);
    private static final Color DEFAULT_STROKE_PAINT = Color.black;
    private transient GeneralPath path;
    private transient GeneralPath resizePath;
    private transient Stroke stroke;
    private Paint strokePaint = DEFAULT_STROKE_PAINT;

    public static PPath createRectangle(float x, float y, float width, float height) {
        TEMP_RECTANGLE.setFrame(x, y, width, height);
        PPath result = new PPath(TEMP_RECTANGLE);
        result.setPaint(Color.white);
        return result;
    }

    public static PPath createEllipse(float x, float y, float width, float height) {
        TEMP_ELLIPSE.setFrame(x, y, width, height);
        PPath result = new PPath(TEMP_ELLIPSE);
        result.setPaint(Color.white);
        return result;
    }

    public static PPath createPolyline(Point2D[] points) {
        PPath result = new PPath();
        result.setPathToPolyline(points);
        result.setPaint(Color.white);
        return result;
    }

    public static PPath createPolyline(float[] xp, float[] yp) {
        PPath result = new PPath();
        result.setPathToPolyline(xp, yp);
        result.setPaint(Color.white);
        return result;
    }

    public PPath() {
        this.stroke = DEFAULT_STROKE;
        this.path = new GeneralPath();
    }

    public PPath(Shape aShape) {
        this(aShape, DEFAULT_STROKE);
    }

    public PPath(Shape aShape, Stroke aStroke) {
        this();
        this.stroke = aStroke;
        if (aShape != null) {
            this.append(aShape, false);
        }
    }

    public Paint getStrokePaint() {
        return this.strokePaint;
    }

    public void setStrokePaint(Paint aPaint) {
        Paint old = this.strokePaint;
        this.strokePaint = aPaint;
        this.invalidatePaint();
        this.firePropertyChange(PROPERTY_STROKE_PAINT, old, this.strokePaint);
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke aStroke) {
        Stroke old = this.stroke;
        this.stroke = aStroke;
        this.updateBoundsFromPath();
        this.invalidatePaint();
        this.firePropertyChange(PROPERTY_STROKE, old, this.stroke);
    }

    public void startResizeBounds() {
        this.resizePath = new GeneralPath(this.path);
    }

    public void endResizeBounds() {
        this.resizePath = null;
    }

    public boolean setBounds(double x, double y, double width, double height) {
        if (this.path == null || !super.setBounds(x, y, width, height)) {
            return false;
        }
        if (this.resizePath != null) {
            this.path.reset();
            this.path.append(this.resizePath, false);
        }
        Rectangle2D pathBounds = this.path.getBounds2D();
        Rectangle2D pathStrokeBounds = this.getPathBoundsWithStroke();
        double strokeOutset = Math.max(pathStrokeBounds.getWidth() - pathBounds.getWidth(), pathStrokeBounds.getHeight() - pathBounds.getHeight());
        TEMP_TRANSFORM.setToIdentity();
        TEMP_TRANSFORM.translate(x += strokeOutset / 2.0, y += strokeOutset / 2.0);
        TEMP_TRANSFORM.scale((width -= strokeOutset) / pathBounds.getWidth(), (height -= strokeOutset) / pathBounds.getHeight());
        TEMP_TRANSFORM.translate(-pathBounds.getX(), -pathBounds.getY());
        this.path.transform(TEMP_TRANSFORM);
        return true;
    }

    public boolean intersects(Rectangle2D aBounds) {
        if (super.intersects(aBounds)) {
            if (this.getPaint() != null && this.path.intersects(aBounds)) {
                return true;
            }
            if (this.stroke != null && this.strokePaint != null) {
                return this.stroke.createStrokedShape(this.path).intersects(aBounds);
            }
        }
        return false;
    }

    public Rectangle2D getPathBoundsWithStroke() {
        if (this.stroke != null) {
            return this.stroke.createStrokedShape(this.path).getBounds2D();
        }
        return this.path.getBounds2D();
    }

    public void updateBoundsFromPath() {
        if (this.path == null) {
            this.resetBounds();
        } else {
            Rectangle2D b = this.getPathBoundsWithStroke();
            super.setBounds(b.getX(), b.getY(), b.getWidth(), b.getHeight());
        }
    }

    protected void paint(PPaintContext paintContext) {
        Paint p = this.getPaint();
        Graphics2D g2 = paintContext.getGraphics();
        if (p != null) {
            g2.setPaint(p);
            g2.fill(this.path);
        }
        if (this.stroke != null && this.strokePaint != null) {
            g2.setPaint(this.strokePaint);
            g2.setStroke(this.stroke);
            g2.draw(this.path);
        }
    }

    public GeneralPath getPathReference() {
        return this.path;
    }

    public void moveTo(float x, float y) {
        this.path.moveTo(x, y);
        this.firePropertyChange(PROPERTY_PATH, null, this.path);
        this.updateBoundsFromPath();
        this.invalidatePaint();
    }

    public void lineTo(float x, float y) {
        this.path.lineTo(x, y);
        this.firePropertyChange(PROPERTY_PATH, null, this.path);
        this.updateBoundsFromPath();
        this.invalidatePaint();
    }

    public void quadTo(float x1, float y1, float x2, float y2) {
        this.path.quadTo(x1, y1, x2, y2);
        this.firePropertyChange(PROPERTY_PATH, null, this.path);
        this.updateBoundsFromPath();
        this.invalidatePaint();
    }

    public void curveTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.path.curveTo(x1, y1, x2, y2, x3, y3);
        this.firePropertyChange(PROPERTY_PATH, null, this.path);
        this.updateBoundsFromPath();
        this.invalidatePaint();
    }

    public void append(Shape aShape, boolean connect) {
        this.path.append(aShape, connect);
        this.firePropertyChange(PROPERTY_PATH, null, this.path);
        this.updateBoundsFromPath();
        this.invalidatePaint();
    }

    public void setPathTo(Shape aShape) {
        this.path.reset();
        this.append(aShape, false);
    }

    public void setPathToRectangle(float x, float y, float width, float height) {
        TEMP_RECTANGLE.setFrame(x, y, width, height);
        this.setPathTo(TEMP_RECTANGLE);
    }

    public void setPathToEllipse(float x, float y, float width, float height) {
        TEMP_ELLIPSE.setFrame(x, y, width, height);
        this.setPathTo(TEMP_ELLIPSE);
    }

    public void setPathToPolyline(Point2D[] points) {
        this.path.reset();
        this.path.moveTo((float)points[0].getX(), (float)points[0].getY());
        for (int i = 1; i < points.length; ++i) {
            this.path.lineTo((float)points[i].getX(), (float)points[i].getY());
        }
        this.firePropertyChange(PROPERTY_PATH, null, this.path);
        this.updateBoundsFromPath();
        this.invalidatePaint();
    }

    public void setPathToPolyline(float[] xp, float[] yp) {
        this.path.reset();
        this.path.moveTo(xp[0], yp[0]);
        for (int i = 1; i < xp.length; ++i) {
            this.path.lineTo(xp[i], yp[i]);
        }
        this.firePropertyChange(PROPERTY_PATH, null, this.path);
        this.updateBoundsFromPath();
        this.invalidatePaint();
    }

    public void closePath() {
        this.path.closePath();
        this.firePropertyChange(PROPERTY_PATH, null, this.path);
        this.updateBoundsFromPath();
        this.invalidatePaint();
    }

    public void reset() {
        this.path.reset();
        this.firePropertyChange(PROPERTY_PATH, null, this.path);
        this.updateBoundsFromPath();
        this.invalidatePaint();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        PUtil.writeStroke(this.stroke, out);
        PUtil.writePath(this.path, out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.stroke = PUtil.readStroke(in);
        this.path = PUtil.readPath(in);
    }

    protected String paramString() {
        StringBuffer result = new StringBuffer();
        result.append("path=" + (this.path == null ? "null" : this.path.toString()));
        result.append(",stroke=" + (this.stroke == null ? "null" : this.stroke.toString()));
        result.append(",strokePaint=" + (this.strokePaint == null ? "null" : this.strokePaint.toString()));
        result.append(',');
        result.append(super.paramString());
        return result.toString();
    }
}

