/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.nodes;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;

public class PText
extends PNode {
    public static final String PROPERTY_TEXT = "text";
    public static final String PROPERTY_FONT = "font";
    public static Font DEFAULT_FONT = new Font("Helvetica", 0, 12);
    public static double DEFAULT_GREEK_THRESHOLD = 5.5;
    private String text;
    private Paint textPaint;
    private Font font;
    protected double greekThreshold = DEFAULT_GREEK_THRESHOLD;
    private boolean centeredText = false;
    private boolean constrainHeightToTextHeight = true;
    private boolean constrainWidthToTextWidth = true;
    private transient TextLayout[] lines;
    private static final TextLayout[] EMPTY_TEXT_LAYOUT_ARRAY = new TextLayout[0];

    public PText() {
        this.setTextPaint(Color.black);
    }

    public PText(String aText) {
        this();
        this.setText(aText);
    }

    public boolean getCenteredText() {
        return this.centeredText;
    }

    public void setCenteredText(boolean centered) {
        this.centeredText = centered;
        this.recomputeLayout();
    }

    public Paint getTextPaint() {
        return this.textPaint;
    }

    public void setTextPaint(Paint textPaint) {
        this.textPaint = textPaint;
        this.invalidatePaint();
    }

    public void setConstrainWidthToTextWidth(boolean constrainWidthToTextWidth) {
        this.constrainWidthToTextWidth = constrainWidthToTextWidth;
        this.recomputeLayout();
    }

    public void setConstrainHeightToTextHeight(boolean constrainHeightToTextHeight) {
        this.constrainHeightToTextHeight = constrainHeightToTextHeight;
        this.recomputeLayout();
    }

    public double getGreekThreshold() {
        return this.greekThreshold;
    }

    public void setGreekThreshold(double threshold) {
        this.greekThreshold = threshold;
        this.invalidatePaint();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String aText) {
        String old = this.text;
        this.text = aText;
        this.lines = null;
        this.recomputeLayout();
        this.invalidatePaint();
        this.firePropertyChange(PROPERTY_TEXT, old, this.text);
    }

    public Font getFont() {
        if (this.font == null) {
            this.font = DEFAULT_FONT;
        }
        return this.font;
    }

    public void setFont(Font aFont) {
        Font old = this.font;
        this.font = aFont;
        this.lines = null;
        this.recomputeLayout();
        this.invalidatePaint();
        this.firePropertyChange(PROPERTY_FONT, old, this.font);
    }

    public void recomputeLayout() {
        ArrayList<TextLayout> linesList = new ArrayList<TextLayout>();
        double textWidth = 0.0;
        double textHeight = 0.0;
        if (this.text != null && this.text.length() > 0) {
            AttributedString atString = new AttributedString(this.text);
            atString.addAttribute(TextAttribute.FONT, this.getFont());
            AttributedCharacterIterator itr = atString.getIterator();
            LineBreakMeasurer measurer = new LineBreakMeasurer(itr, PPaintContext.RENDER_QUALITY_HIGH_FRC);
            int nextLineBreakOffset = this.text.indexOf(10);
            if (nextLineBreakOffset == -1) {
                nextLineBreakOffset = Integer.MAX_VALUE;
            }
            while (measurer.getPosition() < itr.getEndIndex()) {
                float availableWidth;
                float f = availableWidth = this.constrainWidthToTextWidth ? Float.MAX_VALUE : (float)this.getWidth();
                if (nextLineBreakOffset < measurer.getPosition() && (nextLineBreakOffset = this.text.indexOf(10, measurer.getPosition())) == -1) {
                    nextLineBreakOffset = Integer.MAX_VALUE;
                }
                if (nextLineBreakOffset == measurer.getPosition()) {
                    ++nextLineBreakOffset;
                }
                TextLayout aTextLayout = this.computeNextLayout(measurer, availableWidth, nextLineBreakOffset);
                if (measurer.getPosition() == nextLineBreakOffset) {
                    measurer.setPosition(nextLineBreakOffset + 1);
                }
                linesList.add(aTextLayout);
                textHeight += (double)aTextLayout.getAscent();
                textHeight += (double)(aTextLayout.getDescent() + aTextLayout.getLeading());
                textWidth = Math.max(textWidth, (double)aTextLayout.getAdvance());
            }
        }
        this.lines = linesList.toArray(EMPTY_TEXT_LAYOUT_ARRAY);
        if (this.constrainWidthToTextWidth || this.constrainHeightToTextHeight) {
            double newWidth = this.getWidth();
            double newHeight = this.getHeight();
            if (this.constrainWidthToTextWidth) {
                newWidth = textWidth;
            }
            if (this.constrainHeightToTextHeight) {
                newHeight = textHeight;
            }
            super.setBounds(this.getX(), this.getY(), newWidth, newHeight);
        }
    }

    protected TextLayout computeNextLayout(LineBreakMeasurer measurer, float availibleWidth, int nextLineBreakOffset) {
        return measurer.nextLayout(availibleWidth, nextLineBreakOffset, false);
    }

    protected void paint(PPaintContext paintContext) {
        super.paint(paintContext);
        float screenFontSize = (float)this.getFont().getSize() * (float)paintContext.getScale();
        if (this.textPaint != null && (double)screenFontSize > this.greekThreshold) {
            float x = (float)this.getX();
            float y = (float)this.getY();
            float bottomY = (float)this.getHeight() + y;
            Graphics2D g2 = paintContext.getGraphics();
            if (this.lines == null) {
                this.recomputeLayout();
                this.repaint();
                return;
            }
            g2.setPaint(this.textPaint);
            for (int i = 0; i < this.lines.length; ++i) {
                if (bottomY < (y += this.lines[i].getAscent())) {
                    return;
                }
                if (this.centeredText) {
                    float centeredOffset = (float)(this.getWidth() - (double)this.lines[i].getAdvance()) / 2.0f;
                    this.lines[i].draw(g2, x + centeredOffset, y);
                } else {
                    this.lines[i].draw(g2, x, y);
                }
                y += this.lines[i].getDescent() + this.lines[i].getLeading();
            }
        }
    }

    public boolean setBounds(double x, double y, double width, double height) {
        if (super.setBounds(x, y, width, height)) {
            this.recomputeLayout();
            return true;
        }
        return false;
    }

    protected String paramString() {
        StringBuffer result = new StringBuffer();
        result.append("text=" + (this.text == null ? "null" : this.text));
        result.append(",font=" + (this.font == null ? "null" : this.font.toString()));
        result.append(',');
        result.append(super.paramString());
        return result.toString();
    }
}

