/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.util;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PStack;
import java.awt.geom.Dimension2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.EventListener;
import javax.swing.event.EventListenerList;

public class PPickPath
implements PInputEventListener {
    private static double[] PTS = new double[4];
    private PStack nodeStack;
    private PStack transformStack;
    private PStack pickBoundsStack = new PStack();
    private PCamera topCamera;
    private PCamera bottomCamera;
    static /* synthetic */ Class class$edu$umd$cs$piccolo$event$PInputEventListener;

    public PPickPath(PCamera aCamera, PBounds aScreenPickBounds) {
        this.topCamera = aCamera;
        this.nodeStack = new PStack();
        this.transformStack = new PStack();
        this.pickBoundsStack.push(aScreenPickBounds);
    }

    public PBounds getPickBounds() {
        return (PBounds)this.pickBoundsStack.peek();
    }

    public void pushNode(PNode aNode) {
        this.nodeStack.push(aNode);
    }

    public void popNode(PNode aNode) {
        this.nodeStack.pop();
    }

    public PNode getPickedNode() {
        return (PNode)this.nodeStack.peek();
    }

    public PCamera getTopCamera() {
        return this.topCamera;
    }

    public PCamera getBottomCamera() {
        if (this.bottomCamera == null) {
            for (int i = this.nodeStack.size() - 1; i >= 0; --i) {
                PNode each = (PNode)this.nodeStack.get(i);
                if (!(each instanceof PCamera)) continue;
                this.bottomCamera = (PCamera)each;
                return this.bottomCamera;
            }
        }
        return this.bottomCamera;
    }

    public PStack getNodeStackReference() {
        return this.nodeStack;
    }

    public double getScale() {
        PPickPath.PTS[0] = 0.0;
        PPickPath.PTS[1] = 0.0;
        PPickPath.PTS[2] = 1.0;
        PPickPath.PTS[3] = 0.0;
        int count = this.transformStack.size();
        for (int i = 0; i < count; ++i) {
            PAffineTransform each = ((PTuple)this.transformStack.get((int)i)).transform;
            if (each == null) continue;
            each.transform(PTS, 0, PTS, 0, 2);
        }
        return Point2D.distance(PTS[0], PTS[1], PTS[2], PTS[3]);
    }

    public void pushTransform(PAffineTransform aTransform) {
        this.transformStack.push(new PTuple(this.getPickedNode(), aTransform));
        if (aTransform != null) {
            Rectangle2D newPickBounds = (Rectangle2D)this.getPickBounds().clone();
            aTransform.inverseTransform(newPickBounds, newPickBounds);
            this.pickBoundsStack.push(newPickBounds);
        }
    }

    public void popTransform(PAffineTransform aTransform) {
        this.transformStack.pop();
        if (aTransform != null) {
            this.pickBoundsStack.pop();
        }
    }

    public PAffineTransform getPathTransformTo(PNode nodeOnPath) {
        PAffineTransform aTransform = new PAffineTransform();
        int count = this.transformStack.size();
        for (int i = 0; i < count; ++i) {
            PTuple each = (PTuple)this.transformStack.get(i);
            if (each.transform != null) {
                aTransform.concatenate(each.transform);
            }
            if (nodeOnPath != each.node) continue;
            return aTransform;
        }
        throw new RuntimeException("Node could not be found on pick path");
    }

    public void processEvent(PInputEvent aEvent, int type) {
        aEvent.setPath(this);
        for (int i = this.nodeStack.size() - 1; i >= 0; --i) {
            PNode each = (PNode)this.nodeStack.get(i);
            EventListenerList list = each.getListenerList();
            if (list == null) continue;
            EventListener[] listeners = list.getListeners(class$edu$umd$cs$piccolo$event$PInputEventListener == null ? PPickPath.class$("edu.umd.cs.piccolo.event.PInputEventListener") : class$edu$umd$cs$piccolo$event$PInputEventListener);
            for (int j = 0; j < listeners.length; ++j) {
                PInputEventListener listener = (PInputEventListener)listeners[j];
                listener.processEvent(aEvent, type);
            }
        }
    }

    public Point2D canvasToLocal(Point2D canvasPoint, PNode nodeOnPath) {
        try {
            return this.getPathTransformTo(nodeOnPath).inverseTransform(canvasPoint, canvasPoint);
        }
        catch (NoninvertibleTransformException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Dimension2D canvasToLocal(Dimension2D canvasDimension, PNode nodeOnPath) {
        return this.getPathTransformTo(nodeOnPath).inverseTransform(canvasDimension, canvasDimension);
    }

    public Rectangle2D canvasToLocal(Rectangle2D canvasRectangle, PNode nodeOnPath) {
        return this.getPathTransformTo(nodeOnPath).inverseTransform(canvasRectangle, canvasRectangle);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class PTuple {
        public PNode node;
        public PAffineTransform transform;

        public PTuple(PNode n, PAffineTransform t) {
            this.node = n;
            this.transform = t;
        }
    }
}

