/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.jboogie.command_framework;

import com.gentleware.jboogie.command_framework.CommandConflictsWithModelException;
import com.gentleware.jboogie.kernel.JBoogieResourceBundle;
import com.gentleware.jboogie.kernel.ProjectImpl;
import com.gentleware.jboogie.openapi.Command;
import com.gentleware.jboogie.openapi.Project;
import com.gentleware.jboogie.util.JBoogieUtils;
import com.gentleware.mdr.MdrFacade;
import com.gentleware.services.Services;
import com.gentleware.services.swingx.ResourceId;
import com.gentleware.services.swingx.XAbstractAction;
import com.gentleware.services.util.CollectionFactory;
import com.gentleware.services.util.MultiHashMap;
import com.gentleware.services.util.Pile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jmi.reflect.CompositionCycleException;
import javax.jmi.reflect.JmiException;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.omg.uml2.diagraminterchange.DiagramElement;

public class UndoManager {
    public static final String I = "canUndo";
    public static final String G = "canRedo";
    private final Pile J = new Pile();
    private final Pile C = new Pile();
    private int F = 80;
    private final Set A = new HashSet();
    private final MultiHashMap O = new MultiHashMap();
    private int M;
    private Project L;
    private boolean H = true;
    protected Throwable D;
    private List N = CollectionFactory.createArrayList();
    private boolean K;
    private boolean E;
    public static final int B = 80;

    public Throwable getLastException() {
        return this.D;
    }

    public UndoManager(Project project) {
        this.L = project;
        this.M = 0;
    }

    public Project getProject() {
        return this.L;
    }

    public void setSaved() {
        this.M = 0;
        this.E();
    }

    public void setNeedsSave() {
        this.M = 1;
        this.J.clear();
        this.C.clear();
        this.N.clear();
    }

    public boolean getNeedsSave() {
        return this.M != 0;
    }

    public void clearStacks() {
        this.J.clear();
        this.C.clear();
        this.N.clear();
        this.E();
    }

    private boolean C() {
        return this.J.isEmpty();
    }

    private boolean H() {
        return this.C.isEmpty();
    }

    public boolean isRoundtripIsUndoable() {
        return this.K;
    }

    public void setRoundtripIsUndoable(boolean bl) {
        this.K = bl;
        this.E();
    }

    public synchronized boolean execute(Command command) {
        return this.execute(command, true, true);
    }

    public synchronized boolean execute(Command command, boolean bl, boolean bl2) {
        if (!this.L.updateProjectBeforeAction()) {
            Services.logDebug((Object)("Command " + command + " was not executed due to problems in updateProjectBeforeAction"));
            return false;
        }
        if (!command.isRootCommand()) {
            throw new IllegalArgumentException("Can only execute top-level commands.");
        }
        this.C.clear();
        this.B();
        this.C.push((Object)command);
        boolean bl3 = this.redo(bl, bl2);
        return bl3;
    }

    private void B() {
        Integer n2 = new Integer(this.M);
        boolean bl = false;
        Iterator iterator = this.N.iterator();
        while (iterator.hasNext()) {
            Integer n3 = (Integer)iterator.next();
            if (n3.compareTo(n2) > 0) {
                bl = true;
            }
            if (!bl) continue;
            iterator.remove();
        }
    }

    public synchronized boolean redo() {
        return this.redo(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean redo(boolean bl, boolean bl2) {
        boolean bl4;
        Command command;
        block22: {
            command = (Command)this.C.pop();
            boolean bl3 = command.isFirstRedo();
            bl4 = false;
            boolean bl5 = true;
            if (bl) {
                bl5 = this.A(command);
            }
            if (!bl5) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        String string = "<html>Cannot execute command, probably because an involved element is <br>locked by another client, or because another client has executed a conflicting command meanwhile.</html>";
                        Services.logInfo((Object)"<html>Cannot execute command, probably because an involved element is <br>locked by another client, or because another client has executed a conflicting command meanwhile.</html>");
                        JBoogieUtils.showMessageDialog(new JFrame(), "<html>Cannot execute command, probably because an involved element is <br>locked by another client, or because another client has executed a conflicting command meanwhile.</html>");
                    }
                });
                return false;
            }
            MdrFacade.getInstance().beginTransaction(true);
            try {
                try {
                    command.doRe();
                    bl4 = true;
                }
                catch (CommandConflictsWithModelException commandConflictsWithModelException) {
                    this.D = commandConflictsWithModelException;
                    Services.logInfo((Object)(">>>>>>> A CONFLICT WAS DETECTED. ROLLBACK OF COMMAND " + command.getGlobalCommandId() + "-" + command.getClass().getName() + " <<<<<<<<"));
                    command.doUn();
                    String string = "The current command cannot be executed because of a conflict.";
                    if (ProjectImpl.isGuiMode()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                JBoogieUtils.showMessageDialog(new JFrame(), "The current command cannot be executed because of a conflict.");
                            }
                        });
                    }
                    Object var10_8 = null;
                    MdrFacade.getInstance().endTransaction(!bl4);
                    if (bl2) {
                        bl4 = this.A(command, bl3, bl4) && bl4;
                        break block22;
                    } else {
                        Services.logInfo((Object)"Not calling hookAfterDoRe");
                    }
                    break block22;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    this.D = outOfMemoryError;
                    Services.logError((Object)"OutOfMemory error during command execution", (Throwable)outOfMemoryError);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            String string = "<html>The system ran out of memory during command execution.<BR> Please save your project immediately and restart Poseidon after you have increased the memory available to Poseidon (see the FAQ).</html>";
                            Services.logInfo((Object)"<html>The system ran out of memory during command execution.<BR> Please save your project immediately and restart Poseidon after you have increased the memory available to Poseidon (see the FAQ).</html>");
                            JBoogieUtils.showMessageDialog(new JFrame(), "<html>The system ran out of memory during command execution.<BR> Please save your project immediately and restart Poseidon after you have increased the memory available to Poseidon (see the FAQ).</html>");
                        }
                    });
                    Object var10_9 = null;
                    MdrFacade.getInstance().endTransaction(!bl4);
                    if (bl2) {
                        bl4 = this.A(command, bl3, bl4) && bl4;
                        break block22;
                    } else {
                        Services.logInfo((Object)"Not calling hookAfterDoRe");
                    }
                    break block22;
                }
                catch (Throwable throwable) {
                    Object object;
                    this.D = throwable;
                    Services.logError((Object)("The UserCommand <" + command + "> has a problem:"), (Throwable)throwable);
                    if (throwable instanceof CompositionCycleException) {
                        object = (CompositionCycleException)throwable;
                        Services.logError((Object)("problematic element: " + ((JmiException)object).getElementInError()));
                    }
                    Services.logInfo((Object)this.L.getUndoManager().toString());
                    object = this.L.getTargetManager().getActiveDiagram();
                    if (object == null) {
                        Services.logInfo((Object)" ... No visible diagram.");
                    } else {
                        JBoogieUtils.dumpDi((DiagramElement)object, this.L);
                    }
                    Services.logErrorOrThrow((Object)"An exception occured in redo.", (Throwable)throwable);
                    Object var10_10 = null;
                    MdrFacade.getInstance().endTransaction(!bl4);
                    if (bl2) {
                        bl4 = this.A(command, bl3, bl4) && bl4;
                        break block22;
                    } else {
                        Services.logInfo((Object)"Not calling hookAfterDoRe");
                    }
                    break block22;
                }
                Object var10_7 = null;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                MdrFacade.getInstance().endTransaction(!bl4);
                if (!bl2) {
                    Services.logInfo((Object)"Not calling hookAfterDoRe");
                    throw throwable;
                }
                bl4 = this.A(command, bl3, bl4) && bl4;
                throw throwable;
            }
            MdrFacade.getInstance().endTransaction(!bl4);
            if (bl2) {
                bl4 = this.A(command, bl3, bl4) && bl4;
            } else {
                Services.logInfo((Object)"Not calling hookAfterDoRe");
            }
        }
        this.H = bl4;
        if (bl4) {
            this.pushCommandOntoUndoStack(command);
            return true;
        }
        Services.logInfo((Object)"hasRedoneWithoutProblems = false");
        return false;
    }

    public void pushCommandOntoUndoStack(Command command) {
        ++this.M;
        this.J.push((Object)command);
        this.D();
        this.E();
        this.fireRedo(command);
    }

    protected boolean A(Command command, boolean bl, boolean bl2) {
        return true;
    }

    protected boolean A(Command command) {
        return true;
    }

    private void D() {
        while (this.C.size() > this.F) {
            this.C.removeBottom();
        }
        while (this.J.size() > this.F) {
            this.J.removeBottom();
        }
    }

    public boolean canRedo() {
        return !this.H();
    }

    public synchronized void undo() {
        this.undo(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void undo(boolean bl) {
        block11: {
            boolean bl2;
            Command command;
            block10: {
                boolean bl3 = true;
                if (this.N.contains(new Integer(this.M))) {
                    if (this.K) {
                        bl3 = this.G();
                    } else {
                        return;
                    }
                }
                if (!bl3) {
                    return;
                }
                command = (Command)this.J.pop();
                bl2 = false;
                boolean bl4 = true;
                if (bl) {
                    bl4 = this.B(command);
                }
                if (bl4) break block10;
                JBoogieUtils.showMessageDialog(new JFrame(), "Cannot Undo for some reason, probably because your command is not the last command anymore!");
                break block11;
            }
            MdrFacade.getInstance().beginTransaction(true);
            try {
                command.doUn();
                bl2 = true;
            }
            catch (Exception exception) {
                try {
                    this.D = exception;
                    Services.logErrorOrThrow((Object)("The UserCommand <" + command + "> has a problem:"), (Throwable)exception);
                }
                catch (Throwable throwable) {
                    MdrFacade.getInstance().endTransaction(!bl2);
                    throw throwable;
                }
                MdrFacade.getInstance().endTransaction(!bl2);
            }
            MdrFacade.getInstance().endTransaction(!bl2);
            if (bl2) {
                --this.M;
                this.C.push((Object)command);
                this.D();
                this.E();
                this.fireUndo(command);
            }
        }
        this.F();
    }

    private static void A(JPanel jPanel, String string) {
        JTextArea jTextArea = new JTextArea(string);
        jTextArea.setEditable(false);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setLineWrap(true);
        jTextArea.setPreferredSize(new Dimension(400, 180));
        jTextArea.setMaximumSize(new Dimension(400, 180));
        jTextArea.setEditable(false);
        jTextArea.setFont(new Font("SansSerif", 0, 14));
        jPanel.add(jTextArea);
    }

    private boolean G() {
        if (this.E) {
            return true;
        }
        ResourceId resourceId = JBoogieResourceBundle.UndoRoundtripCommandInformation;
        String string = Services.localize((ResourceId)resourceId);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 1, 5, 5));
        UndoManager.A(jPanel, string);
        JCheckBox jCheckBox = new JCheckBox(Services.localize((ResourceId)JBoogieResourceBundle.DisableWetherRoundtripUndoCheck), false);
        ResourceId resourceId2 = JBoogieResourceBundle.UndoRoundtripCommandTitle;
        String string2 = Services.localize((ResourceId)resourceId2);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jPanel, "Center");
        jPanel2.add((Component)jCheckBox, "South");
        Object[] objectArray = new Object[]{Services.localize((ResourceId)JBoogieResourceBundle.AskYesAnswer), Services.localize((ResourceId)JBoogieResourceBundle.AskNoAnswer)};
        int n2 = JBoogieUtils.showOptionDialog(null, jPanel2, string2, 0, 3, null, objectArray, objectArray[0]);
        this.E = jCheckBox.isSelected();
        return n2 == 0;
    }

    protected void F() {
    }

    protected boolean B(Command command) {
        return true;
    }

    public String getUndoCommandDescription() {
        if (this.canUndo()) {
            Command command = (Command)this.J.peek();
            return command.getDescription();
        }
        return "";
    }

    public String getUndoCommandDescription(int n2) {
        return this.A(this.J, n2).getDescription();
    }

    public String getRedoCommandDescription(int n2) {
        return this.A(this.C, n2).getDescription();
    }

    public Command getUndoCommand(int n2) {
        return this.A(this.J, n2);
    }

    public Command getRedoCommand(int n2) {
        return this.A(this.C, n2);
    }

    private Command A(Pile pile, int n2) {
        Iterator iterator = pile.iterator();
        int n3 = -1;
        while (iterator.hasNext()) {
            Command command = (Command)iterator.next();
            if (++n3 != n2) continue;
            return command;
        }
        return null;
    }

    public String getRedoCommandDescription() {
        if (this.canRedo()) {
            Command command = (Command)this.C.peek();
            return command.getDescription();
        }
        return "";
    }

    public boolean canUndo() {
        boolean bl = this.C();
        if (bl) {
            return false;
        }
        if (!this.K) {
            return !this.N.contains(new Integer(this.M));
        }
        return true;
    }

    private void E() {
        if (!ProjectImpl.isImporting()) {
            XAbstractAction.updateAllEnabled();
        }
    }

    public int undoSize() {
        return this.J.size();
    }

    public int redoSize() {
        return this.C.size();
    }

    public void setUndoLimit(int n2) {
        this.F = n2;
    }

    public String toString() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer("The Undomanager reports:");
        int n2 = this.J.size();
        stringBuffer.append("\n  UndoStack size=" + n2);
        int n3 = 0;
        Iterator iterator = this.J.iterator();
        while (iterator.hasNext()) {
            object = (Command)iterator.next();
            if (n2 - n3 < 500) {
                stringBuffer.append("\n     " + n3 + " = " + ((Command)object).toString());
            }
            ++n3;
        }
        int n4 = this.C.size();
        stringBuffer.append("\n  RedoStack size=" + n4);
        n3 = 0;
        object = this.C.iterator();
        while (object.hasNext()) {
            Command command = (Command)object.next();
            if (n4 - n3 < 500) {
                stringBuffer.append("\n     " + n3 + " = " + command.toString());
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    private void A() {
        Object object;
        Services.logInfo((Object)"[UndoManager.dumpAllUndoListener]");
        Services.logInfo((Object)" - UndoListener");
        Object object2 = this.A.iterator();
        while (object2.hasNext()) {
            object = (Listener)object2.next();
            Services.logInfo((Object)(" --- listener: " + object));
        }
        object2 = this.O.keySet();
        Services.logInfo((Object)" - Specialized UndoListener");
        object = object2.iterator();
        while (object.hasNext()) {
            ResourceId resourceId = (ResourceId)object.next();
            Collection collection = (Collection)this.O.get((Object)resourceId);
            Services.logInfo((Object)(" - Specialized UndoListener for Command " + resourceId.getKey()));
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Listener listener = (Listener)iterator.next();
                Services.logInfo((Object)(" --- listener: " + listener));
            }
        }
    }

    public void setLastCommandRoundtripCommand() {
        this.N.add(new Integer(this.M));
    }

    public void addUndoListener(Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("UndoManager.Listener may not be null!");
        }
        this.A.remove(listener);
        this.A.add(listener);
    }

    public void removeUndoListener(Listener listener) {
        this.A.remove(listener);
    }

    public void addUndoListener(Listener listener, ResourceId resourceId) {
        if (listener == null) {
            throw new IllegalArgumentException("UndoManager.Listener may not be null!");
        }
        this.O.remove((Object)resourceId, (Object)listener);
        this.O.put((Object)resourceId, (Object)listener);
    }

    public void removeUndoListener(Listener listener, ResourceId resourceId) {
        this.O.remove((Object)resourceId, (Object)listener);
    }

    public void removeUndoListenerForAllCommands(Listener listener) {
        this.removeUndoListener(listener);
        Set set = CollectionFactory.createHashSet((Collection)this.O.keySet());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ResourceId resourceId = (ResourceId)iterator.next();
            List list = CollectionFactory.createArrayList((Collection)((Collection)this.O.get((Object)resourceId)));
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                Listener listener2 = (Listener)iterator2.next();
                if (listener2 != listener) continue;
                this.removeUndoListener(listener, resourceId);
            }
        }
    }

    public synchronized void fireUndo(Command command) {
        if (!ProjectImpl.isImporting()) {
            Object object;
            Object object2 = this.A.iterator();
            while (object2.hasNext()) {
                object = (Listener)object2.next();
                try {
                    object.handleUndo(command);
                }
                catch (Exception exception) {
                    Services.logError((Object)"[UndoManager.fireUndo]", (Throwable)exception);
                }
            }
            object2 = (Collection)this.O.get((Object)command.getResourceId());
            if (object2 != null) {
                object = object2.iterator();
                while (object.hasNext()) {
                    Listener listener = (Listener)object.next();
                    listener.handleUndo(command);
                }
            }
        }
    }

    public synchronized void fireRedo(Command command) {
        if (!ProjectImpl.isImporting()) {
            Object object;
            Object object2 = this.A.iterator();
            while (object2.hasNext()) {
                object = (Listener)object2.next();
                try {
                    object.handleRedo(command);
                }
                catch (Exception exception) {
                    Services.logError((Object)"[UndoManager.fireRedo]", (Throwable)exception);
                }
            }
            object2 = (Collection)this.O.get((Object)command.getResourceId());
            if (object2 != null) {
                object = object2.iterator();
                while (object.hasNext()) {
                    Listener listener = (Listener)object.next();
                    listener.handleRedo(command);
                }
            }
        }
    }

    public void dispose() {
        this.C.clear();
        this.J.clear();
        this.A.clear();
        this.O.clear();
    }

    public boolean hasExcecutedLastCommandWithoutProblems() {
        return this.H;
    }

    public static interface Listener {
        public void handleRedo(Command var1);

        public void handleUndo(Command var1);
    }
}

