/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.jboogie.layout;

import com.gentleware.jboogie.kernel.JBoogie;
import com.gentleware.jboogie.layout.LayoutableConnector;
import com.gentleware.jboogie.layout.LayoutableEdge;
import com.gentleware.jboogie.layout.LayoutableElement;
import com.gentleware.jboogie.openapi.Project;
import com.gentleware.jboogie.style.Style;
import com.gentleware.services.util.Geometry;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.geom.Point2D;
import java.util.List;

public class LayoutableEdges {
    private LayoutableEdges() {
    }

    public static boolean isSelfEdge(LayoutableEdge layoutableEdge) {
        LayoutableElement layoutableElement;
        LayoutableConnector layoutableConnector = layoutableEdge.getSourceConnector();
        LayoutableConnector layoutableConnector2 = layoutableEdge.getTargetConnector();
        LayoutableElement layoutableElement2 = layoutableConnector.getLayoutableElement();
        boolean bl = layoutableElement2 == (layoutableElement = layoutableConnector2.getLayoutableElement());
        return bl;
    }

    public static boolean hasNextWaypoint(LayoutableEdge layoutableEdge, int n2) {
        boolean bl = n2 >= 0 ? n2 < layoutableEdge.getWaypointCount() - 1 : n2 > -layoutableEdge.getWaypointCount();
        return bl;
    }

    public static boolean hasPreviousWaypoint(int n2) {
        boolean bl = n2 >= 0 ? n2 > 0 : n2 < -1;
        return bl;
    }

    public static int getNextWaypointIndex(int n2) {
        int n3 = n2 >= 0 ? n2 + 1 : n2 - 1;
        return n3;
    }

    public static int getPreviousWaypointIndex(int n2) {
        int n3 = n2 >= 0 ? n2 - 1 : n2 + 1;
        return n3;
    }

    public static int getPositiveWaypointIndex(LayoutableEdge layoutableEdge, int n2) {
        int n3 = n2 >= 0 ? n2 : layoutableEdge.getWaypointCount() + n2;
        return n3;
    }

    public static double getAngleAtWaypoint(LayoutableEdge layoutableEdge, int n2) {
        int n3;
        int n4;
        if (LayoutableEdges.hasNextWaypoint(layoutableEdge, n2)) {
            n4 = n2;
            n3 = LayoutableEdges.getNextWaypointIndex(n2);
        } else if (LayoutableEdges.hasPreviousWaypoint(n2)) {
            n4 = LayoutableEdges.getPreviousWaypointIndex(n2);
            n3 = n2;
        } else {
            throw new IllegalArgumentException("edge must have at least two waypoint to calculate angle.");
        }
        double d2 = layoutableEdge.getWaypointX(n4);
        double d3 = layoutableEdge.getWaypointY(n4);
        double d4 = layoutableEdge.getWaypointX(n3);
        double d5 = layoutableEdge.getWaypointY(n3);
        double d6 = Geometry.getAngleBetween((double)d2, (double)d3, (double)d4, (double)d5);
        return d6;
    }

    public static void adjustAdornmentWhenWaypointRemoved(LayoutableEdge layoutableEdge, int n2) {
        int n3 = LayoutableEdges.getPositiveWaypointIndex(layoutableEdge, n2);
        List list = layoutableEdge.getContainedElements();
        int n4 = list.size();
        Project project = JBoogie.getInstance().getCurrentProject();
        Style style = project.getStyle();
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5;
            int n6;
            LayoutableElement layoutableElement = (LayoutableElement)list.get(i2);
            if (!style.getAdornmentWaypointIndex().isSet(layoutableElement) || (n6 = LayoutableEdges.getPositiveWaypointIndex(layoutableEdge, n5 = style.getAdornmentWaypointIndex().F(layoutableElement))) < n3 || n6 <= 0) continue;
            style.getAdornmentWaypointIndex().B(layoutableElement, n5 - 1);
            if (n6 != n3 || !style.getAdornmentWaypointOffset().isSet(layoutableElement)) continue;
            double d2 = style.getAdornmentWaypointOffset().get(layoutableElement);
            double d3 = LayoutableEdges.getSegmentLength(layoutableEdge, n6 - 1);
            double d4 = LayoutableEdges.getSegmentLength(layoutableEdge, n6);
            double d5 = (d2 * d4 + d3) / (d3 + d4);
            style.getAdornmentWaypointOffset().set(layoutableElement, d5);
        }
    }

    public static void adjustAdornmentWhenWaypointAdded(LayoutableEdge layoutableEdge, int n2, double d2, double d3) {
        int n3 = LayoutableEdges.getPositiveWaypointIndex(layoutableEdge, n2);
        List list = layoutableEdge.getContainedElements();
        int n4 = list.size();
        Project project = JBoogie.getInstance().getCurrentProject();
        Style style = project.getStyle();
        for (int i2 = 0; i2 < n4; ++i2) {
            double d4;
            int n5;
            int n6;
            LayoutableElement layoutableElement = (LayoutableElement)list.get(i2);
            if (!style.getAdornmentWaypointIndex().isSet(layoutableElement) || (n6 = LayoutableEdges.getPositiveWaypointIndex(layoutableEdge, n5 = style.getAdornmentWaypointIndex().F(layoutableElement))) < n3 - 1) continue;
            if (n6 >= n3) {
                style.getAdornmentWaypointIndex().B(layoutableElement, n5 + 1);
                continue;
            }
            if (!style.getAdornmentWaypointOffset().isSet(layoutableElement)) continue;
            double d5 = style.getAdornmentWaypointOffset().get(layoutableElement);
            double d6 = layoutableEdge.getWaypointX(n3 - 1);
            double d7 = layoutableEdge.getWaypointY(n3 - 1);
            double d8 = layoutableEdge.getWaypointX(n3);
            double d9 = layoutableEdge.getWaypointY(n3);
            double d10 = d6 - d2;
            double d11 = d7 - d3;
            double d12 = d2 - d8;
            double d13 = d3 - d9;
            double d14 = LayoutableEdges.getSegmentLength(layoutableEdge, n3 - 1);
            double d15 = Math.sqrt(d10 * d10 + d11 * d11);
            double d16 = Math.sqrt(d12 * d12 + d13 * d13);
            if (d5 * d14 > d15) {
                d4 = (d5 * d14 - d15) / d16;
                style.getAdornmentWaypointIndex().B(layoutableElement, n3);
            } else {
                d4 = d5 * d14 / d15;
            }
            style.getAdornmentWaypointOffset().set(layoutableElement, d4);
        }
    }

    public static double getSegmentLength(LayoutableEdge layoutableEdge, int n2) {
        int n3 = LayoutableEdges.getPositiveWaypointIndex(layoutableEdge, n2);
        double d2 = layoutableEdge.getWaypointX(n3);
        double d3 = layoutableEdge.getWaypointY(n3);
        double d4 = layoutableEdge.getWaypointX(n3 + 1);
        double d5 = layoutableEdge.getWaypointY(n3 + 1);
        double d6 = d2 - d4;
        double d7 = d3 - d5;
        double d8 = Math.sqrt(d6 * d6 + d7 * d7);
        return d8;
    }

    public static Point2D[] cloneWaypoints(LayoutableEdge layoutableEdge) {
        int n2 = layoutableEdge.getWaypointCount();
        Point2D[] point2DArray = new Point2D.Double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            double d2 = layoutableEdge.getWaypointX(i2);
            double d3 = layoutableEdge.getWaypointY(i2);
            point2DArray[i2] = new Point2D.Double(d2, d3);
        }
        return point2DArray;
    }

    public static PBounds getBounds(LayoutableEdge layoutableEdge) {
        PBounds pBounds;
        int n2 = layoutableEdge.getWaypointCount();
        if (n2 == 0) {
            pBounds = new PBounds();
        } else {
            pBounds = new PBounds();
            pBounds.setOrigin(layoutableEdge.getWaypointX(0), layoutableEdge.getWaypointY(0));
            for (int i2 = 1; i2 < layoutableEdge.getWaypointCount(); ++i2) {
                pBounds.add(layoutableEdge.getWaypointX(i2), layoutableEdge.getWaypointY(i2));
            }
        }
        return pBounds;
    }

    public static Point2D[] getResizedWaypoints(LayoutableEdge layoutableEdge, double d2, double d3) {
        PBounds pBounds = LayoutableEdges.getBounds(layoutableEdge);
        double d4 = pBounds.getWidth();
        double d5 = pBounds.getHeight();
        Point2D[] point2DArray = LayoutableEdges.cloneWaypoints(layoutableEdge);
        double d6 = d4 == 0.0 ? 0.0 : d2 / d4;
        double d7 = d5 == 0.0 ? 0.0 : d3 / d5;
        for (int i2 = 0; i2 < point2DArray.length; ++i2) {
            double d8 = point2DArray[i2].getX() - layoutableEdge.getTranslateX();
            double d9 = point2DArray[i2].getY() - layoutableEdge.getTranslateY();
            point2DArray[i2].setLocation(layoutableEdge.getTranslateX() + d8 * d6, layoutableEdge.getTranslateY() + d9 * d7);
        }
        return point2DArray;
    }

    public static Point2D[] getTranslatedWaypoints(LayoutableEdge layoutableEdge, double d2, double d3) {
        PBounds pBounds = LayoutableEdges.getBounds(layoutableEdge);
        double d4 = pBounds.getX();
        double d5 = pBounds.getY();
        Point2D[] point2DArray = LayoutableEdges.cloneWaypoints(layoutableEdge);
        double d6 = d2 - d4;
        double d7 = d3 - d5;
        for (int i2 = 0; i2 < point2DArray.length; ++i2) {
            point2DArray[i2].setLocation(point2DArray[i2].getX() + d6, point2DArray[i2].getY() + d7);
        }
        return point2DArray;
    }
}

