/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.jboogie.piccolo.nodes;

import com.gentleware.jboogie.layout.LayoutableDiagram;
import com.gentleware.jboogie.layout.LayoutableElement;
import com.gentleware.jboogie.layout.LayoutableElements;
import com.gentleware.jboogie.layout.LayoutableNode;
import com.gentleware.jboogie.model_management.SemanticModelBridgePresentation;
import com.gentleware.jboogie.model_management.SimpleTypeInfo;
import com.gentleware.jboogie.openapi.Project;
import com.gentleware.jboogie.piccolo.nodes.B;
import com.gentleware.jboogie.util.DiMemento;
import com.gentleware.jboogie.util.JBoogieUtils;
import com.gentleware.jboogie.util.M;
import com.gentleware.services.Services;
import com.gentleware.services.configuration.Configuration;
import com.gentleware.services.util.Strings;
import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.List;
import javax.jmi.reflect.RefObject;

public class PGridLayer
extends PLayer
implements LayoutableDiagram {
    public static String CLIENT_KEY_RENDERING_QUALITY = "RENDERING_QUALITY";
    public static String BIRDVIEW = "BIRDVIEW";
    public static String PAINTGRID = "PAINTGRID";
    public static String PAINT = "PAINT";
    public static String DRAWING_SHAPE = "DRAWING_SHAPE";
    public static String EXPORT_TYPE = "EXPORT_TYPE";
    private static int \u011e = 10;
    private static boolean \u0119 = true;
    private Rectangle2D \u011d;
    protected Color _colorDots = new Color(164, 164, 164);
    protected Color _colorLines = new Color(192, 192, 192);
    public static final Color COLOR_BACKGROUND = new Color(236, 236, 236);
    protected static int _dotSize = 2;
    protected double _scaleGridLimit = 0.5;
    private B \u011c = new B((PNode)this);
    private static BasicStroke \u0117;
    private static BasicStroke \u0118;
    private Project \u011b;
    private static final int \u011a = 40;

    public PGridLayer(Project project) {
        \u0117 = new BasicStroke(_dotSize);
        \u0118 = new BasicStroke(0.0f);
        this.\u011b = project;
    }

    public static void setGridSpacing(int n2) {
        Configuration configuration = Services.getInstance().getConfiguration();
        configuration.putInteger("jboogie/gui.grid2.spacing", n2);
    }

    public static int getGridSpacing() {
        Configuration configuration = Services.getInstance().getConfiguration();
        int n2 = configuration.getInteger("jboogie/gui.grid2.spacing", 20);
        return n2;
    }

    public static boolean paintDots() {
        Configuration configuration = Services.getInstance().getConfiguration();
        boolean bl = configuration.getBoolean("jboogie/gui.grid2.dots", false);
        return bl;
    }

    public static void setPaintDots(boolean bl) {
        Configuration configuration = Services.getInstance().getConfiguration();
        configuration.putBoolean("jboogie/gui.grid2.dots", bl);
    }

    public static boolean isGridVisible() {
        Configuration configuration = Services.getInstance().getConfiguration();
        boolean bl = configuration.getBoolean("jboogie/gui/grid2/visible", true);
        return bl;
    }

    public static void setGridVisible(boolean bl) {
        Configuration configuration = Services.getInstance().getConfiguration();
        configuration.putBoolean("jboogie/gui/grid2/visible", bl);
    }

    public static void setGridSnap(boolean bl) {
        Configuration configuration = Services.getInstance().getConfiguration();
        configuration.putBoolean("jboogie/gui.grid2.snap", bl);
    }

    public static boolean isGridSnap() {
        Configuration configuration = Services.getInstance().getConfiguration();
        boolean bl = configuration.getBoolean("jboogie/gui.grid2.snap", true);
        return bl;
    }

    public static void setGridSnapSpacing(int n2) {
        Configuration configuration = Services.getInstance().getConfiguration();
        configuration.putInteger("jboogie/gui.grid2.snap_spacing", n2);
    }

    public static int getGridSnapSpacing() {
        Configuration configuration = Services.getInstance().getConfiguration();
        int n2 = configuration.getInteger("jboogie/gui.grid2.snap_spacing", 10);
        return n2;
    }

    public PBounds computeFullBounds(PBounds pBounds) {
        PBounds pBounds2 = super.computeFullBounds(pBounds);
        pBounds2.x -= 40.0;
        pBounds2.y -= 40.0;
        pBounds2.width += 80.0;
        pBounds2.height += 80.0;
        return pBounds2;
    }

    public void fullPaint(PPaintContext pPaintContext) {
        if (this.getVisible()) {
            PAffineTransform pAffineTransform = this.getTransformReference(true);
            float f2 = this.getTransparency();
            pPaintContext.pushTransform(pAffineTransform);
            pPaintContext.pushTransparency(f2);
            this.paint(pPaintContext);
            if (this.fullIntersects(pPaintContext.getLocalClip())) {
                int n2 = this.getChildrenCount();
                List list = this.getChildrenReference();
                for (int i2 = 0; i2 < n2; ++i2) {
                    PNode pNode = (PNode)list.get(i2);
                    pNode.fullPaint(pPaintContext);
                }
                this.paintAfterChildren(pPaintContext);
            }
            pPaintContext.popTransparency(f2);
            pPaintContext.popTransform(pAffineTransform);
        }
    }

    protected void paint(PPaintContext pPaintContext) {
        Shape shape;
        PCamera pCamera = pPaintContext.getCamera();
        Graphics2D graphics2D = pPaintContext.getGraphics();
        try {
            M m2 = (M)pCamera.getClientProperty((Object)CLIENT_KEY_RENDERING_QUALITY);
            if (m2 != null) {
                m2.A(graphics2D);
            }
        }
        catch (RuntimeException runtimeException) {
            Services.logError((Object)runtimeException);
        }
        boolean bl = false;
        boolean bl2 = true;
        Paint paint = null;
        boolean bl3 = false;
        boolean bl4 = false;
        String string = "";
        if (pCamera != null) {
            bl = pCamera.getClientProperty((Object)BIRDVIEW) != null;
            bl2 = pCamera.getClientProperty((Object)PAINTGRID) == null;
            paint = (Paint)pCamera.getClientProperty((Object)PAINT);
            if (paint != null) {
                bl3 = true;
            }
            bl4 = pCamera.getClientProperty((Object)JBoogieUtils.IS_EXPORTING) != null;
            string = (String)pCamera.getClientProperty((Object)EXPORT_TYPE);
        }
        if (bl3) {
            shape = (Shape)pCamera.getClientProperty((Object)DRAWING_SHAPE);
            if (shape == null) {
                shape = this.getBoundsReference();
            }
            graphics2D.setPaint(paint);
        } else {
            paint = this.getPaint();
            shape = this.getBoundsReference();
            if (paint != null) {
                graphics2D.setPaint(paint);
            }
        }
        graphics2D.setPaint(paint);
        graphics2D.fill(shape);
        BufferedImage bufferedImage = null;
        if (bufferedImage != null && bl4) {
            String string2 = string;
            boolean bl5 = "ps".equals(string2) || "eps".equals(string2);
            String string3 = null;
            this.A(shape.getBounds(), bufferedImage, graphics2D, bl5 ? string3 : null);
        }
        if (!bl && PGridLayer.isGridVisible() && pPaintContext.getScale() > this._scaleGridLimit && bl2) {
            this.C(pPaintContext);
        }
    }

    private void C(PPaintContext pPaintContext) {
        Graphics2D graphics2D = pPaintContext.getGraphics();
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        Object object2 = graphics2D.getRenderingHint(RenderingHints.KEY_RENDERING);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        this.\u011d = graphics2D.getClipBounds();
        if (PGridLayer.paintDots()) {
            this.B(graphics2D);
        } else {
            this.A(graphics2D);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, object2);
    }

    private void A(Rectangle rectangle, BufferedImage bufferedImage, Graphics2D graphics2D, String string) {
        if (rectangle.getWidth() > (double)\u011e && rectangle.getHeight() > (double)\u011e) {
            if (string != null) {
                this.A(rectangle, string, graphics2D);
            } else if (\u0119) {
                this.B(rectangle, bufferedImage, graphics2D);
            } else {
                this.A(rectangle, bufferedImage, graphics2D);
            }
        }
    }

    private void A(Rectangle rectangle, String string, Graphics2D graphics2D) {
        int n2 = 20;
        Font font = new Font("SansSerif", 2, 20);
        Color color = new Color(224, 224, 224);
        double d2 = -0.15707963267948966;
        this.A(rectangle, string, graphics2D, 20, font, color, -0.15707963267948966);
    }

    private void A(Rectangle rectangle, String string, Graphics2D graphics2D, int n2, Font font, Paint paint, double d2) {
        Font font2 = graphics2D.getFont();
        Paint paint2 = graphics2D.getPaint();
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.setPaint(paint);
        graphics2D.setFont(font);
        graphics2D.rotate(d2, rectangle.getX() + rectangle.getWidth() / 2.0, rectangle.getY() + rectangle.getHeight() / 2.0);
        Rectangle2D rectangle2D = graphics2D.getFontMetrics().getStringBounds(string, graphics2D);
        int n3 = (int)(rectangle.getWidth() / rectangle2D.getWidth()) + 1;
        String string2 = Strings.repeat((String)(string + "  "), (int)(2 * n3));
        int n4 = (int)(-rectangle.getHeight());
        while ((double)n4 < 2.0 * rectangle.getHeight()) {
            graphics2D.drawString(string2, (float)(rectangle.getX() - rectangle.getWidth() / 2.0), (float)rectangle.getY() + (float)n4);
            n4 += 2 * n2;
        }
        graphics2D.setPaint(paint2);
        graphics2D.setFont(font2);
        graphics2D.setTransform(affineTransform);
    }

    private void A(Rectangle rectangle, BufferedImage bufferedImage, Graphics2D graphics2D) {
        double d2;
        double d3;
        AffineTransform affineTransform = new AffineTransform();
        double d4 = rectangle.getWidth() / (double)bufferedImage.getWidth();
        double d5 = rectangle.getHeight() / (double)bufferedImage.getHeight();
        double d6 = Math.min(d4, d5);
        if (d4 < d5) {
            d3 = rectangle.getX();
            d2 = rectangle.getY() + (rectangle.getHeight() - (double)bufferedImage.getHeight() * d6) / 2.0;
        } else {
            d3 = rectangle.getX() + (rectangle.getWidth() - (double)bufferedImage.getWidth() * d6) / 2.0;
            d2 = rectangle.getY();
        }
        affineTransform.setToTranslation(d3, d2);
        if (d6 > 1.0) {
            affineTransform.scale(d6, d6);
        }
        graphics2D.drawRenderedImage(bufferedImage, affineTransform);
    }

    private void B(Rectangle rectangle, BufferedImage bufferedImage, Graphics2D graphics2D) {
        AffineTransform affineTransform;
        BufferedImage bufferedImage2 = new BufferedImage((int)rectangle.getWidth(), (int)rectangle.getHeight(), 1);
        Graphics2D graphics2D2 = (Graphics2D)bufferedImage2.getGraphics();
        for (double d2 = 0.0; d2 < rectangle.getHeight(); d2 += (double)bufferedImage.getHeight()) {
            for (double d3 = 0.0; d3 < rectangle.getWidth(); d3 += (double)bufferedImage.getWidth()) {
                affineTransform = new AffineTransform();
                affineTransform.setToTranslation(d3, d2);
                graphics2D2.drawRenderedImage(bufferedImage, affineTransform);
            }
        }
        graphics2D2.dispose();
        affineTransform = new AffineTransform();
        affineTransform.setToTranslation(rectangle.getX(), rectangle.getY());
        graphics2D.drawRenderedImage(bufferedImage2, affineTransform);
    }

    private void A(Graphics2D graphics2D) {
        int n2 = PGridLayer.getGridSpacing();
        int n3 = (int)this.\u011d.getX() / n2 * n2 - n2;
        int n4 = (int)this.\u011d.getY() / n2 * n2 - n2;
        int n5 = (int)this.\u011d.getHeight() / n2 + 3;
        int n6 = (int)this.\u011d.getX() + (int)this.\u011d.getWidth();
        int n7 = (int)this.\u011d.getY() + (int)this.\u011d.getHeight();
        graphics2D.setColor(this._colorLines);
        graphics2D.setStroke(\u0118);
        int n8 = n3;
        for (int i2 = (int)this.\u011d.getWidth() / n2 + 3; i2 > 0; --i2) {
            graphics2D.drawLine(n8, n4, n8, n7);
            n8 += n2;
        }
        int n9 = n4;
        while (n5 > 0) {
            graphics2D.drawLine(n3, n9, n6, n9);
            n9 += n2;
            --n5;
        }
    }

    private void B(Graphics2D graphics2D) {
        int n2 = PGridLayer.getGridSpacing();
        int n3 = (int)this.\u011d.getX() / n2 * n2 - n2;
        int n4 = (int)this.\u011d.getY() / n2 * n2 - n2;
        int n5 = (int)this.\u011d.getHeight() / n2 + 3;
        int n6 = (int)(this.\u011d.getX() + (double)((int)this.\u011d.getWidth())) / n2 * n2 + n2;
        int n7 = (int)(this.\u011d.getY() + (double)((int)this.\u011d.getHeight())) / n2 * n2 + n2;
        PBounds pBounds = this.getBoundsReference();
        Color color = (Color)this.getPaint();
        graphics2D.setColor(this._colorLines);
        graphics2D.setStroke(\u0117);
        int n8 = n3;
        for (int i2 = (int)this.\u011d.getWidth() / n2 + 3; i2 > 0; --i2) {
            graphics2D.drawLine(n8, n4, n8, n7);
            n8 += n2;
        }
        int n9 = n4;
        while (n5 > 0) {
            Rectangle2D rectangle2D = new Rectangle2D.Double(n3, n9 + _dotSize / 2, n6 - n3, n2 - _dotSize);
            if (pBounds.intersects(rectangle2D)) {
                graphics2D.setColor(COLOR_BACKGROUND);
                graphics2D.fill(rectangle2D);
                graphics2D.setColor(color);
                rectangle2D = pBounds.createIntersection(rectangle2D);
                graphics2D.fill(rectangle2D);
            } else {
                graphics2D.setColor(COLOR_BACKGROUND);
                graphics2D.fill(rectangle2D);
            }
            n9 += n2;
            --n5;
        }
    }

    public void setPreferredBoundsCache(PBounds pBounds) {
        this.\u011c.A(pBounds);
    }

    public PBounds getPreferredBoundsCache() {
        return this.\u011c.H();
    }

    public void setSize(double d2, double d3) {
        this.\u011c.B(d2, d3);
    }

    public double getWidth() {
        return this.\u011c.J();
    }

    public double getHeight() {
        return this.\u011c.K();
    }

    public void setTranslation(double d2, double d3) {
        this.\u011c.A(d2, d3);
    }

    public double getTranslateX() {
        return this.\u011c.E();
    }

    public double getTranslateY() {
        return this.\u011c.F();
    }

    public boolean isVisible() {
        return this.\u011c.C();
    }

    public List getContainedElements() {
        return this.\u011c.G();
    }

    public LayoutableElement getContainerElement() {
        return null;
    }

    public DiMemento getLayoutMemento(Project project) {
        return this.\u011c.B(project);
    }

    public SimpleTypeInfo getSimpleTypeInfo(Project project) {
        return this.\u011c.C(project);
    }

    public SemanticModelBridgePresentation getPresentation(Project project) {
        return this.\u011c.D(project);
    }

    public RefObject getSmElement(Project project, boolean bl) {
        return this.\u011c.A(project, bl);
    }

    public LayoutableElement findContainedWithModelElement(Project project, RefObject refObject) {
        return this.\u011c.A(project, refObject);
    }

    public Point2D getClosestPointOnBorder(Project project, Point2D point2D) {
        return this.\u011c.A(project, point2D);
    }

    public void transferToDi(Project project) {
        this.\u011c.A(project);
    }

    public Collection getConnectors() {
        return this.\u011c.B();
    }

    public String getProperty(String string, boolean bl, String string2) {
        return this.\u011c.A(string, bl, string2);
    }

    public void setProperty(Project project, String string, String string2) {
        this.\u011c.A(string, string2);
    }

    public Project getProject() {
        return this.\u011b;
    }

    public static Point2D snapDelta(Point2D point2D) {
        Point2D point2D2 = PGridLayer.snapPosition(point2D);
        double d2 = point2D2.getX() - point2D.getX();
        double d3 = point2D2.getY() - point2D.getY();
        return new Point2D.Double(d2, d3);
    }

    public static Point2D snapPosition(double d2, double d3) {
        if (PGridLayer.isGridSnap()) {
            int n2 = PGridLayer.getGridSnapSpacing();
            d2 = ((int)d2 + n2 / 2) / n2 * n2;
            d3 = ((int)d3 + n2 / 2) / n2 * n2;
        }
        return new Point2D.Double(d2, d3);
    }

    public static Point2D snapPosition(Point2D point2D) {
        return PGridLayer.snapPosition(point2D.getX(), point2D.getY());
    }

    public static void snapPosition(LayoutableNode layoutableNode) {
        if (PGridLayer.isGridSnap()) {
            Point2D point2D = LayoutableElements.getGlobalPosition(layoutableNode);
            Point2D point2D2 = PGridLayer.snapDelta(point2D);
            double d2 = layoutableNode.getTranslateX() + point2D2.getX();
            double d3 = layoutableNode.getTranslateY() + point2D2.getY();
            layoutableNode.setTranslation(d2, d3);
        }
    }

    public static void snapBounds(LayoutableNode layoutableNode, PBounds pBounds, boolean bl, boolean bl2, int n2) {
        if (PGridLayer.isGridSnap()) {
            double d2 = pBounds.getWidth();
            double d3 = pBounds.getHeight();
            boolean bl3 = n2 == 2 || n2 == 3 || n2 == 4;
            boolean bl4 = n2 == 8 || n2 == 7 || n2 == 6;
            boolean bl5 = n2 == 8 || n2 == 1 || n2 == 2;
            boolean bl6 = n2 == 6 || n2 == 5 || n2 == 4;
            double d4 = pBounds.getX();
            if (bl3) {
                d4 += d2;
            }
            double d5 = pBounds.getY();
            if (bl6) {
                d5 += d3;
            }
            Point2D.Double double_ = new Point2D.Double(d4, d5);
            LayoutableElement layoutableElement = layoutableNode.getContainerElement();
            if (layoutableElement != null) {
                LayoutableElements.convertToGlobal(layoutableElement, double_);
            }
            Point2D point2D = PGridLayer.snapDelta(double_);
            if (!bl) {
                d2 += (bl4 ? -1.0 : 1.0) * point2D.getX();
            }
            if (!bl2) {
                d3 += (bl5 ? -1.0 : 1.0) * point2D.getY();
            }
            double d6 = pBounds.getX();
            if (bl4) {
                d6 += point2D.getX();
            }
            double d7 = pBounds.getY();
            if (bl5) {
                d7 += point2D.getY();
            }
            pBounds.setOrigin(d6, d7);
            pBounds.setSize(d2, d3);
        }
    }
}

