/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.jboogie.ui;

import com.gentleware.jboogie.model_management.M;
import com.gentleware.jboogie.model_management.SimpleTypeInfo;
import com.gentleware.jboogie.openapi.Command;
import com.gentleware.jboogie.openapi.DiId;
import com.gentleware.jboogie.openapi.Project;
import com.gentleware.jboogie.openapi.SmId;
import com.gentleware.jboogie.piccolo.nodes.u;
import com.gentleware.jboogie.ui.DiagramPanel;
import com.gentleware.jboogie.util.E;
import com.gentleware.jboogie.util.GraphNodeBoundsLocator;
import com.gentleware.jboogie.util.GraphNodePointLocator;
import com.gentleware.services.Services;
import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.util.PAffineTransform;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.List;
import javax.jmi.reflect.RefObject;
import javax.swing.SwingUtilities;
import org.netbeans.jmiimpl.omg.uml2.diagraminterchange.DiagramElementImpl;
import org.netbeans.jmiimpl.omg.uml2.diagraminterchange.DiagramImpl;
import org.omg.uml2.diagraminterchange.DiagramElement;

public class J
implements DropTargetListener {
    protected Project _project;
    protected DiagramPanel _panel;
    protected DropTarget _dropTarget;
    protected boolean _acceptableType;

    public J(Project project, DiagramPanel diagramPanel) {
        this._project = project;
        this._panel = diagramPanel;
        this._dropTarget = new DropTarget((Component)((Object)this._panel), 2, this, true, null);
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        this.checkTransferType(dropTargetDragEvent);
        this.acceptOrRejectDrag(dropTargetDragEvent);
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        Services.logInfo((Object)"DropTarget dragExit");
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        this.acceptOrRejectDrag(dropTargetDragEvent);
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        Services.logInfo((Object)("DropTarget dropActionChanged, drop action = " + E.A(dropTargetDragEvent.getDropAction())));
        this.acceptOrRejectDrag(dropTargetDragEvent);
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        block5: {
            if ((dropTargetDropEvent.getDropAction() & 2) != 0) {
                try {
                    if (dropTargetDropEvent.isDataFlavorSupported(M.D)) {
                        dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                        boolean bl = this.dropNode(dropTargetDropEvent);
                        dropTargetDropEvent.dropComplete(bl);
                        Services.logInfo((Object)("Drop completed, success: " + bl));
                        break block5;
                    }
                    Services.logInfo((Object)"Drop target rejecting drop (wrong flavor)");
                    dropTargetDropEvent.rejectDrop();
                }
                catch (Exception exception) {
                    Services.logInfo((Object)"Drop target rejecting drop (exception)", (Throwable)exception);
                    exception.printStackTrace();
                    dropTargetDropEvent.dropComplete(false);
                }
            } else {
                Services.logInfo((Object)"Drop target rejected drop");
                dropTargetDropEvent.rejectDrop();
            }
        }
    }

    protected boolean acceptOrRejectDrag(DropTargetDragEvent dropTargetDragEvent) {
        int n2 = dropTargetDragEvent.getDropAction();
        int n3 = dropTargetDragEvent.getSourceActions();
        boolean bl = false;
        if (!this._acceptableType || (n3 & 3) == 0) {
            dropTargetDragEvent.rejectDrag();
        } else if ((n2 & 3) == 0) {
            dropTargetDragEvent.rejectDrag();
        } else {
            dropTargetDragEvent.acceptDrag(n2);
            bl = true;
        }
        return bl;
    }

    protected void checkTransferType(DropTargetDragEvent dropTargetDragEvent) {
        this._acceptableType = dropTargetDragEvent.isDataFlavorSupported(M.D);
    }

    protected boolean dropAllowed(Object object, com.gentleware.jboogie.B.E e2) {
        DiagramImpl diagramImpl = this._panel.getDiagram();
        if (diagramImpl.getSimpleTypeInfo().equals(SimpleTypeInfo.SEQUENCE_DIAGRAM)) {
            return false;
        }
        if (diagramImpl.getSimpleTypeInfo().equals(SimpleTypeInfo.STATE_DIAGRAM)) {
            return false;
        }
        if (diagramImpl.getSimpleTypeInfo().equals(SimpleTypeInfo.COLLABORATION_DIAGRAM)) {
            return false;
        }
        if (diagramImpl.getSimpleTypeInfo().equals(SimpleTypeInfo.ACTIVITY_DIAGRAM)) {
            return false;
        }
        if (object instanceof RefObject) {
            RefObject refObject = (RefObject)object;
            if (!this._project.getDiPulizerPool().A(refObject).A((DiagramElement)this._panel.getDiagram(), refObject)) {
                return false;
            }
        }
        if (this._project.getDiHelpers().hasPresentationIn(this._panel.getDiagram(), (RefObject)object)) {
            return false;
        }
        return e2.canDragAndDropModelElementType(object.getClass());
    }

    protected boolean dropNode(DropTargetDropEvent dropTargetDropEvent) throws IOException, UnsupportedFlavorException, MalformedURLException {
        Transferable transferable = dropTargetDropEvent.getTransferable();
        Object object = transferable.getTransferData(M.D);
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        Point2D point2D = dropTargetDropEvent.getLocation();
        PCanvas pCanvas = this._panel.getCanvas();
        point2D = SwingUtilities.convertPoint((Component)((Object)this._panel), (int)((Point2D)point2D).getX(), (int)((Point2D)point2D).getY(), (Component)pCanvas);
        PCamera pCamera = pCanvas.getCamera();
        PAffineTransform pAffineTransform = pCamera.getViewTransform();
        try {
            point2D = pAffineTransform.inverseTransform(point2D, null);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            Services.logError((Object)noninvertibleTransformException);
        }
        DiId diId = this._project.getDiId(this._panel.getDiagram());
        Iterator iterator = list.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (!this.isTransferableElement(e2)) {
                bl = false;
                continue;
            }
            RefObject refObject = (RefObject)e2;
            DiagramElementImpl diagramElementImpl = u.findDragTargetDiElement(point2D, pCamera, this._project, null);
            com.gentleware.jboogie.B.E e3 = this._project.getModelMapper().getController(diagramElementImpl);
            if (!this.dropAllowed(refObject, e3)) {
                return false;
            }
            DiId diId2 = this._project.getNextDiId();
            Command command = this.createDragCommand(diId2, this._project.getSmId(refObject), diId, point2D, GraphNodeBoundsLocator.EXACT);
            if (command == null) continue;
            command.execute();
        }
        return bl;
    }

    protected void showDataFlavors(DataFlavor[] dataFlavorArray) {
        for (int i2 = 0; i2 < dataFlavorArray.length; ++i2) {
            Services.logInfo((Object)("DropTarget show data flavors = " + dataFlavorArray[i2]));
        }
    }

    protected boolean isTransferableElement(Object object) {
        return object instanceof RefObject;
    }

    protected Command createDragCommand(DiId diId, SmId smId, DiId diId2, Point2D point2D, GraphNodePointLocator graphNodePointLocator) {
        return this._project.getDiCommandFactory().makeCommandAddNodeFromSmElement(diId, smId, diId2, point2D, graphNodePointLocator);
    }
}

