/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.jboogie.util;

import com.gentleware.jboogie.openapi.SmId;
import com.gentleware.jboogie.util.LockChecker;
import com.gentleware.services.Services;
import java.util.Iterator;
import java.util.Set;

public class ConflictChecker {
    public static int CREATE = 0;
    public static int CHANGE = 1;
    public static int DELETE = 2;
    private LockChecker B;
    private String C;
    private boolean A = true;

    public void activate() {
        Services.logInfo((Object)"Conflict-Checking activated");
        this.A = true;
    }

    public void deactivate() {
        Services.logInfo((Object)"Conflict-Checking deactivated");
        this.A = false;
    }

    public final boolean doesConflict(int n2, SmId smId) {
        if (!this.A) {
            return false;
        }
        return this.A(n2, smId);
    }

    public boolean doesConflictWithCurrentModel(Set set) {
        LockChecker lockChecker = this.getLockChecker();
        if (lockChecker.indicatesLocks()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                SmId smId = (SmId)iterator.next();
                if (!smId.hasElement() || this.C == null || !lockChecker.isRemotelyLocked(this.C, smId)) continue;
                Services.logInfo((Object)("Command " + this + " can't be executed, because the element " + smId.getElement() + "is locked! "));
                return true;
            }
        }
        return false;
    }

    protected boolean A(int n2, SmId smId) {
        if (smId != null && !smId.hasElement()) {
            Services.logInfo((Object)("smid " + smId + " has no element!" + smId.getXmiId()));
            return true;
        }
        if (this.B != null) {
            boolean bl = this.B.isRemotelyLocked(this.C, smId);
            if (bl) {
                Services.logInfo((Object)("Lock conflict detected: Modelelement " + smId.getElement() + " is locked! Requestor is " + this.C + ", but lockholder is someone else "));
            }
            return bl;
        }
        return false;
    }

    public void setLockChecker(LockChecker lockChecker) {
        this.B = lockChecker;
    }

    public LockChecker getLockChecker() {
        return this.B;
    }

    public void setParticipantId(String string) {
        this.C = string;
    }

    public String getParticipantId() {
        return this.C;
    }

    public boolean isActive() {
        return this.A;
    }
}

