/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.jboogie.util;

import com.gentleware.jboogie.layout.LayoutableEdge;
import com.gentleware.jboogie.layout.LayoutableEdges;
import com.gentleware.services.util.Geometry;
import java.awt.geom.Point2D;

public class PointOnEdge {
    private final LayoutableEdge B;
    private final int A;
    private double C;

    public PointOnEdge(LayoutableEdge layoutableEdge, int n2, double d2) {
        this.B = layoutableEdge;
        this.A = n2;
        this.C = d2;
    }

    public static PointOnEdge getClosestPointOnEdge(LayoutableEdge layoutableEdge, double d2, double d3) {
        int n2 = layoutableEdge.getWaypointCount();
        int n3 = 0;
        double d4 = Double.MAX_VALUE;
        double d5 = 0.0;
        for (int i2 = 0; i2 < n2 - 1; ++i2) {
            double d6;
            double d7;
            double d8;
            double d9;
            double d10 = layoutableEdge.getWaypointX(i2);
            Point2D point2D = Geometry.getClosestPointOnSegment((double)d10, (double)(d9 = layoutableEdge.getWaypointY(i2)), (double)(d8 = layoutableEdge.getWaypointX(i2 + 1)), (double)(d7 = layoutableEdge.getWaypointY(i2 + 1)), (double)d2, (double)d3);
            double d11 = point2D.distance(d2, d3);
            if (!(d11 < d4)) continue;
            d4 = d11;
            n3 = i2;
            double d12 = Math.abs(d10 - d8);
            d5 = d12 > (d6 = Math.abs(d9 - d7)) ? Math.abs(point2D.getX() - d10) / d12 : Math.abs(point2D.getY() - d9) / d6;
        }
        return new PointOnEdge(layoutableEdge, n3, d5);
    }

    public Point2D getPoint() {
        double d2 = this.B.getWaypointX(this.A);
        double d3 = this.B.getWaypointY(this.A);
        if (!LayoutableEdges.hasNextWaypoint(this.B, this.A)) {
            return new Point2D.Double(d2, d3);
        }
        int n2 = LayoutableEdges.getNextWaypointIndex(this.A);
        double d4 = this.B.getWaypointX(n2);
        double d5 = this.B.getWaypointY(n2);
        double d6 = d4 - d2;
        double d7 = d5 - d3;
        double d8 = d2 + this.C * d6;
        double d9 = d3 + this.C * d7;
        return new Point2D.Double(d8, d9);
    }

    public int getWaypointIndex() {
        return this.A;
    }

    public double getPercentToNextWaypoint() {
        return this.C;
    }

    public double getTangentAngle() {
        return LayoutableEdges.getAngleAtWaypoint(this.B, this.A);
    }

    public LayoutableEdge getEdge() {
        return this.B;
    }
}

