/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.jboogie.util.graphicswriter;

import com.gentleware.jboogie.kernel.FileFormatsResourceBundle;
import com.gentleware.jboogie.util.PsGraphics;
import com.gentleware.jboogie.util.graphicswriter.GraphicsWriter;
import com.gentleware.services.Services;
import com.gentleware.services.swingx.ResourceId;
import edu.umd.cs.piccolo.PCanvas;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.OutputStream;

public class EpsWriter
extends GraphicsWriter {
    public void write(OutputStream outputStream, PCanvas pCanvas, Rectangle rectangle) throws GraphicsWriter.WriteException {
        try {
            Services.logInfo((Object)"Writing Encapsulated PostScript...");
            PsGraphics psGraphics = new PsGraphics(outputStream, rectangle);
            psGraphics.translate(32, 810);
            double d2 = Math.min(535.0 / (double)rectangle.width, 778.0 / (double)rectangle.height);
            if (d2 < 1.0) {
                Services.logInfo((Object)("Scaling PS output by " + d2));
                psGraphics.scale(d2, d2);
            }
            psGraphics.translate(-rectangle.x, -rectangle.y);
            psGraphics.setClip(rectangle);
            pCanvas.print((Graphics)psGraphics);
            psGraphics.dispose();
            Services.logInfo((Object)"Wrote Encapsulated PostScript.");
        }
        catch (IOException iOException) {
            throw new GraphicsWriter.WriteException(iOException);
        }
    }

    public String getFormatName() {
        return "Encapsulated PostScript";
    }

    public ResourceId getFormatNameResourceId() {
        return FileFormatsResourceBundle.EPS;
    }

    public String getDefaultFileSuffix() {
        return "eps";
    }

    public String[] getFileSuffixes() {
        return new String[]{"eps", "ps", "ai"};
    }
}

