/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.jboogie.util.graphicswriter;

import com.gentleware.jboogie.kernel.FileFormatsResourceBundle;
import com.gentleware.jboogie.util.graphicswriter.FreehepWriter;
import com.gentleware.jboogie.util.graphicswriter.GifWriter;
import com.gentleware.jboogie.util.graphicswriter.ImageIOGraphicsWriter;
import com.gentleware.jboogie.util.graphicswriter.SvgWriter;
import com.gentleware.jboogie.util.graphicswriter.WmfWriter;
import com.gentleware.services.swingx.ResourceId;
import com.gentleware.services.swingx.SuffixFileFilter;
import com.gentleware.services.util.CollectionFactory;
import com.gentleware.services.util.Utils;
import edu.umd.cs.piccolo.PCanvas;
import java.awt.Rectangle;
import java.io.OutputStream;
import java.util.Map;

public abstract class GraphicsWriter {
    private static GraphicsWriter[] B;
    private GraphicsFileFilter A;
    private static Map C;

    protected GraphicsWriter() {
    }

    private static void A() {
        GifWriter gifWriter = new GifWriter();
        C.put(gifWriter.getFormatName(), gifWriter);
        SvgWriter svgWriter = new SvgWriter();
        C.put(svgWriter.getFormatName(), svgWriter);
        WmfWriter wmfWriter = new WmfWriter();
        C.put(wmfWriter.getFormatName(), wmfWriter);
        if (Utils.canWriteImage((String)"png")) {
            C.put("png", new ImageIOGraphicsWriter("png", "Portable Network Graphics", "png", FileFormatsResourceBundle.PNG));
        }
        if (Utils.canWriteImage((String)"pnm")) {
            C.put("pnm", new ImageIOGraphicsWriter("pnm", "Portable Bitmap", "pbm", FileFormatsResourceBundle.PNM));
        }
        if (Utils.canWriteImage((String)"jpeg 2000")) {
            C.put("jpeg 2000", new ImageIOGraphicsWriter("jpeg 2000", "JPEG 2000", "jp2", new String[]{"jp2", "j2c", "j2k", "jpc", "jpx"}, FileFormatsResourceBundle.JPG2000));
        }
        if (Utils.canWriteImage((String)"tif")) {
            C.put("tif", new ImageIOGraphicsWriter("tif", "Tagged Image File Format", "tif", new String[]{"tif", "tiff"}, FileFormatsResourceBundle.TIF));
        }
        if (Utils.canWriteImage((String)"")) {
            C.put("", new ImageIOGraphicsWriter("", "Raw Image", "raw", FileFormatsResourceBundle.RawImage));
        }
        if (Utils.canWriteImage((String)"JPEG")) {
            C.put("JPEG", new ImageIOGraphicsWriter("JPEG", "JPEG", "jpg", new String[]{"jpg", "jpeg"}, FileFormatsResourceBundle.JPEG));
        }
        if (Utils.canWriteImage((String)"wbmp")) {
            C.put("wbmp", new ImageIOGraphicsWriter("wbmp", "Wireless Bitmap", "wbmp", new String[]{"wbmp", "wbm"}, FileFormatsResourceBundle.WBMP));
        }
        if (Utils.canWriteImage((String)"bmp")) {
            C.put("bmp", new ImageIOGraphicsWriter("bmp", "Windows Bitmap", "bmp", FileFormatsResourceBundle.BMP));
        }
        C.put("ps", new FreehepWriter("ps", "PostScript", "ps", FileFormatsResourceBundle.PS));
        C.put("eps", new FreehepWriter("eps", "Encapsulated PostScript", "eps", new String[]{"eps", "epsi", "epi", "epsf"}, FileFormatsResourceBundle.EPS));
        C.put("pdf", new FreehepWriter("pdf", "Portable Document Format", "pdf", FileFormatsResourceBundle.PDF));
        B = C.values().toArray(new GraphicsWriter[C.size()]);
    }

    public static GraphicsWriter[] getAll() {
        GraphicsWriter.A();
        return B;
    }

    public static GraphicsWriter get(String string) {
        GraphicsWriter graphicsWriter = (GraphicsWriter)C.get(string);
        return graphicsWriter;
    }

    public void write(OutputStream outputStream, PCanvas pCanvas) throws WriteException {
        Rectangle rectangle = new Rectangle(0, 0, pCanvas.getWidth(), pCanvas.getHeight());
        if (rectangle.width <= 0) {
            rectangle.width = 1;
        }
        if (rectangle.height <= 0) {
            rectangle.height = 1;
        }
        this.write(outputStream, pCanvas, rectangle);
    }

    public abstract void write(OutputStream var1, PCanvas var2, Rectangle var3) throws WriteException;

    public abstract String getFormatName();

    public abstract ResourceId getFormatNameResourceId();

    public abstract String getDefaultFileSuffix();

    public String[] getFileSuffixes() {
        return new String[]{this.getDefaultFileSuffix()};
    }

    public boolean isFileSuffix(String string) {
        String[] stringArray = this.getFileSuffixes();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string2 = stringArray[i2];
            if (!string.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    public GraphicsFileFilter getFileChooserFilter() {
        if (this.A == null) {
            this.A = new GraphicsFileFilter(this, this.getFileSuffixes(), this.getFormatNameResourceId());
        }
        return this.A;
    }

    static {
        C = CollectionFactory.createHashMap();
    }

    public static class GraphicsFileFilter
    extends SuffixFileFilter {
        private final GraphicsWriter F;

        GraphicsFileFilter(GraphicsWriter graphicsWriter, String[] stringArray, ResourceId resourceId) {
            super(stringArray, resourceId);
            this.F = graphicsWriter;
        }

        public GraphicsWriter getWriter() {
            return this.F;
        }
    }

    public static class WriteException
    extends Exception {
        public WriteException(String string) {
            super(string);
        }

        public WriteException(String string, Throwable throwable) {
            super(string, throwable);
        }

        public WriteException(Throwable throwable) {
            super(throwable);
        }
    }
}

