/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.jboogie.util.graphicswriter;

import com.gentleware.jboogie.util.graphicswriter.GraphicsWriter;
import com.gentleware.jboogie.util.graphicswriter.MultiSuffixWriter;
import com.gentleware.services.Services;
import com.gentleware.services.swingx.ResourceId;
import com.gentleware.services.util.Utils;
import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;

public class ImageIOGraphicsWriter
extends MultiSuffixWriter {
    public ImageIOGraphicsWriter(String string, String string2, String string3, ResourceId resourceId) {
        super(string, string2, string3, resourceId);
    }

    public ImageIOGraphicsWriter(String string, String string2, String string3, String[] stringArray, ResourceId resourceId) {
        super(string, string2, string3, stringArray, resourceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream outputStream, PCanvas pCanvas, Rectangle rectangle) throws GraphicsWriter.WriteException {
        Services.logDebug((Object)("Writing " + this._formatShort + "..."));
        BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            graphics2D.setClip(0, 0, rectangle.width, rectangle.height);
            graphics2D.translate(-rectangle.x, -rectangle.y);
            PPaintContext pPaintContext = new PPaintContext(graphics2D);
            PCamera pCamera = pCanvas.getCamera();
            pPaintContext.pushCamera(pCamera);
            pCamera.fullPaint(pPaintContext);
            try {
                Utils.writeImage((RenderedImage)bufferedImage, (String)this._formatShort, (OutputStream)outputStream);
            }
            catch (IOException iOException) {
                throw new GraphicsWriter.WriteException(iOException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new GraphicsWriter.WriteException(illegalArgumentException);
            }
        }
        finally {
            graphics2D.dispose();
        }
        Services.logDebug((Object)("Wrote " + this._formatShort));
    }
}

