/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.jboogie.util.graphicswriter;

import com.gentleware.jboogie.kernel.FileFormatsResourceBundle;
import com.gentleware.jboogie.util.graphicswriter.GraphicsWriter;
import com.gentleware.services.Services;
import com.gentleware.services.swingx.ResourceId;
import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.svggen.SVGGraphics2DIOException;
import org.w3c.dom.Document;

public class SvgWriter
extends GraphicsWriter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream outputStream, PCanvas pCanvas, Rectangle rectangle) throws GraphicsWriter.WriteException {
        Services.logDebug((Object)"Writing Scalable Vector Graphics...");
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            SVGGraphics2D sVGGraphics2D = new SVGGraphics2D(document);
            try {
                sVGGraphics2D.setClip((Shape)rectangle);
                PPaintContext pPaintContext = new PPaintContext((Graphics2D)sVGGraphics2D);
                PCamera pCamera = pCanvas.getCamera();
                pPaintContext.pushCamera(pCamera);
                pCamera.fullPaint(pPaintContext);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
                sVGGraphics2D.stream((Writer)outputStreamWriter);
                Services.logDebug((Object)"Wrote Scalable Vector Graphics...");
            }
            finally {
                sVGGraphics2D.dispose();
            }
        }
        catch (SVGGraphics2DIOException sVGGraphics2DIOException) {
            throw new GraphicsWriter.WriteException(sVGGraphics2DIOException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new GraphicsWriter.WriteException(unsupportedEncodingException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new GraphicsWriter.WriteException(parserConfigurationException);
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new GraphicsWriter.WriteException(factoryConfigurationError);
        }
    }

    public String getFormatName() {
        return "Scalable Vector Graphics";
    }

    public ResourceId getFormatNameResourceId() {
        return FileFormatsResourceBundle.SVG;
    }

    public String getDefaultFileSuffix() {
        return "svg";
    }
}

