/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreeindex;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.StorageIOException;
import org.netbeans.mdr.persistence.StoragePersistentDataException;
import org.netbeans.mdr.persistence.Streamable;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.BigKeyPage;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.Btree;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.BtreePageSource;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.EntryTypeInfo;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.SearchResult;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.SinglevaluedBtree;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.Converter;

public abstract class BtreePage
implements Streamable {
    Btree btree;
    BtreePageSource pageSource;
    public byte[] pageBuffer;
    public byte[] pageId;
    byte[] nextPage;
    byte[] previousPage;
    short flags;
    int freeStart;
    static final short BTREE_LEAF_PAGE = 1;
    static final short BTREE_ROOT_PAGE = 2;
    static final int SIZE_OF_SHORT = 2;
    int dataLength;
    int headerLength;
    boolean initialized = false;

    abstract BtreeEntry insert(BtreeEntry var1, int var2, SearchResult var3) throws StorageException;

    abstract BtreeEntry replace(BtreeEntry var1, int var2, SearchResult var3) throws StorageException;

    abstract void delete(int var1, int var2) throws StorageException;

    abstract byte[] getData(int var1) throws StorageException;

    abstract byte[] getKey(int var1) throws StorageException;

    abstract int numEntries();

    abstract int keyOffset(int var1);

    abstract int keyLength(int var1);

    abstract byte[] splitEntries(BtreePage var1, BtreePage var2, BtreeEntry var3, int var4, SearchResult var5) throws StorageException;

    public void init(Btree btree, byte[] pageId, byte[] pageBuffer, boolean isNew) throws StorageException {
        if (this.initialized) {
            return;
        }
        this.btree = btree;
        this.pageSource = btree.pageSource;
        this.headerLength = btree.pageIdLength * 2 + 4;
        if (this.pageId == null) {
            this.pageId = new byte[btree.pageIdLength];
            this.nextPage = new byte[btree.pageIdLength];
            this.previousPage = new byte[btree.pageIdLength];
        }
        System.arraycopy(pageId, 0, this.pageId, 0, pageId.length);
        if (pageBuffer == null) {
            throw new StoragePersistentDataException("Received null page buffer");
        }
        if (pageBuffer.length != btree.pageSize) {
            throw new StoragePersistentDataException("Page buffer size " + pageBuffer.length + " doesn't match expected page size " + btree.pageSize);
        }
        this.pageBuffer = pageBuffer;
        if (isNew) {
            this.pageSource.setNoPage(this.nextPage);
            this.pageSource.setNoPage(this.previousPage);
            this.freeStart = this.headerLength;
            this.makeLeaf();
        } else {
            this.readHeader(pageBuffer);
        }
        this.initialized = true;
    }

    private void readHeader(byte[] pageBuffer) {
        int i;
        int offset = 0;
        int pageIdLength = this.pageId.length;
        for (i = 0; i < pageIdLength; ++i) {
            this.nextPage[i] = Converter.readByte(pageBuffer, offset++);
        }
        for (i = 0; i < pageIdLength; ++i) {
            this.previousPage[i] = Converter.readByte(pageBuffer, offset++);
        }
        this.flags = Converter.readShort(pageBuffer, offset);
        this.freeStart = Converter.readShort(pageBuffer, offset += 2);
        if (this.isLeaf()) {
            this.makeLeaf();
        } else {
            this.makeInternal();
        }
    }

    public void store() {
        int pageIdLength = this.pageId.length;
        int offset = 0;
        System.arraycopy(this.nextPage, 0, this.pageBuffer, offset, pageIdLength);
        System.arraycopy(this.previousPage, 0, this.pageBuffer, offset += pageIdLength, pageIdLength);
        Converter.writeShort(this.pageBuffer, offset += pageIdLength, this.flags);
        short shortFreeStart = (short)this.freeStart;
        Converter.writeShort(this.pageBuffer, offset += 2, shortFreeStart);
    }

    public void read(InputStream in) throws StorageException {
        try {
            this.pageBuffer = new byte[in.available()];
            in.read(this.pageBuffer);
        }
        catch (IOException e) {
            throw new StorageIOException(e);
        }
    }

    public void write(OutputStream out) throws StorageException {
        this.store();
        try {
            out.write(this.pageBuffer);
        }
        catch (IOException e) {
            throw new StorageIOException(e);
        }
    }

    public void uninit() {
        this.initialized = false;
    }

    public void put(byte[] key, byte[] data, byte operation, int index) throws StorageException {
        if (!this.isBigKey(key)) {
            this.put(new BtreeEntry(key, data), operation, index, null);
        } else {
            this.putBigKey(new BtreeEntry(key, data), operation, index, null);
        }
    }

    public void put(byte[] key, byte[] data, byte operation, int index, SearchResult resultPosition) throws StorageException {
        if (!this.isBigKey(key)) {
            this.put(new BtreeEntry(key, data), operation, index, resultPosition);
        } else {
            this.putBigKey(new BtreeEntry(key, data), operation, index, resultPosition);
        }
    }

    ParentEntry put(BtreeEntry entry, byte operation, int index, SearchResult resultPosition) throws StorageException {
        ParentEntry parentEntry;
        SearchResult searchResult = this.searchPage(entry.key);
        if (this.isLeaf()) {
            BtreePage page = searchResult.page;
            parentEntry = page.putHere(operation, searchResult, entry, index, resultPosition);
            if (searchResult.page != page) {
                this.pageSource.unpinPage(searchResult.page);
            }
            if (page != this) {
                this.pageSource.unpinPage(page);
            }
        } else {
            BtreePage child = searchResult.page.getChild(searchResult);
            ParentEntry myEntry = child.put(entry, operation, index, resultPosition);
            this.pageSource.unpinPage(child);
            parentEntry = myEntry == null ? null : this.insertParentEntry(myEntry, searchResult);
        }
        return parentEntry;
    }

    private ParentEntry insertParentEntry(ParentEntry entry, SearchResult location) throws StorageException {
        ParentEntry newParentEntry = null;
        BtreeEntry splitEntry = null;
        if (location.matched) {
            ++entry.skipCount;
        }
        if (entry.skipCount > 0) {
            this.findNth(location, null, entry.skipCount, true);
        }
        if (location.entryNum == 0) {
            BtreePage.getPrevious(entry.key, location);
            ++location.entryNum;
        }
        if ((splitEntry = location.page.insert(entry, location.entryNum, null)) != null) {
            newParentEntry = new ParentEntry(splitEntry, location.skipCount);
        }
        return newParentEntry;
    }

    private ParentEntry putHere(byte operation, SearchResult location, BtreeEntry entry, int index, SearchResult resultPosition) throws StorageException {
        ParentEntry parentEntry = null;
        switch (operation) {
            case 0: {
                BtreeEntry splitEntry;
                if (location.matched && this.btree.uniqueKeys) {
                    this.btree.failed = true;
                    break;
                }
                if (location.matched && this.btree.uniqueValues) {
                    SearchResult testLocation = new SearchResult(location.matched, location.entryNum, location.page);
                    this.btree.failed = this.findMatchingData(testLocation, entry.key, entry.data);
                    if (testLocation.page != location.page && testLocation.page != this) {
                        this.pageSource.unpinPage(testLocation.page);
                    }
                }
                if (!this.btree.failed && index > 0) {
                    boolean bl = this.btree.failed = !this.findNth(location, entry.key, index, true);
                }
                if (this.btree.failed || (splitEntry = location.page.insert(entry, location.entryNum, resultPosition)) == null) break;
                parentEntry = new ParentEntry(splitEntry, location.skipCount);
                break;
            }
            case 1: {
                BtreeEntry splitEntry;
                if (!location.matched) {
                    this.btree.failed = true;
                    break;
                }
                if (index > 0) {
                    boolean bl = this.btree.failed = !this.findNth(location, entry.key, index, false);
                }
                if (this.btree.failed || (splitEntry = location.page.replace(entry, location.entryNum, resultPosition)) == null) break;
                parentEntry = new ParentEntry(splitEntry, location.skipCount);
                break;
            }
            case 2: {
                BtreeEntry splitEntry;
                if (!location.matched) {
                    splitEntry = this.insert(entry, location.entryNum, resultPosition);
                } else {
                    splitEntry = this.replace(entry, location.entryNum, resultPosition);
                    this.btree.replaced = true;
                }
                if (splitEntry == null) break;
                parentEntry = new ParentEntry(splitEntry, 0);
            }
        }
        return parentEntry;
    }

    boolean findNth(SearchResult searchResult, byte[] key, int target, boolean adding) throws StorageException {
        if (target == Integer.MAX_VALUE && !searchResult.matched) {
            return true;
        }
        for (int i = 1; i <= target; ++i) {
            BtreePage page = searchResult.page;
            BtreePage.getNext(key, searchResult, false);
            if (searchResult.page != page && page != this) {
                this.pageSource.unpinPage(page);
            }
            if (searchResult.matched) continue;
            if (adding && (i == target || target == Integer.MAX_VALUE)) {
                if (searchResult.entryNum == 0 && !this.isBigKey(key)) {
                    BtreePage.getPrevious(key, searchResult);
                    ++searchResult.entryNum;
                }
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean findMatchingData(SearchResult searchResult, byte[] key, byte[] value) throws StorageException {
        boolean found;
        do {
            boolean bl = found = searchResult.page.compareData(value, searchResult.entryNum) == 0;
            if (found) continue;
            BtreePage page = searchResult.page;
            BtreePage.getNext(key, searchResult, false);
            if (searchResult.page == page || page == this) continue;
            this.pageSource.unpinPage(page);
            ++searchResult.skipCount;
        } while (!found && searchResult.matched);
        return found;
    }

    public byte[] get(byte[] key) throws StorageException {
        SearchResult searchResult = this.getLocation(key);
        BtreePage page = searchResult.page;
        byte[] data = searchResult.matched ? page.getData(searchResult.entryNum) : null;
        if (page != this) {
            this.pageSource.unpinPage(page);
        }
        return data;
    }

    public SearchResult getLocation(byte[] key) throws StorageException {
        if (this.isBigKey(key)) {
            return this.searchBigKeys(key);
        }
        SearchResult searchResult = this.searchPage(key);
        if (this.isLeaf()) {
            return searchResult;
        }
        BtreePage child = searchResult.page.getChild(searchResult);
        searchResult = child.getLocation(key);
        if (searchResult.page != child) {
            this.pageSource.unpinPage(child);
        }
        return searchResult;
    }

    SearchResult getFirst() throws StorageException {
        SearchResult location = new SearchResult(false, 0, this);
        while (!location.page.isLeaf()) {
            BtreePage parent = location.page;
            location.page = location.page.getChild(location);
            if (parent == location.page) continue;
            this.pageSource.unpinPage(parent);
        }
        location.entryNum = -1;
        BtreePage.getNext(null, location);
        if (!location.matched && this.btree.hasBigKeys()) {
            BtreePage.getFirstBigKey(location, false);
        }
        return location;
    }

    public boolean remove(byte[] key) throws StorageException {
        boolean found;
        BtreePage page = null;
        SearchResult result = this.getLocation(key);
        if (!result.matched) {
            found = false;
        } else {
            found = true;
            if (this.btree.uniqueKeys) {
                result.page.delete(result.entryNum, result.entryNum);
            } else {
                page = result.page;
                while (result.matched) {
                    page = result.page;
                    int first = result.entryNum;
                    int last = result.entryNum;
                    while (result.matched && result.page == page) {
                        last = result.entryNum;
                        BtreePage.getNext(key, result);
                    }
                    page.delete(first, last);
                    if (page == this) continue;
                    this.pageSource.unpinPage(page);
                }
            }
        }
        if (result.page != this && result.page != page) {
            this.pageSource.unpinPage(result.page);
        }
        return found;
    }

    public boolean remove(byte[] key, byte[] data) throws StorageException {
        boolean found;
        SearchResult result = this.getLocation(key);
        if (!result.matched) {
            found = false;
        } else {
            BtreePage page = result.page;
            if (page.findMatchingData(result, key, data)) {
                found = true;
                result.page.delete(result.entryNum, result.entryNum);
            } else {
                found = false;
            }
            if (page != this && page != result.page) {
                this.pageSource.unpinPage(page);
            }
        }
        if (result.page != this) {
            this.pageSource.unpinPage(result.page);
        }
        return found;
    }

    public boolean remove(byte[] key, int index) throws StorageException {
        boolean found;
        SearchResult result = this.getLocation(key);
        if (!result.matched) {
            found = false;
        } else {
            BtreePage page = result.page;
            if (page.findNth(result, key, index, false)) {
                found = true;
                result.page.delete(result.entryNum, result.entryNum);
            } else {
                found = false;
            }
            if (page != this && page != result.page) {
                this.pageSource.unpinPage(page);
            }
        }
        if (result.page != this) {
            this.pageSource.unpinPage(result.page);
        }
        return found;
    }

    private BtreePage getChild(SearchResult searchResult) throws StorageException {
        int childEntry = searchResult.matched || searchResult.entryNum == 0 ? searchResult.entryNum : searchResult.entryNum - 1;
        return this.pageSource.getPage(this.getData(childEntry), this.btree);
    }

    private SearchResult searchPage(byte[] key) throws StorageException {
        int base = 0;
        SearchResult result = null;
        if (this.numEntries() > 0) {
            base = 0;
            for (int limit = this.numEntries(); limit > 0; limit /= 2) {
                int midpoint = base + limit / 2;
                byte compare = this.compare(key, midpoint);
                if (compare == 0) {
                    result = new SearchResult(true, midpoint, this);
                    break;
                }
                if (compare != 1) continue;
                base = midpoint + 1;
                --limit;
            }
        }
        if (result == null) {
            result = new SearchResult(false, base, this);
        }
        if (!this.btree.uniqueKeys) {
            SearchResult test = new SearchResult(result);
            if (!result.matched && this.isLeaf()) {
                if (result.entryNum == 0) {
                    BtreePage.getPrevious(key, test);
                    if (test.matched) {
                        test.copy(result);
                    }
                }
                if (!result.matched && result.entryNum == this.numEntries()) {
                    result.copy(test);
                    BtreePage.getNext(key, test);
                    if (test.matched) {
                        test.copy(result);
                    }
                }
            }
            if (result.matched) {
                result.copy(test);
                do {
                    BtreePage.getPrevious(key, test);
                    if (!test.matched) continue;
                    if (test.page != result.page && result.page != this) {
                        this.pageSource.unpinPage(result.page);
                    }
                    test.copy(result);
                } while (test.matched);
            }
        }
        return result;
    }

    SearchResult searchPage(byte[] key, int position) throws StorageException {
        if (this.isLeaf() && position < this.numEntries() && this.compare(key, position) == 0) {
            SearchResult result = new SearchResult(true, position, this);
            if (position > 0) {
                if (this.compare(key, position - 1) != 0) {
                    return result;
                }
            } else {
                BtreePage.getPrevious(key, result);
                if (!result.matched) {
                    result.matched = true;
                    result.entryNum = position;
                    result.page = this;
                    return result;
                }
            }
        }
        return this.getLocation(key);
    }

    static void getPrevious(byte[] key, SearchResult result) throws StorageException {
        int traversed = 0;
        int entry = result.entryNum;
        BtreePage page = result.page;
        boolean endOfChain = false;
        Btree btree = page.btree;
        BtreePageSource pageSource = btree.pageSource;
        if (page instanceof BigKeyPage) {
            BigKeyPage.getPrevious(key, result);
            return;
        }
        while (!(endOfChain = pageSource.isNoPage(page.previousPage)) && entry == 0) {
            BtreePage newPage = pageSource.getPage(page.previousPage, btree);
            ++traversed;
            if (page.numEntries() == 0 && page != result.page) {
                pageSource.unpinPage(page);
            }
            page = newPage;
            entry = page.numEntries();
        }
        if (endOfChain && entry == 0) {
            result.matched = false;
        } else {
            result.matched = key == null || page.compare(key, --entry) == 0;
            result.entryNum = entry;
            result.page = page;
            result.skipCount -= traversed;
        }
    }

    static boolean hasNext(byte[] key, SearchResult result) throws StorageException {
        BtreePage.getNext(key, result, true);
        return result.matched;
    }

    static void getNext(byte[] key, SearchResult result) throws StorageException {
        BtreePage.getNext(key, result, false);
    }

    static void getNext(byte[] key, SearchResult result, boolean testOnly) throws StorageException {
        int traversed = 0;
        BtreePage page = result.page;
        Btree btree = page.btree;
        BtreePageSource pageSource = btree.pageSource;
        boolean endOfChain = false;
        if (page instanceof BigKeyPage) {
            BigKeyPage.getNext(key, result, testOnly);
            return;
        }
        int entry = page.numEntries() > 0 ? result.entryNum : -1;
        while (!(endOfChain = page.isRoot() || pageSource.isNoPage(page.nextPage)) && entry >= page.numEntries() - 1) {
            BtreePage newPage = pageSource.getPage(page.nextPage, btree);
            ++traversed;
            if (page.numEntries() == 0 && page != result.page) {
                pageSource.unpinPage(page);
            }
            page = newPage;
            entry = -1;
        }
        if (endOfChain && ++entry >= page.numEntries()) {
            if (key == null && page.isLeaf() && btree.hasBigKeys()) {
                BtreePage.getFirstBigKey(result, testOnly);
                return;
            }
            result.matched = false;
        } else {
            result.matched = key == null || page.compare(key, entry) == 0;
        }
        if (!testOnly) {
            result.entryNum = entry;
            result.page = page;
            result.skipCount += traversed;
        } else if (page != result.page) {
            pageSource.unpinPage(page);
        }
    }

    protected BtreeEntry split(BtreeEntry entry, int entryNum, SearchResult resultPosition) throws StorageException {
        byte[] rightKey;
        this.pageSource.dirtyPage(this);
        if (this.isRoot()) {
            this.splitRoot(entry, entryNum, resultPosition);
            return null;
        }
        BtreePage right = this.pageSource.newPage(this.btree);
        if (this.isLeaf()) {
            right.makeLeaf();
        } else {
            right.makeInternal();
        }
        if (!this.pageSource.isNoPage(this.nextPage)) {
            BtreePage oldRight = this.pageSource.getPage(this.nextPage, this.btree);
            this.pageSource.dirtyPage(oldRight);
            System.arraycopy(right.pageId, 0, oldRight.previousPage, 0, right.pageId.length);
            this.pageSource.unpinPage(oldRight);
        }
        System.arraycopy(this.pageId, 0, right.previousPage, 0, this.pageId.length);
        System.arraycopy(this.nextPage, 0, right.nextPage, 0, this.pageId.length);
        System.arraycopy(right.pageId, 0, this.nextPage, 0, right.pageId.length);
        if (this.pageSource.isNoPage(right.nextPage) && entryNum == this.numEntries()) {
            right.insert(entry, 0, resultPosition);
            rightKey = entry.key;
        } else {
            rightKey = this.splitEntries(this, right, entry, entryNum, resultPosition);
        }
        byte[] rightId = new byte[right.pageId.length];
        System.arraycopy(right.pageId, 0, rightId, 0, right.pageId.length);
        this.pageSource.unpinPage(right);
        return new BtreeEntry(rightKey, rightId);
    }

    private void splitRoot(BtreeEntry entry, int entryNum, SearchResult resultPosition) throws StorageException {
        this.pageSource.dirtyPage(this);
        BtreePage left = this.pageSource.newPage(this.btree);
        BtreePage right = this.pageSource.newPage(this.btree);
        System.arraycopy(right.pageId, 0, left.nextPage, 0, right.pageId.length);
        System.arraycopy(left.pageId, 0, right.previousPage, 0, left.pageId.length);
        if (this.isLeaf()) {
            left.makeLeaf();
            right.makeLeaf();
        } else {
            left.makeInternal();
            right.makeInternal();
        }
        byte[] rightKey = this.splitEntries(left, right, entry, entryNum, resultPosition);
        byte[] leftKey = new byte[rightKey.length];
        if (this.isLeaf()) {
            this.makeInternal();
        }
        this.insert(new BtreeEntry(leftKey, left.pageId), 0, null);
        this.insert(new BtreeEntry(rightKey, right.pageId), 1, null);
        this.pageSource.unpinPage(right);
        this.pageSource.unpinPage(left);
    }

    protected byte compare(byte[] key, int entryNum) {
        if (!this.isLeaf() && entryNum == 0 && this.pageSource.isNoPage(this.previousPage)) {
            return 1;
        }
        return this.btree.keyInfo.compare(key, this.pageBuffer, this.keyOffset(entryNum), this.keyLength(entryNum));
    }

    protected byte compareData(byte[] data, int entryNum) {
        return this.btree.dataInfo.compare(data, this.pageBuffer, this.keyOffset(entryNum) + this.keyLength(entryNum), data.length);
    }

    private void makeLeaf() {
        this.flags = (short)(this.flags | 1);
        this.dataLength = this.btree.dataLength;
    }

    private void makeInternal() {
        this.flags = (short)(this.flags & 0xFFFFFFFE);
        this.dataLength = this.btree.pageIdLength;
    }

    public void makeRoot() {
        this.flags = (short)(this.flags | 2);
    }

    boolean isLeaf() {
        return this.flags == (this.flags | 1);
    }

    boolean isRoot() {
        return this.flags == (this.flags | 2);
    }

    boolean isBigKey(byte[] key) {
        return key.length + this.btree.dataLength > (this.btree.pageSize - this.headerLength - 4) / 3;
    }

    void putBigKey(BtreeEntry entry, byte operation, int index, SearchResult resultPosition) throws StorageException {
        SearchResult location = this.searchBigKeys(entry.key);
        if (location.page == this) {
            BtreePage firstBig;
            if (operation == 1) {
                this.btree.failed = true;
                return;
            }
            location.page = firstBig = BigKeyPage.makeFirst(this, this.pageSource);
            location.entryNum = 0;
        }
        this.putHere(operation, location, entry, index, resultPosition);
    }

    SearchResult searchBigKeys(byte[] key) throws StorageException {
        if (!this.btree.hasBigKeys()) {
            return new SearchResult(false, 0, this);
        }
        BtreePage page = this.pageSource.getPage(this.nextPage, this.btree);
        SearchResult location = page.searchBigKeys(key);
        if (location.page != page) {
            this.pageSource.unpinPage(page);
        }
        return location;
    }

    static void getFirstBigKey(SearchResult result, boolean testOnly) throws StorageException {
        Btree btree = result.page.btree;
        BtreePageSource pageSource = btree.pageSource;
        BtreePage root = pageSource.getPage(btree.rootPageId, btree);
        if (pageSource.isNoPage(root.nextPage)) {
            result.matched = false;
        } else {
            result.matched = true;
            if (!testOnly) {
                result.page = pageSource.getPage(root.nextPage, btree);
            }
        }
        pageSource.unpinPage(root);
    }

    public void dumpPage(PrintWriter out) throws StorageException {
        this.dumpPageHeader(out);
        this.dumpPageEntries(out);
    }

    public void dumpPageHeader(PrintWriter out) {
        out.println("\n");
        out.println("Page ID: " + this.pageSource.getPageIdInfo().fromBuffer(this.pageId) + '\n');
        out.println("Next page: " + this.pageSource.getPageIdInfo().fromBuffer(this.nextPage) + '\n');
        out.println("Previous page: " + this.pageSource.getPageIdInfo().fromBuffer(this.previousPage) + '\n');
        out.println("Flags: " + this.flags + '\n');
        out.println("Free start: " + this.freeStart + '\n');
    }

    public void dumpPageEntries(PrintWriter out) throws StorageException {
        EntryTypeInfo pageIdInfo = this.pageSource.getPageIdInfo();
        out.println("\nPage entries:\n\n");
        for (int i = 0; i < this.numEntries(); ++i) {
            out.print(i + ": ");
            out.print(this.btree.keyInfo.fromBuffer(this.getKey(i)) + ", ");
            if (this.isLeaf()) {
                out.println(this.btree.dataInfo.fromBuffer(this.getData(i)));
                continue;
            }
            out.println(pageIdInfo.fromBuffer(this.getData(i)));
        }
    }

    public void dumpPageBuffer(PrintWriter out) {
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(this.pageBuffer));
        out.println("\nPage buffer contents:");
        try {
            int count = 0;
            while (true) {
                if (count % 8 == 0) {
                    out.println();
                }
                out.print(Integer.toHexString(in.readInt()));
                out.print(" ");
                ++count;
            }
        }
        catch (Exception exception) {
            out.println();
            return;
        }
    }

    public void dumpTree(PrintWriter out) throws StorageException {
        out.println("\n Dumping Btree:");
        BtreePage current = this;
        int level = 1;
        SearchResult leftEntry = new SearchResult(true, 0, this);
        while (!current.isLeaf()) {
            out.println("\n Level " + level);
            current.dumpLevel(out);
            ++level;
            BtreePage old = current;
            current = current.getChild(leftEntry);
            if (old == this) continue;
            this.pageSource.unpinPage(old);
        }
        out.println("\n Leaf Level " + level);
        current.dumpLevel(out);
        if (current != this) {
            this.pageSource.unpinPage(current);
        }
    }

    void dumpLevel(PrintWriter out) throws StorageException {
        byte[] next;
        BtreePage current = this;
        do {
            if (current instanceof BigKeyPage) {
                current.dumpLevel(out);
                return;
            }
            current.dumpPage(out);
            next = current.nextPage;
            if (current == this) continue;
            this.pageSource.unpinPage(current);
        } while (!this.pageSource.isNoPage(next) && (current = this.pageSource.getPage(next, this.btree)) != null);
    }

    public int consistencyCheck(PrintWriter out) throws StorageException {
        BtreePage leftPage = this;
        int level = 1;
        SearchResult leftEntry = new SearchResult(true, 0, this);
        SearchResult current = new SearchResult(true, 0, this);
        boolean done = false;
        int errors = 0;
        EntryTypeInfo pageIdInfo = this.pageSource.getPageIdInfo();
        out.println("\nBtree Consistency Check:\n");
        while (!done) {
            BtreePage old;
            current.entryNum = 0;
            current.page = leftPage;
            current.matched = true;
            BtreePage.getNext(null, current);
            while (current.matched) {
                byte[] previous = current.page.getKey(current.entryNum);
                if (current.page.isLeaf() && this.btree instanceof SinglevaluedBtree && ((SinglevaluedBtree)this.btree).getIfExists(this.btree.keyInfo.fromBuffer(previous)) == null) {
                    out.println("Record with key " + this.btree.keyInfo.fromBuffer(previous) + " exists at page " + pageIdInfo.fromBuffer(current.page.pageId) + " , entry " + current.entryNum + " but cannot be reached.");
                }
                old = current.page;
                BtreePage.getNext(null, current);
                if (current.page != old && old != leftPage) {
                    this.pageSource.unpinPage(old);
                }
                if (!current.matched || current.page instanceof BigKeyPage || current.page.compare(previous, current.entryNum) != 1) continue;
                ++errors;
                out.println("Key is less than previous key: page " + pageIdInfo.fromBuffer(current.page.pageId) + " , entry " + current.entryNum + " , level " + level);
            }
            if (current.page != this) {
                this.pageSource.unpinPage(current.page);
            }
            ++level;
            old = leftPage;
            done = leftPage.isLeaf();
            if (!done) {
                leftPage = leftPage.getChild(leftEntry);
            }
            if (old == this) continue;
            this.pageSource.unpinPage(old);
        }
        out.println("\nBtree Consistency Check Completed\n");
        out.flush();
        return errors;
    }

    private static class ParentEntry
    extends BtreeEntry {
        int skipCount;

        ParentEntry(BtreeEntry entry, int skipCount) {
            this.key = entry.key;
            this.data = entry.data;
            this.skipCount = skipCount;
        }
    }

    static class BtreeEntry {
        byte[] key;
        byte[] data;

        BtreeEntry(byte[] key, byte[] data) {
            this.key = key;
            this.data = data;
        }

        BtreeEntry() {
        }

        int length() {
            return this.key.length + this.data.length;
        }
    }
}

