/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreeindex;

import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.SinglevaluedIndex;
import org.netbeans.mdr.persistence.Storage;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.EntryTypeInfo;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.BtreeStorage;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.Converter;
import org.netbeans.mdr.util.Logger;

public class MOFIDInfo
extends EntryTypeInfo {
    private BtreeStorage storage;

    MOFIDInfo(Storage storage) {
        this.storage = (BtreeStorage)storage;
    }

    public String typeName() {
        return new String("MOFID");
    }

    public byte compare(byte[] key, byte[] buffer, int offset, int targetLength) {
        for (int i = 0; i < 8; ++i) {
            if (key[i] < buffer[offset + i]) {
                return -1;
            }
            if (key[i] <= buffer[offset + i]) continue;
            return 1;
        }
        return 0;
    }

    public int getLength() {
        return 8;
    }

    public boolean isFixedLength() {
        return true;
    }

    public byte[] toBuffer(Object object) {
        try {
            MOFID m = (MOFID)object;
            if (m != null) {
                byte[] mofBytes = new byte[8];
                Converter.writeLong(mofBytes, 0, m.getSerialNumber());
                String storageId = m.getStorageID();
                int s = this.storage.getStorageId().equals(storageId) ? 0 : ("00000000-0000-0000-0000-000000000000".equals(storageId) ? 1 : this.storage.storageIdToNumber(storageId));
                Converter.writeShort(mofBytes, 0, (short)s);
                return mofBytes;
            }
        }
        catch (Exception e) {
            Logger.getDefault().notify(1, (Throwable)e);
        }
        return null;
    }

    public Object fromBuffer(byte[] buffer) {
        try {
            short storageNumber = Converter.readShort(buffer, 0);
            String storageId = null;
            switch (storageNumber) {
                case 1: {
                    storageId = "00000000-0000-0000-0000-000000000000";
                    break;
                }
                case 0: {
                    storageId = this.storage.getStorageId();
                    break;
                }
                default: {
                    storageId = this.storage.numberToStorageId(storageNumber);
                }
            }
            buffer[0] = 0;
            buffer[1] = 0;
            long serialNumber = Converter.readLong(buffer, 0);
            return new MOFID(serialNumber, storageId);
        }
        catch (Exception e) {
            Logger.getDefault().notify(1, (Throwable)e);
            return null;
        }
    }

    public Object objectFromBuffer(byte[] buffer, SinglevaluedIndex repos) {
        try {
            return this.storage.resolveObject((MOFID)this.fromBuffer(buffer));
        }
        catch (Exception e) {
            Logger.getDefault().notify(1, (Throwable)e);
            return null;
        }
    }
}

