/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreestorage;

import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.FileCache;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.IntrusiveList;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.PageID;

public class CachedPage
extends IntrusiveList.Member {
    PageID key = null;
    int pinCount = 0;
    boolean isDirty = false;
    boolean heldForLog = false;
    public byte[] contents;
    private FileCache owner;

    CachedPage(int size, FileCache cache) {
        this.owner = cache;
        this.contents = new byte[size];
    }

    public synchronized void setWritable() throws StorageException {
        this.owner.setWritable(this);
    }

    void reInit(PageID id) {
        this.key = id;
        this.pinCount = 0;
        this.isDirty = false;
        this.heldForLog = false;
    }

    public void unpin() throws StorageException {
        this.owner.unpin(this);
    }

    public String toString() {
        StringBuffer debug = new StringBuffer("" + this.key);
        if (this.pinCount > 0) {
            debug.append(" pin count: " + this.pinCount);
        }
        if (this.isDirty) {
            debug.append(" dirty");
        }
        if (this.heldForLog) {
            debug.append(" held");
        }
        debug.append("\n");
        int j = 0;
        int i = 0;
        while (i < this.contents.length) {
            if (j >= 16) {
                debug.append("\n");
                j = 0;
            }
            int data = this.contents[i] & 0xFF;
            debug.append(Integer.toHexString(data));
            debug.append(" ");
            ++i;
            ++j;
        }
        debug.append("\n");
        return new String(debug);
    }
}

