/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreestorage;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.mdr.persistence.StorageBadRequestException;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.StorageIOException;
import org.netbeans.mdr.persistence.Streamable;
import org.netbeans.mdr.util.AbstractCollectionFactory;

abstract class NameIndex
implements Streamable {
    protected Map hashOnName = AbstractCollectionFactory.getCollectionFactory().createHashMap();
    String name = "";

    public void setName(String nm) {
        this.name = nm;
    }

    public String toString() {
        return this.name;
    }

    protected synchronized Object getObj(String name) throws StorageException {
        Object id = this.getObjIf(name);
        if (id == null) {
            throw new StorageBadRequestException(MessageFormat.format("There is no value for key \"{0}\"", name));
        }
        return id;
    }

    protected synchronized Object getObjIf(String name) throws StorageException {
        return this.hashOnName.get(name);
    }

    protected synchronized void addObj(String name, Object id) throws StorageException {
        if (this.hashOnName.get(name) != null) {
            throw new StorageBadRequestException(MessageFormat.format("There is already a value for key \"{0}\"", name));
        }
        this.hashOnName.put(name, id);
    }

    public synchronized void remove(String name) throws StorageException {
        if (this.hashOnName.get(name) == null) {
            throw new StorageBadRequestException(MessageFormat.format("There is no value for key \"{0}\"", name));
        }
        this.hashOnName.remove(name);
    }

    public synchronized void clear() {
        this.hashOnName.clear();
    }

    public synchronized String[] listNames() {
        List list = AbstractCollectionFactory.getCollectionFactory().createArrayList();
        list.addAll(this.hashOnName.keySet());
        return list.toArray(new String[0]);
    }

    public synchronized Iterator iterator() {
        return this.hashOnName.entrySet().iterator();
    }

    public synchronized void write(OutputStream strm) throws StorageException {
        if (strm instanceof DataOutputStream) {
            this.write((DataOutputStream)strm);
        } else {
            this.write(new DataOutputStream(strm));
        }
    }

    public synchronized void write(DataOutputStream dstrm) throws StorageException {
        try {
            Set entries = this.hashOnName.entrySet();
            dstrm.writeInt(entries.size());
            Iterator itr = entries.iterator();
            while (itr.hasNext()) {
                Map.Entry entry = itr.next();
                dstrm.writeUTF((String)entry.getKey());
                this.writeObjectToStream(entry.getValue(), dstrm);
            }
            dstrm.flush();
        }
        catch (IOException ex) {
            throw new StorageIOException(ex);
        }
    }

    public synchronized void read(InputStream strm) throws StorageException {
        if (strm instanceof DataInputStream) {
            this.read((DataInputStream)strm);
        } else {
            this.read(new DataInputStream(strm));
        }
    }

    public synchronized void read(DataInputStream dstrm) throws StorageException {
        try {
            this.clear();
            int size = dstrm.readInt();
            for (int i = 0; i < size; ++i) {
                String key = dstrm.readUTF();
                Object id = this.readObjectFromStream(dstrm);
                this.addObj(key, id);
            }
        }
        catch (IOException ex) {
            throw new StorageIOException(ex);
        }
    }

    protected abstract void writeObjectToStream(Object var1, DataOutputStream var2) throws StorageException;

    protected abstract Object readObjectFromStream(DataInputStream var1) throws StorageException;
}

