/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.memoryimpl;

import java.util.AbstractList;
import java.util.List;
import org.netbeans.mdr.persistence.MultivaluedIndex;
import org.netbeans.mdr.persistence.RuntimeStorageException;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.memoryimpl.MultivalueLog;
import org.netbeans.mdr.persistence.memoryimpl.MultivaluedIndexImpl;

public class MIWrapper
extends AbstractList {
    private List inner;
    private final Object key;
    private MultivalueLog transLog;
    private MultivaluedIndex _multivaluedIndex;

    public MIWrapper(MultivaluedIndex multivaluedIndex, List inner, Object key, MultivalueLog transLog) {
        this._multivaluedIndex = multivaluedIndex;
        this.inner = inner;
        this.key = key;
        this.transLog = transLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(int param) {
        MultivaluedIndex multivaluedIndex = this._multivaluedIndex;
        synchronized (multivaluedIndex) {
            return this.inner != null ? this.inner.get(param) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        MultivaluedIndex multivaluedIndex = this._multivaluedIndex;
        synchronized (multivaluedIndex) {
            return this.inner != null ? this.inner.size() : 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object set(int index, Object element) {
        MultivaluedIndex multivaluedIndex = this._multivaluedIndex;
        synchronized (multivaluedIndex) {
            try {
                if (this._multivaluedIndex.isUnique() && !MultivaluedIndexImpl.isUniqueValue(this.inner, element, index)) {
                    throw new RuntimeStorageException(MultivaluedIndexImpl.createValueAlreadyContainedExc(this.key, element));
                }
            }
            catch (StorageException e) {
                System.err.println(e);
            }
            Object orig = this.inner.set(index, element);
            if (orig != null) {
                this.transLog.logReplace(this.key, orig, index);
            }
            return orig;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int index, Object element) {
        MultivaluedIndex multivaluedIndex = this._multivaluedIndex;
        synchronized (multivaluedIndex) {
            try {
                if (this.inner == null) {
                    this.inner = (List)this._multivaluedIndex.addNewRecord(this.key);
                }
                if (this._multivaluedIndex.isUnique() && this.inner.contains(element)) {
                    throw new RuntimeStorageException(MultivaluedIndexImpl.createValueAlreadyContainedExc(this.key, element));
                }
            }
            catch (StorageException e) {
                System.err.println(e);
            }
            this.inner.add(index, element);
            this.transLog.logAdd(this.key, element, index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(int index) {
        MultivaluedIndex multivaluedIndex = this._multivaluedIndex;
        synchronized (multivaluedIndex) {
            Object orig = this.inner.remove(index);
            if (orig != null) {
                this.transLog.logRemove(this.key, orig, index);
                return orig;
            }
            return null;
        }
    }
}

