/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.memoryimpl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.mdr.persistence.MultivaluedIndex;
import org.netbeans.mdr.persistence.SinglevaluedIndex;
import org.netbeans.mdr.persistence.Storage;
import org.netbeans.mdr.persistence.StorageBadRequestException;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.StorageIOException;
import org.netbeans.mdr.persistence.Streamable;
import org.netbeans.mdr.persistence.memoryimpl.IndexStorageCreator;
import org.netbeans.mdr.persistence.memoryimpl.MIWrapper;
import org.netbeans.mdr.persistence.memoryimpl.MOWrapper;
import org.netbeans.mdr.persistence.memoryimpl.MultivalueLog;
import org.netbeans.mdr.persistence.memoryimpl.Transactionable;
import org.netbeans.mdr.persistence.memoryimpl.Utils;
import org.netbeans.mdr.util.AbstractCollectionFactory;
import org.netbeans.mdr.util.IOUtils;
import org.netbeans.mdr.util.MapEntryImpl;

public abstract class MultivaluedIndexImpl
implements MultivaluedIndex,
Streamable,
Transactionable {
    protected String name;
    protected Storage.EntryType keyType;
    protected Storage.EntryType valueType;
    protected boolean unique;
    protected Map entries;
    protected Storage storage;
    protected MultivalueLog transLog = new MultivalueLog();

    public MultivaluedIndexImpl(String name, Storage storage, Storage.EntryType keyType, Storage.EntryType valueType, boolean unique, IndexStorageCreator indexStorageCreator) {
        this.name = name;
        this.keyType = keyType;
        this.valueType = valueType;
        this.unique = unique;
        this.storage = storage;
        this.entries = indexStorageCreator.createIndexStorage(keyType);
    }

    public MultivaluedIndexImpl() {
    }

    public String getName() throws StorageException {
        return this.name;
    }

    public Storage.EntryType getValueType() throws StorageException {
        return this.valueType;
    }

    public Storage.EntryType getKeyType() throws StorageException {
        return this.keyType;
    }

    public synchronized boolean remove(Object key) throws StorageException {
        Object value = this.entries.remove(key);
        if (value != null) {
            this.transLog.logRemoveKey(key, value);
            return true;
        }
        return false;
    }

    public void dispose() {
    }

    public synchronized Set keySet() throws StorageException {
        return this.entries.keySet();
    }

    public synchronized void add(Object key, Object value) throws StorageException {
        Collection vals = (Collection)this.entries.get(key);
        if (vals == null) {
            vals = AbstractCollectionFactory.getCollectionFactory().createArrayList();
            this.entries.put(key, vals);
        } else if (this.unique && vals.contains(value)) {
            throw MultivaluedIndexImpl.createValueAlreadyContainedExc(key, value);
        }
        vals.add(value);
        this.transLog.logAdd(key, value);
    }

    public boolean isUnique() throws StorageException {
        return this.unique;
    }

    public synchronized Collection getItems(Object key) throws StorageException {
        Collection vals = (Collection)this.entries.get(key);
        if (vals == null) {
            vals = AbstractCollectionFactory.getCollectionFactory().createArrayList();
            this.entries.put(key, vals);
        }
        return new MIWrapper(this, (List)vals, key, this.transLog);
    }

    public synchronized Collection getObjects(Object key, SinglevaluedIndex s) throws StorageException {
        if (this.keyType == Storage.EntryType.MOFID) {
            return new MOWrapper(this, (List)this.getItems(key), s, key);
        }
        return this.getItems(key);
    }

    public synchronized boolean remove(Object key, Object value) throws StorageException {
        Collection vals = (Collection)this.entries.get(key);
        if (vals != null && vals.remove(value)) {
            this.transLog.logRemove(key, value);
            return true;
        }
        return false;
    }

    public void write(OutputStream out) throws StorageException {
        try {
            IOUtils.writeString(out, this.name);
            out.write(this.keyType.encode());
            out.write(this.valueType.encode());
            Utils.write(out, this.entries, this.storage);
        }
        catch (IOException e) {
            throw new StorageIOException(e);
        }
    }

    public void read(InputStream is) throws StorageException {
        try {
            this.name = IOUtils.readString(is);
            this.keyType = Storage.EntryType.decodeEntryType((byte)is.read());
            this.valueType = Storage.EntryType.decodeEntryType((byte)is.read());
            this.entries = (Map)Utils.read(is, this.storage);
        }
        catch (IOException e) {
            throw new StorageIOException(e);
        }
    }

    public synchronized Collection queryByKeyPrefix(Object prefix, SinglevaluedIndex primaryIndex) throws StorageException {
        if (this.keyType != Storage.EntryType.STRING) {
            throw new UnsupportedOperationException("Key type must be EntryType.STRING");
        }
        if (!(prefix instanceof String)) {
            throw new StorageBadRequestException("String object parameter expected.");
        }
        LinkedList<MapEntryImpl> result = new LinkedList<MapEntryImpl>();
        Iterator iter = this.entries.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!key.startsWith((String)prefix)) continue;
            result.add(new MapEntryImpl(key, this.getObjects(key, primaryIndex)));
        }
        return result;
    }

    protected static boolean isUniqueValue(List list, Object value, int index) {
        Iterator iter = list.iterator();
        int x = 0;
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (x != index && value.equals(obj)) {
                return false;
            }
            ++x;
        }
        return true;
    }

    public static StorageBadRequestException createValueAlreadyContainedExc(Object key, Object value) {
        return new StorageBadRequestException("Unique index already contains value " + value + " for key " + key);
    }

    public void changed(Object key) {
    }

    public void setKey(Object key, Object vals) {
        this.entries.put(key, vals);
    }

    public Collection addNewRecord(Object key) {
        return null;
    }

    public final synchronized void rollBackChanges() throws StorageException {
        this.transLog.rollBack(this);
        this.transLog.clear();
    }

    public final synchronized void commitChanges() throws StorageException {
        this.transLog.clear();
    }
}

