/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.storagemodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jmi.reflect.ClosureViolationException;
import javax.jmi.reflect.CompositionCycleException;
import javax.jmi.reflect.CompositionViolationException;
import javax.jmi.reflect.JmiException;
import javax.jmi.reflect.RefFeatured;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.WrongSizeException;
import org.netbeans.mdr.handlers.AssociationHandler;
import org.netbeans.mdr.handlers.BaseObjectHandler;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.MultivaluedIndex;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.Streamable;
import org.netbeans.mdr.storagemodel.MdrStorage;
import org.netbeans.mdr.storagemodel.StorableAssociation;
import org.netbeans.mdr.storagemodel.StorableBaseObject;
import org.netbeans.mdr.storagemodel.StorableClass;
import org.netbeans.mdr.storagemodel.StorableFeatured;
import org.netbeans.mdr.util.AbstractCollectionFactory;
import org.netbeans.mdr.util.DebugException;
import org.netbeans.mdr.util.IOUtils;
import org.netbeans.mdr.util.Logger;

public class StorableObject
extends StorableFeatured
implements Streamable {
    protected Object[] values;
    static final String INDEX_KEY_DELIMITER = "@";
    static final String INDEX_KEY_DELIMITER_2 = "#";
    static final String NULL_VALUE_SUBSTITUTE = "NULL";
    private MOFID classProxyId;
    private transient StorableClass classProxy = null;
    private MOFID attribComposite = null;
    static /* synthetic */ Class class$javax$jmi$reflect$RefObject;

    protected void replaceValues(Map table) {
        this.objectWillChange();
        super.replaceValues(table);
        this.objectChanged();
    }

    public StorableObject(MdrStorage mdrStorage, MOFID immediatePackage, MOFID meta, MOFID classProxy) throws StorageException {
        this(mdrStorage, immediatePackage, meta, classProxy, null, null);
    }

    public StorableObject(MdrStorage mdrStorage, MOFID immediatePackage, MOFID meta, MOFID classProxy, Object[] params) throws StorageException {
        this(mdrStorage, immediatePackage, meta, classProxy, params, null);
    }

    public StorableObject(MdrStorage mdrStorage, MOFID immediatePackage, MOFID meta, MOFID classProxy, Object[] params, String storageId) throws StorageException {
        super(mdrStorage, immediatePackage, meta, storageId);
        this.classProxyId = classProxy;
        this.classProxy = (StorableClass)mdrStorage.getObject(this.classProxyId);
        if (params != null) {
            this.check();
            for (int i = 0; i < params.length; ++i) {
                StorableClass.AttributeDescriptor desc = this.getClassProxy().getAttrDesc(i);
                this.values[i] = this.getInitialValue(desc, params[i]);
            }
        }
        this.addInstance();
        if (params != null) {
            this.modifyIndex(this.getClassProxy().getIndexDescriptors(), false);
        }
        this.initFinished = true;
    }

    public StorableObject(StorableObject storable) throws StorageException {
        super(storable.getMdrStorage(), storable.getImmediatePackageId(), storable.getMetaObjectId(), null);
        this.classProxyId = storable.getClassProxyId();
        this.classProxy = storable.getClassProxy();
        this.copyValues(storable);
        this.addInstance();
        this.modifyIndex(this.getClassProxy().getIndexDescriptors(), false);
        StorableFeatured composite = storable.getImmediateComposite();
        if (composite != null) {
            this.attribComposite = composite.getMofId();
        }
        this.initFinished = true;
    }

    public StorableObject() {
    }

    protected void copyValues(StorableObject storable) {
        this.values = storable.values;
    }

    public void setAttribute(String featureName, Object value) throws StorageException {
        this.setAttribute(this.getClassProxy().getAttrIndex(featureName), value);
    }

    public void setAttribute(int attrIndex, Object value) throws StorageException {
        this.check();
        StorableClass.AttributeDescriptor attribute = this.getClassProxy().getAttrDesc(attrIndex);
        Object oldValue = this.values[attrIndex];
        this.objectWillChange();
        this.values[attrIndex] = value;
        if (!attribute.isMultivalued() && value instanceof RefObject) {
            StorableObject storableObj = (StorableObject)((BaseObjectHandler)value)._getDelegate();
            storableObj.setComposite(this.getMofId(), storableObj.getMofId(), attribute.getMofId());
            if (oldValue != null) {
                storableObj = (StorableObject)((BaseObjectHandler)oldValue)._getDelegate();
                storableObj.clearComposite();
            }
        }
        this.modifyIndex(attrIndex, oldValue, value);
        this.objectChanged();
    }

    public Object getAttribute(String featureName) throws StorageException {
        return this.getAttribute(this.getClassProxy().getAttrIndex(featureName));
    }

    public Object getAttribute(int attrIndex) throws StorageException {
        this.check();
        return this.values[attrIndex];
    }

    public void verify(Collection violations) throws StorageException {
        Object desc;
        int count = this.getClassProxy().getAttrCount();
        for (int i = 0; i < count; ++i) {
            desc = this.getClassProxy().getAttrDesc(i);
            Object result = this.getAttribute(i);
            if ((((StorableClass.AttributeDescriptor)desc).getMaxSize() != 1 || ((StorableClass.AttributeDescriptor)desc).getMinSize() != 1 || result != null) && (((StorableClass.AttributeDescriptor)desc).getMaxSize() == 1 || ((Collection)result).size() >= ((StorableClass.AttributeDescriptor)desc).getMinSize())) continue;
            violations.add(new WrongSizeException((RefObject)this.getMdrStorage().getRepository().getHandler(this.getMdrStorage().getObject(((StorableClass.AttributeDescriptor)desc).getMofId()))));
        }
        Iterator it = this.getClassProxy().getAllReferenceDescriptors().iterator();
        while (it.hasNext()) {
            desc = (StorableClass.ReferenceDescriptor)it.next();
            ((StorableClass.ReferenceDescriptor)desc).getAssociation().verifyEnd(violations, ((StorableClass.ReferenceDescriptor)desc).getEndName(), this.getMofId());
        }
    }

    void addReference(String referenceName, MOFID referencedObjectId) throws StorageException {
        MOFID objA;
        MOFID objB;
        StorableClass.ReferenceDescriptor reference = this.getClassProxy().getReferenceDescriptor(referenceName);
        StorableAssociation assocObj = (StorableAssociation)this.getMdrStorage().getObject(reference.getAssociationId());
        if (reference.getEndName().equals(assocObj.getEnd1Name())) {
            objB = referencedObjectId;
            objA = this.getMofId();
        } else {
            objA = referencedObjectId;
            objB = this.getMofId();
        }
        assocObj.addLink(objA, objB);
    }

    public Object getReference(String referenceName) throws StorageException {
        StorableClass.ReferenceDescriptor reference = this.getClassProxy().getReferenceDescriptor(referenceName);
        StorableAssociation asocObj1 = (StorableAssociation)this.getMdrStorage().getObject(reference.getAssociationId());
        return asocObj1.queryObjects(reference.getEndName(), this.getMofId());
    }

    protected void check() throws StorageException {
        if (this.values == null) {
            this.values = new Object[this.getClassProxy().getAttrCount()];
        }
    }

    public StorableFeatured getImmediateComposite() throws StorageException {
        Object composite = null;
        if (this.attribComposite != null) {
            StorableFeatured sf = (StorableFeatured)this.getMdrStorage().getObject(this.attribComposite);
            return sf;
        }
        return null;
    }

    public StorableFeatured getOutermostComposite() throws StorageException {
        StorableFeatured result = this.getImmediateComposite();
        StorableFeatured composite = this;
        while (result != null) {
            composite = result;
            if (result instanceof StorableObject) {
                result = ((StorableObject)result).getImmediateComposite();
                continue;
            }
            result = null;
        }
        return composite;
    }

    public void clearComposite() throws StorageException {
        this.setComposite((MOFID)null, null, null);
    }

    public void setComposite(MOFID composite, MOFID objectId, MOFID elementId) throws StorageException {
        this.setComposite(this.getMdrStorage().getObject(composite), objectId, elementId);
    }

    public void setComposite(StorableBaseObject composite, MOFID objectId, MOFID elementId) throws StorageException {
        this.objectWillChange();
        if (composite == null) {
            this.attribComposite = null;
        } else {
            MOFID id = composite.getMofId();
            if (!id.equals(this.attribComposite)) {
                if (this.attribComposite != null && this.attribComposite.getObject() != null) {
                    throw new CompositionViolationException((Object)this.getMdrStorage().getRepository().getHandler(this), (RefObject)this.getMdrStorage().getRepository().getHandler(this.getMdrStorage().getObject(elementId)));
                }
                if (composite instanceof StorableObject && ((StorableObject)composite).getOutermostComposite().equals(this)) {
                    throw new CompositionCycleException((Object)this.getMdrStorage().getRepository().getHandler(this.getMdrStorage().getObject(objectId)), (RefObject)this.getMdrStorage().getRepository().getHandler(this.getMdrStorage().getObject(elementId)));
                }
                if (!composite.getOutermostPackageId().equals(this.getOutermostPackageId())) {
                    throw new ClosureViolationException((Object)this.getMdrStorage().getRepository().getHandler(this.getMdrStorage().getObject(objectId)), (RefObject)this.getMdrStorage().getRepository().getHandler(this.getMdrStorage().getObject(elementId)));
                }
                this.attribComposite = id;
            }
        }
        this.objectChanged();
    }

    public void deleteInstance() throws StorageException {
        this.modifyIndex(this.getClassProxy().getIndexDescriptors(), true);
        this.getMdrStorage().removeInstance(this);
    }

    public void delete() throws StorageException {
        this.deleteAttributes();
        this.deleteLinksAndComponents();
        this.deleteFromComposite();
        this.deleteInstance();
    }

    protected void deleteFromComposite() throws StorageException {
        StorableFeatured composite = this.getImmediateComposite();
        if (composite != null) {
            StorableClass cls = composite.getClassProxy();
            for (int i = 0; i < cls.getAttrCount(); ++i) {
                StorableClass.AttributeDescriptor desc;
                if (!(class$javax$jmi$reflect$RefObject == null ? StorableObject.class$("javax.jmi.reflect.RefObject") : class$javax$jmi$reflect$RefObject).isAssignableFrom((desc = cls.getAttrDesc(i)).getType())) continue;
                RefFeatured obj = (RefFeatured)this.getMdrStorage().getRepository().getHandler(composite);
                Object value = obj.refGetValue(desc.getName());
                if (this.equals(value)) {
                    obj.refSetValue(desc.getName(), null);
                    continue;
                }
                if (!(value instanceof Collection) || !((Collection)value).contains(this)) continue;
                ((Collection)value).remove(this);
            }
        }
    }

    protected void deleteLinksAndComponents() throws StorageException {
        RefObject thisObject = (RefObject)this.getMdrStorage().getRepository().getHandler(this);
        List associationEnds = AbstractCollectionFactory.getCollectionFactory().createArrayList();
        this.getClassProxy().collectAssociationEnds(associationEnds, AbstractCollectionFactory.getCollectionFactory().createHashSet());
        Iterator it = associationEnds.iterator();
        while (it.hasNext()) {
            Object temp;
            StorableClass.AssocEndDescriptor item = (StorableClass.AssocEndDescriptor)it.next();
            StorableAssociation assocStorable = (StorableAssociation)this.getMdrStorage().getObject(item.mofId);
            if (assocStorable == null) continue;
            AssociationHandler assoc = (AssociationHandler)this.getMdrStorage().getRepository().getHandler(assocStorable);
            try {
                temp = assoc._query(item.endName, thisObject);
            }
            catch (ClassCastException e) {
                temp = null;
            }
            catch (JmiException e) {
                temp = assoc._handleQuery(item.endName, thisObject);
            }
            if (temp == null) continue;
            if (temp instanceof Collection) {
                Iterator itt = ((Collection)temp).iterator();
                while (itt.hasNext()) {
                    RefObject obj = (RefObject)itt.next();
                    itt.remove();
                    if (!item.isAggregate) continue;
                    obj.refDelete();
                }
                continue;
            }
            if (item.endName.equals(assocStorable.getEnd2Name())) {
                assoc.refRemoveLink((RefObject)temp, thisObject);
                continue;
            }
            assoc.refRemoveLink(thisObject, (RefObject)temp);
            if (!item.isAggregate) continue;
            ((RefObject)temp).refDelete();
        }
    }

    public MOFID getClassProxyId() {
        return this.classProxyId;
    }

    public StorableClass getClassProxy() throws StorageException {
        return this.classProxy;
    }

    public void write(OutputStream outputStream) {
        super.write(outputStream);
        try {
            IOUtils.write(outputStream, this.classProxyId, this);
            IOUtils.write(outputStream, this.attribComposite, this);
            if (this.values == null) {
                IOUtils.writeInt(outputStream, 0);
            } else {
                IOUtils.writeInt(outputStream, this.values.length + 1);
                for (int i = 0; i < this.values.length; ++i) {
                    IOUtils.write(outputStream, this.values[i], this);
                }
            }
        }
        catch (IOException e) {
            Logger.getDefault().notify(1, (Throwable)e);
        }
    }

    public void read(InputStream inputStream) {
        super.read(inputStream);
        try {
            this.classProxyId = (MOFID)IOUtils.read(inputStream, this);
            this.attribComposite = (MOFID)IOUtils.read(inputStream, this);
        }
        catch (IOException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(e), (Throwable)e);
        }
        try {
            this.classProxy = (StorableClass)this.getMdrStorage().getObject(this.classProxyId);
            this.meta = this.classProxy.getMetaObjectId();
            this.immediatePackage = this.classProxy.getImmediatePackageId();
        }
        catch (StorageException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(e), (Throwable)e);
        }
        try {
            int objCount = IOUtils.readInt(inputStream);
            if (objCount != 0) {
                int count = objCount - 1;
                this.values = new Object[count];
                for (int i = 0; i < count; ++i) {
                    StorableClass classProxy = this.getClassProxy();
                    StorableClass.AttributeDescriptor attrDesc = classProxy.getAttrDesc(i);
                    Class type = attrDesc.getType();
                    String name = type.getName();
                    this.values[i] = IOUtils.read(inputStream, this, name);
                }
            }
        }
        catch (Exception e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(e), (Throwable)e);
        }
    }

    protected void addInstance() throws StorageException {
        this.getMdrStorage().addInstance(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void modifyIndex(int attrIdx, Object oldValue, Object newValue) throws StorageException {
        List indexes;
        MultivaluedIndex attrIndex = null;
        StorableClass proxy = this.getClassProxy();
        StorableClass.AttributeDescriptor attrDesc = proxy.getAttrDesc(attrIdx);
        MOFID attribId = attrDesc.getMofId();
        if (attrDesc.isIndexed() && (indexes = proxy.getIndexes(attribId)) != null) {
            Iterator iter = indexes.iterator();
            MOFID outermostPackageId = this.getOutermostPackageId();
            MOFID mofId = this.getMofId();
            while (iter.hasNext()) {
                StorableClass.IndexDescriptor indexDesc = (StorableClass.IndexDescriptor)iter.next();
                try {
                    attrIndex = this.getMdrStorage().acquireAdditionalIndex(outermostPackageId, indexDesc.getName());
                    if (attrIndex == null) {
                        return;
                    }
                    if (oldValue == null && newValue == null) {
                        return;
                    }
                    if (oldValue != null && oldValue.equals(newValue)) {
                        return;
                    }
                    StorableClass.IndexDescriptor.Field[] fields = indexDesc.getFields();
                    int currPosition = -1;
                    for (int x = 0; x < fields.length; ++x) {
                        if (!(fields[x] instanceof StorableClass.IndexDescriptor.Attrib) || !((StorableClass.IndexDescriptor.Attrib)fields[x]).getId().equals(attribId)) continue;
                        currPosition = x;
                        break;
                    }
                    String oldValStr = StorableObject.objectToString(oldValue, fields[currPosition].isOrdered());
                    String newValStr = StorableObject.objectToString(newValue, fields[currPosition].isOrdered());
                    String prefix = this.valuesToKey(fields, 0, currPosition - 1);
                    String suffix = this.valuesToKey(fields, currPosition + 1, fields.length - 1);
                    StringBuffer buf = new StringBuffer();
                    if (prefix.length() > 0) {
                        buf.append(prefix);
                        buf.append(INDEX_KEY_DELIMITER);
                    }
                    buf.append(oldValStr);
                    if (suffix.length() > 0) {
                        buf.append(INDEX_KEY_DELIMITER);
                        buf.append(suffix);
                    }
                    attrIndex.remove(buf.toString(), mofId);
                    buf = new StringBuffer();
                    if (prefix.length() > 0) {
                        buf.append(prefix);
                        buf.append(INDEX_KEY_DELIMITER);
                    }
                    buf.append(newValStr);
                    if (suffix.length() > 0) {
                        buf.append(INDEX_KEY_DELIMITER);
                        buf.append(suffix);
                    }
                    attrIndex.add(buf.toString(), mofId);
                }
                finally {
                    if (attrIndex != null) {
                        this.getMdrStorage().releaseAdditionalIndex();
                    }
                }
            }
        }
    }

    protected void deleteAttributes() throws StorageException {
        for (int i = 0; i < this.values.length; ++i) {
            Object obj;
            if (this.values[i] instanceof RefObject) {
                RefObject obj2 = (RefObject)this.values[i];
                this.setAttribute(i, null);
                obj2.refDelete();
                continue;
            }
            if (!(this.values[i] instanceof Collection)) continue;
            Iterator it = ((Collection)this.values[i]).iterator();
            while (it.hasNext() && (obj = it.next()) instanceof RefObject) {
                it.remove();
                ((RefObject)obj).refDelete();
            }
        }
    }

    void addToIndex(MOFID id) {
        try {
            StorableClass proxy = this.getClassProxy();
            this.modifyIndex(proxy.getIndexes(id), false);
        }
        catch (StorageException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(e), (Throwable)e);
        }
    }

    void removeFromIndex(MOFID id) {
        try {
            StorableClass proxy = this.getClassProxy();
            this.modifyIndex(proxy.getIndexes(id), true);
        }
        catch (StorageException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(e), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modifyIndex(List descriptors, boolean remove) throws StorageException {
        if (descriptors == null) {
            return;
        }
        MultivaluedIndex attrIndex = null;
        MOFID outermostPackageId = this.getOutermostPackageId();
        MOFID mofId = this.getMofId();
        Iterator iter = descriptors.iterator();
        while (iter.hasNext()) {
            StorableClass.IndexDescriptor desc = (StorableClass.IndexDescriptor)iter.next();
            StorableClass.IndexDescriptor.Field[] fields = desc.getFields();
            try {
                attrIndex = this.getMdrStorage().acquireAdditionalIndex(outermostPackageId, desc.getName());
                if (remove) {
                    attrIndex.remove(this.valuesToKey(fields, 0, fields.length - 1), mofId);
                    continue;
                }
                attrIndex.add(this.valuesToKey(fields, 0, fields.length - 1), mofId);
            }
            finally {
                if (attrIndex == null) continue;
                this.getMdrStorage().releaseAdditionalIndex();
            }
        }
    }

    private static String objectToString(Object o, boolean isOrdered) {
        if (o == null) {
            return NULL_VALUE_SUBSTITUTE;
        }
        if (o instanceof RefObject) {
            return ((RefObject)o).refMofId();
        }
        if (o instanceof StorableObject) {
            return ((StorableObject)o).getMofId().toString();
        }
        if (o instanceof Collection) {
            StringBuffer buf = new StringBuffer();
            Iterator iter = ((Collection)o).iterator();
            LinkedList<String> list = new LinkedList<String>();
            while (iter.hasNext()) {
                list.add(StorableObject.objectToString(iter.next(), true));
            }
            if (!isOrdered) {
                Collections.sort(list);
            }
            if ((iter = list.iterator()).hasNext()) {
                buf.append(iter.next());
            }
            while (iter.hasNext()) {
                buf.append(INDEX_KEY_DELIMITER);
                buf.append(iter.next());
            }
            return buf.toString();
        }
        return o.toString();
    }

    private String valuesToKey(StorableClass.IndexDescriptor.Field[] fields, int pos_1, int pos_2) throws StorageException {
        StringBuffer buf = new StringBuffer();
        for (int x = pos_1; x <= pos_2; ++x) {
            String res;
            if (fields[x] instanceof StorableClass.IndexDescriptor.Attrib) {
                String name = ((StorableClass.IndexDescriptor.Attrib)fields[x]).getName();
                res = StorableObject.objectToString(this.values[this.getClassProxy().getAttrIndex(name)], fields[x].isOrdered());
            } else {
                StorableClass.IndexDescriptor.AssocEnd endDesc = (StorableClass.IndexDescriptor.AssocEnd)fields[x];
                StorableAssociation sa = (StorableAssociation)this.getMdrStorage().getObject(endDesc.getAssociation());
                String otherEndName = sa.getEnd1Name();
                if (otherEndName.equals(endDesc.getName())) {
                    otherEndName = sa.getEnd2Name();
                }
                res = StorableObject.objectToString(sa.queryObjects(otherEndName, this.getMofId()), fields[x].isOrdered());
            }
            buf.append(res);
            if (x >= pos_2) continue;
            buf.append(INDEX_KEY_DELIMITER_2);
        }
        return buf.toString();
    }

    public static String valuesToKey(Map map, StorableClass.IndexDescriptor.Field[] fields) {
        StringBuffer buf = new StringBuffer();
        if (map.size() != fields.length) {
            throw new DebugException("Wrong query on additional index, incorrect number of passed parameters.");
        }
        for (int x = 0; x < fields.length; ++x) {
            String name = fields[x].getName();
            if (!map.containsKey(name)) {
                throw new DebugException("Wrong query on additional index, value of field " + name + " not specified.");
            }
            Object value = map.get(name);
            String str = StorableObject.objectToString(value, fields[x].isOrdered());
            buf.append(str);
            if (x >= fields.length - 1) continue;
            buf.append(INDEX_KEY_DELIMITER_2);
        }
        return buf.toString();
    }

    public static String valueToKey(Object value, StorableClass.IndexDescriptor.Field[] fields) {
        if (fields.length != 1) {
            throw new DebugException("Wrong query on additional index, more than one parameter expected.");
        }
        return StorableObject.objectToString(value, fields[0].isOrdered());
    }
}

