/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.storagemodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import org.netbeans.mdr.persistence.Index;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.Storage;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.storagemodel.MdrStorage;
import org.netbeans.mdr.storagemodel.StorableAssociation;
import org.netbeans.mdr.storagemodel.Transient;
import org.netbeans.mdr.util.DebugException;
import org.netbeans.mdr.util.IOUtils;

public class TransientStorableAssociation
extends StorableAssociation
implements Transient {
    private static final String FORMAT = "{0}-{1}-{2}";
    private boolean uniqueA;
    private boolean uniqueB;
    private transient Index atIndex;
    private transient Index btIndex;

    public TransientStorableAssociation() {
    }

    public TransientStorableAssociation(MdrStorage mdrStorage, MOFID immediatePackage, MOFID meta, String endA, MOFID endAId, String endB, MOFID endBId, Class typeA, Class typeB, int minA, int maxA, int minB, int maxB, boolean orderedA, boolean orderedB, boolean uniqueA, boolean uniqueB, boolean aggrA, boolean aggrB) throws StorageException {
        super(mdrStorage, immediatePackage, meta, endA, endAId, endB, endBId, typeA, typeB, minA, maxA, minB, maxB, orderedA, orderedB, uniqueA, uniqueB, aggrA, aggrB, false, false);
        this.uniqueA = uniqueA;
        this.uniqueB = uniqueB;
    }

    public void write(OutputStream outputStream) {
        try {
            IOUtils.writeBoolean(outputStream, this.uniqueA);
            IOUtils.writeBoolean(outputStream, this.uniqueB);
        }
        catch (IOException e) {
            throw new DebugException(e);
        }
        super.write(outputStream);
    }

    public void read(InputStream inputStream) {
        try {
            this.uniqueA = IOUtils.readBoolean(inputStream);
            this.uniqueB = IOUtils.readBoolean(inputStream);
        }
        catch (IOException e) {
            throw new DebugException(e);
        }
        super.read(inputStream);
    }

    protected Index createIndex(boolean multi, boolean ordered, boolean unique, int end) throws StorageException {
        Index result = null;
        String name = this.getIndexName(end);
        result = multi ? (ordered ? this.getMdrStorage().getTransientStorage().createMultivaluedOrderedIndex(name, Storage.EntryType.MOFID, Storage.EntryType.MOFID, unique) : this.getMdrStorage().getTransientStorage().createMultivaluedIndex(name, Storage.EntryType.MOFID, Storage.EntryType.MOFID, unique)) : this.getMdrStorage().getTransientStorage().createSinglevaluedIndex(name, Storage.EntryType.MOFID, Storage.EntryType.MOFID);
        if (end == 1) {
            this.atIndex = result;
        } else {
            this.btIndex = result;
        }
        return result;
    }

    protected Index findIndex(int end) throws StorageException {
        if (end == 1) {
            if (this.atIndex == null) {
                String name = this.getIndexName(end);
                this.atIndex = this.getMdrStorage().getTransientStorage().getIndex(name);
                if (this.atIndex == null) {
                    this.atIndex = this.createIndex(this.isMultivaluedA(), this.isOrderedA(), this.isUniqueA(), end);
                }
            }
            return this.atIndex;
        }
        if (this.btIndex == null) {
            String name = this.getIndexName(end);
            this.btIndex = this.getMdrStorage().getTransientStorage().getIndex(name);
            if (this.btIndex == null) {
                this.btIndex = this.createIndex(this.isMultivaluedB(), this.isOrderedB(), this.isUniqueB(), end);
            }
        }
        return this.btIndex;
    }

    protected void deleteIndex(String opkgId, String mofId, int end) throws StorageException {
        String name = this.getIndexName(end);
        this.getMdrStorage().getTransientStorage().dropIndex(name);
        if (end == 1) {
            this.atIndex = null;
        } else {
            this.btIndex = null;
        }
    }

    protected boolean isUniqueA() {
        return this.uniqueA;
    }

    protected boolean isUniqueB() {
        return this.uniqueB;
    }

    private String getIndexName(int end) {
        return MessageFormat.format(FORMAT, this.getOutermostPackageId(), this.getMofId(), new Integer(end));
    }
}

