/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.storagemodel.transientimpl;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.MultivaluedIndex;
import org.netbeans.mdr.persistence.SinglevaluedIndex;
import org.netbeans.mdr.persistence.Storage;
import org.netbeans.mdr.persistence.StorageBadRequestException;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.storagemodel.MdrStorage;
import org.netbeans.mdr.storagemodel.transientimpl.CompensatingTransaction;
import org.netbeans.mdr.storagemodel.transientimpl.TransientIndex;
import org.netbeans.mdr.util.AbstractCollectionFactory;
import org.netbeans.mdr.util.DebugException;
import org.netbeans.mdr.util.MapEntryImpl;

public class TransientMultivaluedIndex
extends TransientIndex
implements MultivaluedIndex {
    protected boolean unique;

    public TransientMultivaluedIndex(MdrStorage storage, String name, Storage.EntryType keyType, Storage.EntryType valueType, boolean unique) {
        super(storage, name, keyType, valueType);
        this.unique = unique;
    }

    public void add(Object key, Object value) throws StorageException {
        this.addNoTx(key, value);
        this.handleAdd(key, value);
    }

    protected void expungeStaleEntries() {
        TransientIndex.KeyedReference ref = null;
        while ((ref = (TransientIndex.KeyedReference)this.refQueue.poll()) != null) {
            MOFID key;
            List clearedSlots = AbstractCollectionFactory.getCollectionFactory().createArrayList();
            if (clearedSlots.contains(key = ref.getLookupKey())) continue;
            Collection c = (Collection)this.map.get(key);
            TransientMultivaluedIndex.expungeCollection(c);
            clearedSlots.add(key);
        }
    }

    protected SlotCollection createSlotCollection(Object key, Collection c) {
        return new SlotCollection(key, c);
    }

    protected SlotCollection createSlotCollection(Object key, Collection c, SinglevaluedIndex repos) {
        return new SlotCollection(key, c, repos);
    }

    public Collection getItems(Object key) throws StorageException {
        if (this.map == null) {
            this.map = AbstractCollectionFactory.getCollectionFactory().createHashMap();
        } else {
            this.expungeStaleEntries();
        }
        Collection c = (Collection)this.map.get(key);
        if (c == null) {
            c = AbstractCollectionFactory.getCollectionFactory().createArrayList();
            this.map.put(key, c);
        }
        return this.createSlotCollection(key, c);
    }

    public Collection getObjects(Object key, SinglevaluedIndex repos) throws StorageException {
        if (this.map == null) {
            this.map = AbstractCollectionFactory.getCollectionFactory().createHashMap();
        } else {
            this.expungeStaleEntries();
        }
        Collection c = (Collection)this.map.get(key);
        if (c == null) {
            c = AbstractCollectionFactory.getCollectionFactory().createArrayList();
            this.map.put(key, c);
        }
        return this.createSlotCollection(key, c, repos);
    }

    protected void handleRemove(Object key, Object value) throws StorageException {
        Collection c = (Collection)value;
        Iterator it = c.iterator();
        while (it.hasNext()) {
            TransientIndex.Entry e = (TransientIndex.Entry)it.next();
            it.remove();
            e.dispose();
            this.txlog.push(new CompensatingTransaction.RemoveCTx(key, e.getValue()));
        }
    }

    public boolean isUnique() throws StorageException {
        return this.unique;
    }

    public boolean remove(Object key, Object value) throws StorageException {
        Object result = this.removeNoTx(key, value);
        this.txlog.push(new CompensatingTransaction.RemoveCTx(key, result));
        return result != null;
    }

    public Set keySet() throws StorageException {
        if (this.map == null) {
            this.map = AbstractCollectionFactory.getCollectionFactory().createHashMap();
        }
        return new MultivaluedEntryKeySet();
    }

    public Collection queryByKeyPrefix(Object prefix, SinglevaluedIndex primaryIndex) throws StorageException {
        if (this.getKeyType() != Storage.EntryType.STRING) {
            throw new UnsupportedOperationException("Key type must be EntryType.STRING");
        }
        if (!(prefix instanceof String)) {
            throw new StorageBadRequestException("String object parameter expected.");
        }
        LinkedList<MapEntryImpl> result = new LinkedList<MapEntryImpl>();
        Iterator iter = this.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!key.startsWith((String)prefix)) continue;
            result.add(new MapEntryImpl(key, this.getObjects(key, primaryIndex)));
        }
        return result;
    }

    protected Object map(Object key, Object value, SinglevaluedIndex index) throws StorageException {
        String otherStorage;
        if (index == null) {
            return value;
        }
        String thisStorage = MdrStorage.getStorageIdFromMofId((MOFID)key);
        if (thisStorage.equals(otherStorage = MdrStorage.getStorageIdFromMofId((MOFID)value))) {
            return index.get(value);
        }
        return this.storage.resolve(otherStorage, value);
    }

    protected final void addNoTx(Object key, Object value) throws StorageException {
        List list;
        if (this.map == null) {
            this.map = AbstractCollectionFactory.getCollectionFactory().createHashMap();
        }
        if ((list = (List)this.map.get(key)) == null) {
            list = AbstractCollectionFactory.getCollectionFactory().createArrayList();
            this.map.put(key, list);
        }
        this.addToCollection(list, key, value);
    }

    protected final Object removeNoTx(Object key, Object value) throws StorageException {
        if (this.map == null) {
            return null;
        }
        this.expungeStaleEntries();
        Collection c = (Collection)this.map.get(key);
        if (c == null) {
            return null;
        }
        Iterator it = c.iterator();
        while (it.hasNext()) {
            TransientIndex.Entry e = (TransientIndex.Entry)it.next();
            MOFID evalue = e.getValue();
            if (!value.equals(evalue)) continue;
            it.remove();
            e.dispose();
            return evalue;
        }
        return null;
    }

    private void addToCollection(Collection c, Object key, Object value) throws StorageException {
        if (this.unique) {
            Iterator it = c.iterator();
            while (it.hasNext()) {
                TransientIndex.Entry e = (TransientIndex.Entry)it.next();
                if (!value.equals(e.getValue())) continue;
                throw new StorageBadRequestException("Value: " + value + " is already contained.");
            }
        }
        TransientIndex.Entry e = new TransientIndex.Entry(key, value);
        c.add(e);
    }

    private static void expungeCollection(Collection c) {
        if (c == null) {
            return;
        }
        Iterator it = c.iterator();
        while (it.hasNext()) {
            TransientIndex.Entry e = (TransientIndex.Entry)it.next();
            if (e.isValid()) continue;
            e.dispose();
            it.remove();
        }
    }

    private static boolean isValidCollection(Object obj) {
        Collection c = (Collection)obj;
        if (c.size() == 0) {
            return false;
        }
        Iterator it = c.iterator();
        while (it.hasNext()) {
            TransientIndex.Entry e = (TransientIndex.Entry)it.next();
            if (!e.isValid()) {
                it.remove();
                e.dispose();
                continue;
            }
            return true;
        }
        return false;
    }

    public void setKey(Object key, Object vals) {
    }

    public Collection addNewRecord(Object key) {
        return null;
    }

    protected class MultivaluedEntryKeyIterator
    implements Iterator {
        private Iterator innerIt;
        private Collection top;
        private Collection last;

        public MultivaluedEntryKeyIterator() {
            this.innerIt = TransientMultivaluedIndex.this.map.values().iterator();
        }

        public boolean hasNext() {
            while (this.top == null) {
                if (!this.innerIt.hasNext()) {
                    return false;
                }
                this.top = (Collection)this.innerIt.next();
                if (TransientMultivaluedIndex.isValidCollection(this.top)) continue;
                this.top = null;
            }
            return true;
        }

        public Object next() {
            while (this.top == null) {
                this.top = (Collection)this.innerIt.next();
                if (TransientMultivaluedIndex.isValidCollection(this.top)) continue;
                this.top = null;
            }
            this.last = this.top;
            this.top = null;
            return ((TransientIndex.Entry)this.last.iterator().next()).getKey();
        }

        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            this.innerIt.remove();
            try {
                TransientMultivaluedIndex.this.handleRemove(((TransientIndex.Entry)this.last.iterator().next()).getKey(), this.last);
            }
            catch (StorageException se) {
                throw new DebugException(se.toString());
            }
        }
    }

    protected class SlotIterator
    implements Iterator {
        protected Object key;
        protected SinglevaluedIndex repos;
        protected Collection collection;
        protected Iterator innerIt;
        protected TransientIndex.Entry top;
        protected TransientIndex.Entry last;

        public SlotIterator(Collection c) {
            this(c, null, null);
        }

        public SlotIterator(Object key, Collection c, SinglevaluedIndex repos) {
            this(key, c, repos, c.iterator());
        }

        protected SlotIterator(Object key, Collection c, SinglevaluedIndex repos, Iterator it) {
            this.key = key;
            this.collection = c;
            this.repos = repos;
            this.innerIt = it;
        }

        public boolean hasNext() {
            while (this.top == null) {
                if (!this.innerIt.hasNext()) {
                    return false;
                }
                this.top = (TransientIndex.Entry)this.innerIt.next();
                if (this.top.isValid()) continue;
                this.innerIt.remove();
                this.top.dispose();
                this.top = null;
            }
            return true;
        }

        public Object next() {
            while (this.top == null) {
                this.top = (TransientIndex.Entry)this.innerIt.next();
                if (this.top.isValid()) continue;
                this.innerIt.remove();
                this.top.dispose();
                this.top = null;
            }
            this.last = this.top;
            this.top = null;
            try {
                return TransientMultivaluedIndex.this.map(this.key, this.last.getValue(), this.repos);
            }
            catch (StorageException se) {
                throw new DebugException(se.toString());
            }
        }

        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            this.innerIt.remove();
            this.last.dispose();
            TransientMultivaluedIndex.this.txlog.push(new CompensatingTransaction.RemoveCTx(this.key, this.last.getValue()));
            this.last = null;
        }
    }

    protected class MultivaluedEntryKeySet
    extends TransientIndex.EntryKeySet {
        protected MultivaluedEntryKeySet() {
        }

        protected List collectKeys() {
            List result = AbstractCollectionFactory.getCollectionFactory().createArrayList();
            Iterator it = TransientMultivaluedIndex.this.map.values().iterator();
            while (it.hasNext()) {
                Collection c = (Collection)it.next();
                if (!TransientMultivaluedIndex.isValidCollection(c)) continue;
                result.add(((TransientIndex.Entry)c.iterator().next()).getKey());
            }
            return result;
        }

        public Iterator iterator() {
            return new MultivaluedEntryKeyIterator();
        }
    }

    protected class SlotCollection
    implements Collection {
        protected Object key;
        protected Collection st;
        protected SinglevaluedIndex repos;

        public SlotCollection(Object key, Collection st) {
            this(key, st, null);
        }

        public SlotCollection(Object key, Collection st, SinglevaluedIndex repos) {
            this.key = key;
            this.st = st;
            this.repos = repos;
        }

        public boolean add(Object obj) {
            if (this.repos != null) {
                throw new UnsupportedOperationException();
            }
            try {
                TransientMultivaluedIndex.this.addToCollection(this.st, this.key, obj);
                TransientMultivaluedIndex.this.handleAdd(this.key, obj);
                return true;
            }
            catch (StorageException se) {
                throw new DebugException(se.toString());
            }
        }

        public boolean addAll(Collection collection) {
            boolean result = false;
            Iterator it = collection.iterator();
            while (it.hasNext()) {
                result |= this.add(it.next());
            }
            return result;
        }

        public void clear() {
            Iterator it = this.st.iterator();
            while (it.hasNext()) {
                TransientIndex.Entry e = (TransientIndex.Entry)it.next();
                it.remove();
                e.dispose();
                TransientMultivaluedIndex.this.txlog.push(new CompensatingTransaction.RemoveCTx(e.getKey(), e.getValue()));
            }
        }

        public boolean contains(Object obj) {
            if (this.repos != null) {
                throw new UnsupportedOperationException();
            }
            TransientMultivaluedIndex.this.expungeStaleEntries();
            Iterator it = this.st.iterator();
            while (it.hasNext()) {
                TransientIndex.Entry e = (TransientIndex.Entry)it.next();
                if (!obj.equals(e.getValue())) continue;
                return true;
            }
            return false;
        }

        public boolean containsAll(Collection collection) {
            boolean result = true;
            Iterator it = collection.iterator();
            while (it.hasNext()) {
                result &= this.contains(it.next());
            }
            return result;
        }

        public boolean isEmpty() {
            TransientMultivaluedIndex.this.expungeStaleEntries();
            return this.st.size() == 0;
        }

        public Iterator iterator() {
            return new SlotIterator(this.key, this.st, this.repos);
        }

        public boolean remove(Object obj) {
            if (this.repos != null) {
                throw new UnsupportedOperationException();
            }
            TransientMultivaluedIndex.this.expungeStaleEntries();
            Iterator it = this.st.iterator();
            while (it.hasNext()) {
                TransientIndex.Entry entry = (TransientIndex.Entry)it.next();
                if (!obj.equals(entry.getValue())) continue;
                it.remove();
                TransientMultivaluedIndex.this.txlog.push(new CompensatingTransaction.RemoveCTx(entry.getKey(), entry.getValue()));
                entry.dispose();
                return true;
            }
            return false;
        }

        public boolean removeAll(Collection collection) {
            boolean result = false;
            Iterator it = collection.iterator();
            while (it.hasNext()) {
                result |= this.remove(it.next());
            }
            return result;
        }

        public boolean retainAll(Collection collection) {
            if (this.repos != null) {
                throw new UnsupportedOperationException();
            }
            boolean result = false;
            Iterator it = this.st.iterator();
            while (it.hasNext()) {
                TransientIndex.Entry entry = (TransientIndex.Entry)it.next();
                if (!entry.isValid()) {
                    it.remove();
                    entry.dispose();
                    continue;
                }
                if (collection.contains(entry.getValue())) continue;
                it.remove();
                entry.dispose();
                TransientMultivaluedIndex.this.txlog.push(new CompensatingTransaction.RemoveCTx(entry.getKey(), entry.getValue()));
                result = true;
            }
            return result;
        }

        public int size() {
            TransientMultivaluedIndex.this.expungeStaleEntries();
            return this.st.size();
        }

        public Object[] toArray() {
            List result = this.collectValues();
            return result.toArray();
        }

        public Object[] toArray(Object[] obj) {
            List result = this.collectValues();
            return result.toArray(obj);
        }

        private List collectValues() {
            List result = AbstractCollectionFactory.getCollectionFactory().createArrayList();
            Iterator it = this.st.iterator();
            while (it.hasNext()) {
                TransientIndex.Entry entry = (TransientIndex.Entry)it.next();
                if (!entry.isValid()) {
                    it.remove();
                    entry.dispose();
                    continue;
                }
                try {
                    result.add(TransientMultivaluedIndex.this.map(this.key, entry.getValue(), this.repos));
                }
                catch (StorageException se) {
                    throw new DebugException(se.toString());
                }
            }
            return result;
        }
    }
}

