/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.util;

import org.netbeans.api.mdr.MDRepository;
import org.netbeans.api.mdr.events.MDRChangeEvent;
import org.netbeans.api.mdr.events.TransactionEvent;
import org.netbeans.mdr.NBMDRepositoryImpl;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.storagemodel.MdrStorage;
import org.netbeans.mdr.util.DebugException;
import org.netbeans.mdr.util.EventNotifier;
import org.netbeans.mdr.util.Logger;

public abstract class TransactionMutex {
    private final MdrStorage storage;
    private final EventNotifier notifier;
    private final NBMDRepositoryImpl repository;

    protected TransactionMutex(Object storage, Object notifier, Object repository) {
        this.storage = (MdrStorage)storage;
        this.notifier = (EventNotifier)notifier;
        this.repository = (NBMDRepositoryImpl)repository;
    }

    public abstract boolean willFail();

    public abstract boolean pendingChanges();

    public abstract void enter(boolean var1);

    public final void leave() {
        this.leave(false);
    }

    public abstract boolean leave(boolean var1);

    protected final void start() {
        TransactionEvent event = new TransactionEvent((MDRepository)this.repository, 0x110001);
        this.notifier.REPOSITORY.firePlannedChange(this.storage, (MDRChangeEvent)event);
    }

    protected final void end(boolean fail) {
        try {
            TransactionEvent event = new TransactionEvent((MDRepository)this.repository, 0x110002);
            this.notifier.REPOSITORY.firePlannedChange(this.storage, (MDRChangeEvent)event);
            if (fail) {
                this.notifier.fireCancelled();
                this.storage.rollback();
            } else {
                this.notifier.fireChanged();
                this.storage.commit();
            }
        }
        catch (StorageException e) {
            try {
                Logger.getDefault().notify(1, (Throwable)e);
                this.storage.rollback();
            }
            catch (StorageException fatal) {
                throw new DebugException("Fatal I/O error: " + fatal.toString());
            }
        }
    }
}

