/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.services;

import com.gentleware.services.IconLoader;
import com.gentleware.services.Services;
import com.gentleware.services.swingx.ResourceId;
import com.gentleware.services.util.CollectionFactory;
import com.gentleware.services.util.UnicodeResourceBundle;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public class Localizer {
    private Map B = new WeakHashMap();
    private Set C = CollectionFactory.createHashSet();
    private Set D = CollectionFactory.createHashSet();
    private Map A = CollectionFactory.createHashMap();

    public void addListener(Listener listener) {
        this.B.put(listener, null);
    }

    public void removeListener(Listener listener) {
        this.B.remove(listener);
    }

    private void B() {
        Set set = this.B.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Listener listener = (Listener)iterator.next();
            if (listener == null) continue;
            listener.localeChanged();
        }
    }

    public void setLocale(Locale locale) {
        if (!Locale.getDefault().equals(locale)) {
            Locale.setDefault(locale);
            this.D.clear();
            this.A.clear();
            Iterator iterator = this.C.iterator();
            while (iterator.hasNext()) {
                _A _A2 = (_A)iterator.next();
                this.A(_A2);
            }
            this.B();
        }
    }

    public void removeResourceBundle(String string) {
        Iterator iterator = this.C.iterator();
        while (iterator.hasNext()) {
            _A _A2 = (_A)iterator.next();
            if (_A2.B != string) continue;
            UnicodeResourceBundle unicodeResourceBundle = (UnicodeResourceBundle)this.A.remove(string);
            this.D.remove(unicodeResourceBundle);
            iterator.remove();
            break;
        }
    }

    public void addResourceBundle(String string, String string2, ClassLoader classLoader) throws MissingResourceException {
        _A _A2 = new _A(string, string2, classLoader);
        this.A(_A2);
        this.C.add(_A2);
    }

    private void A(_A _A2) throws MissingResourceException {
        Locale locale = Locale.getDefault();
        UnicodeResourceBundle unicodeResourceBundle = UnicodeResourceBundle.getBundle(_A2.C, locale, _A2.A);
        UnicodeResourceBundle unicodeResourceBundle2 = (UnicodeResourceBundle)this.A.get(_A2.B);
        if (unicodeResourceBundle2 != null) {
            this.D.remove(unicodeResourceBundle2);
        }
        this.A.put(_A2.B, unicodeResourceBundle);
        this.D.add(unicodeResourceBundle);
    }

    public Set getKeys(String string) {
        UnicodeResourceBundle unicodeResourceBundle = (UnicodeResourceBundle)this.A.get(string);
        Set set = unicodeResourceBundle == null ? Collections.EMPTY_SET : CollectionFactory.createHashSet(unicodeResourceBundle.getKeys());
        return set;
    }

    public boolean containsKey(ResourceId resourceId) {
        return this.containsKey(resourceId.getBundle(), resourceId.getKey());
    }

    public boolean containsKey(String string, String string2) {
        boolean bl = false;
        UnicodeResourceBundle unicodeResourceBundle = (UnicodeResourceBundle)this.A.get(string);
        if (unicodeResourceBundle != null) {
            try {
                unicodeResourceBundle.getString(string2);
                bl = true;
            }
            catch (MissingResourceException missingResourceException) {
                Services.logDebug(missingResourceException);
            }
        }
        return bl;
    }

    public String get(String string, String string2, String string3) {
        String string4 = string3;
        UnicodeResourceBundle unicodeResourceBundle = (UnicodeResourceBundle)this.A.get(string);
        if (unicodeResourceBundle != null) {
            try {
                string4 = unicodeResourceBundle.getString(string2);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return string4;
    }

    public String get(ResourceId resourceId) {
        if (resourceId == null) {
            return "[Localizer:] No ResourceID";
        }
        return this.get(resourceId.getBundle(), resourceId.getKey());
    }

    public String get(ResourceId resourceId, String string) {
        if (resourceId == null) {
            return "[Localizer:] No ResourceID";
        }
        return this.get(resourceId.getBundle(), resourceId.getKey(), string);
    }

    public String get(String string, String string2) {
        String string3 = this.get(string, string2, string2);
        return string3;
    }

    public boolean getBoolean(ResourceId resourceId) {
        boolean bl = this.getBoolean(resourceId, false);
        return bl;
    }

    public boolean getBoolean(ResourceId resourceId, boolean bl) {
        boolean bl2 = bl;
        String string = this.get(resourceId, null);
        if ("true".equals(string)) {
            bl2 = true;
        } else if ("false".equals(string)) {
            bl2 = false;
        } else if (string != null) {
            Services.logError("[Localizer] Resource " + resourceId + ": Cannot parse Boolean from " + string);
        }
        return bl2;
    }

    public ImageIcon getIcon(ResourceId resourceId) {
        ImageIcon imageIcon = null;
        String string = Services.localize(resourceId);
        if (string != null) {
            IconLoader iconLoader = Services.getInstance().getIconLoader();
            imageIcon = iconLoader.get(string, "", this.getClass().getClassLoader());
        }
        return imageIcon;
    }

    public KeyStroke getKeyStroke(ResourceId resourceId) {
        KeyStroke keyStroke = null;
        String string = Services.localize(resourceId);
        if (string != null) {
            int n = string.indexOf("shortcut");
            if (n == -1) {
                keyStroke = KeyStroke.getKeyStroke(string);
            } else {
                string = string.substring(0, n) + string.substring(n + "shortcut".length());
                KeyStroke keyStroke2 = KeyStroke.getKeyStroke(string);
                int n2 = keyStroke2.getModifiers() | this.A();
                int n3 = keyStroke2.getKeyCode();
                keyStroke = KeyStroke.getKeyStroke(n3, n2);
            }
        }
        return keyStroke;
    }

    private int A() {
        int n = 17;
        try {
            n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
        return n;
    }

    public int getInteger(String string, String string2, int n) {
        int n2 = n;
        String string3 = Services.localize(string, string2);
        if (string3 != null) {
            try {
                n2 = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                Services.logError("[Localizer] Resource " + string + ", " + string2 + ": Cannot parse Integer from " + string3);
            }
        }
        return n2;
    }

    public int getMnemonic(String string, String string2) {
        int n = 0;
        String string3 = Services.localize(string, string2);
        if (string3 != null) {
            if (string3.length() == 1) {
                char c = string3.charAt(0);
                n = c;
            } else {
                Services.logError("[Localizer] Resource " + string + ", " + string2 + ": Mnemonic should have only one " + string3);
            }
        }
        return n;
    }

    private static class _A {
        private String B;
        private String C;
        private ClassLoader A;

        _A(String string, String string2, ClassLoader classLoader) {
            this.B = string;
            this.C = string2;
            this.A = classLoader;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof _A)) {
                return false;
            }
            _A _A2 = (_A)object;
            if (!this.C.equals(_A2.C)) {
                return false;
            }
            return this.B.equals(_A2.B);
        }

        public int hashCode() {
            int n = this.B.hashCode();
            n = 29 * n + this.C.hashCode();
            return n;
        }
    }

    public static interface Listener {
        public void localeChanged();
    }
}

