/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.services;

import com.gentleware.services.A;
import com.gentleware.services.IconLoader;
import com.gentleware.services.Localizer;
import com.gentleware.services.configuration.B;
import com.gentleware.services.configuration.Configuration;
import com.gentleware.services.swingx.ResourceId;
import java.io.File;
import java.io.OutputStream;

public class Services {
    protected static Services _instance;
    private IconLoader B;
    private Localizer A;
    protected A _logManager;
    protected Configuration _configuration;

    public Services() throws IllegalStateException {
        if (_instance != null) {
            throw new IllegalStateException("Services already initialized!");
        }
        _instance = this;
    }

    public static Services getInstance() throws IllegalStateException {
        if (_instance == null) {
            throw new IllegalStateException("Services not yet initialized!");
        }
        return _instance;
    }

    public synchronized IconLoader getIconLoader() {
        if (this.B == null) {
            this.B = new IconLoader();
            this.initIconLoader(this.B);
            this.B.addResourceLocation("com/gentleware/services/images", this.getClass().getClassLoader());
        }
        return this.B;
    }

    protected void initIconLoader(IconLoader iconLoader) {
    }

    public synchronized Localizer getLocalizer() {
        if (this.A == null) {
            this.A = new Localizer();
            this.initLocalizer(this.A);
        }
        return this.A;
    }

    protected void initLocalizer(Localizer localizer) {
    }

    public Configuration getConfiguration() {
        if (this._configuration == null) {
            this._configuration = new B(this.getConfigurationFilePath());
        }
        return this._configuration;
    }

    public String getConfigurationDirName() {
        return ".";
    }

    public String getConfigurationFileName() {
        return "services.properties";
    }

    public String getConfigurationFilePath() {
        return this.getConfigurationDirName() + File.separatorChar + this.getConfigurationFileName();
    }

    public String getConfigurationFileHeader() {
        return null;
    }

    public synchronized A getLogManager() {
        if (this._logManager == null) {
            String string = this.getLogLevel();
            OutputStream outputStream = this.getLogOutputStream();
            String string2 = this.getLogFilePath();
            long l = this.getMaximumLogFileSize();
            int n = this.getMaximumLogFileBackupIndex();
            this._logManager = new A(this.getLogPatternFormat(), string, outputStream, string2, l, n);
        }
        return this._logManager;
    }

    protected String getLogPatternFormat() {
        return "%d{ISO8601} %-5p [%-18t]: %m%n";
    }

    protected int getMaximumLogFileBackupIndex() {
        return 1;
    }

    protected long getMaximumLogFileSize() {
        return 0x200000L;
    }

    public String getLogDirName() {
        return ".";
    }

    public String getLogFileName() {
        return "services.log";
    }

    public String getLogFilePath() {
        String string = this.getLogFileName();
        return this.getLogFilePath(string);
    }

    public String getLogFilePath(String string) {
        return this.getLogDirName() + File.separatorChar + string;
    }

    public String getLogLevel() {
        return "INFO";
    }

    public OutputStream getLogOutputStream() {
        return System.out;
    }

    public static void logDebug(Object object) {
        Services.getInstance().getLogManager().A(object);
    }

    public static void logDebug(Object object, Throwable throwable) {
        Services.getInstance().getLogManager().E(object, throwable);
    }

    public static void logInfo(Object object) {
        Services.getInstance().getLogManager().F(object);
    }

    public static void logInfo(Object object, Throwable throwable) {
        Services.getInstance().getLogManager().A(object, throwable);
    }

    public static void logWarn(Object object) {
        Services.getInstance().getLogManager().E(object);
    }

    public static void logWarn(Object object, Throwable throwable) {
        Services.getInstance().getLogManager().B(object, throwable);
    }

    public static void logError(Object object) {
        Services.getInstance().getLogManager().B(object);
    }

    public static void logError(Object object, Throwable throwable) {
        Services.getInstance().getLogManager().F(object, throwable);
    }

    public static void logErrorOrThrow(Object object) {
        Services.getInstance().getLogManager().G(object);
    }

    public static void logErrorOrThrow(Object object, Throwable throwable) {
        Services.getInstance().getLogManager().D(object, throwable);
    }

    public static void logFatal(Object object) {
        Services.getInstance().getLogManager().C(object);
    }

    public static void logFatal(Object object, Throwable throwable) {
        Services.getInstance().getLogManager().C(object, throwable);
    }

    public static boolean isDebugEnabled() {
        return Services.getInstance().getLogManager().B();
    }

    public static String localize(ResourceId resourceId) {
        return Services.getInstance().getLocalizer().get(resourceId);
    }

    public static String localize(String string, String string2) {
        return Services.getInstance().getLocalizer().get(string, string2);
    }
}

