/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.services.swingx;

import com.gentleware.services.IconLoader;
import com.gentleware.services.Localizer;
import com.gentleware.services.Services;
import com.gentleware.services.swingx.ResourceId;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public class ComponentResources {
    private static final String H = "_name";
    private static final String K = "_mnemonic";
    private static final String A = "_mnemonic_index";
    private static final String O = "_tooltip";
    private static final String N = "_icon";
    private static final String M = "_accelerator";
    private static final String B = "_accelerator2";
    private static final String R = "_enabled";
    private static final String E = "_toggle";
    private String C;
    private String I;
    private String S;
    private Integer J;
    private Integer L;
    private ImageIcon G;
    private KeyStroke P;
    private KeyStroke F;
    private boolean Q;
    private boolean D;

    public static final String[] getAllSuffixes() {
        String[] stringArray = new String[]{H, K, A, O, N, M, B, R, E};
        return stringArray;
    }

    public ComponentResources(ResourceId resourceId) {
        Localizer localizer = Services.getInstance().getLocalizer();
        this.C = ComponentResources.A(localizer, resourceId);
        this.I = ComponentResources.F(localizer, resourceId);
        this.J = ComponentResources.B(localizer, resourceId);
        this.L = ComponentResources.A(localizer, resourceId, this.C.length());
        this.S = ComponentResources.D(localizer, resourceId);
        this.G = ComponentResources.C(localizer, resourceId);
        this.P = ComponentResources.I(localizer, resourceId);
        this.F = ComponentResources.H(localizer, resourceId);
        this.Q = ComponentResources.G(localizer, resourceId);
        this.D = ComponentResources.E(localizer, resourceId);
    }

    public ComponentResources(Action action) {
        this.I = (String)action.getValue("Default");
        this.C = (String)action.getValue("Name");
        this.G = (ImageIcon)action.getValue("SmallIcon");
        this.S = (String)action.getValue("ShortDescription");
        this.P = (KeyStroke)action.getValue("AcceleratorKey");
        this.F = (KeyStroke)action.getValue("AcceleratorKey2");
        Integer n = (Integer)action.getValue("MnemonicKey");
        this.J = n != null ? n : new Integer(0);
        this.L = (Integer)action.getValue("MnemonicIndex");
        this.Q = action.isEnabled();
        this.D = Boolean.TRUE == action.getValue("ToggleAction");
    }

    private static boolean E(Localizer localizer, ResourceId resourceId) {
        boolean bl = localizer.getBoolean(resourceId.createSubResourceId(E));
        return bl;
    }

    private static boolean G(Localizer localizer, ResourceId resourceId) {
        boolean bl = localizer.getBoolean(resourceId.createSubResourceId(R), true);
        return bl;
    }

    private static KeyStroke H(Localizer localizer, ResourceId resourceId) {
        KeyStroke keyStroke = null;
        ResourceId resourceId2 = resourceId.createSubResourceId(B);
        if (localizer.containsKey(resourceId2)) {
            keyStroke = localizer.getKeyStroke(resourceId2);
        }
        return keyStroke;
    }

    private static KeyStroke I(Localizer localizer, ResourceId resourceId) {
        KeyStroke keyStroke = null;
        ResourceId resourceId2 = resourceId.createSubResourceId(M);
        if (localizer.containsKey(resourceId2)) {
            keyStroke = localizer.getKeyStroke(resourceId2);
        }
        return keyStroke;
    }

    public static ImageIcon retrieveIcon(ResourceId resourceId) {
        Localizer localizer = Services.getInstance().getLocalizer();
        ImageIcon imageIcon = ComponentResources.C(localizer, resourceId);
        return imageIcon;
    }

    private static ImageIcon C(Localizer localizer, ResourceId resourceId) {
        ImageIcon imageIcon = null;
        ResourceId resourceId2 = resourceId.createSubResourceId(N);
        if (localizer.containsKey(resourceId2)) {
            String string = localizer.get(resourceId2);
            IconLoader iconLoader = Services.getInstance().getIconLoader();
            imageIcon = iconLoader.get(string, "");
            if (imageIcon == null) {
                // empty if block
            }
        }
        return imageIcon;
    }

    public static String retrieveTooltip(ResourceId resourceId) {
        Localizer localizer = Services.getInstance().getLocalizer();
        String string = ComponentResources.D(localizer, resourceId);
        return string;
    }

    private static String D(Localizer localizer, ResourceId resourceId) {
        String string = null;
        ResourceId resourceId2 = resourceId.createSubResourceId(O);
        if (localizer.containsKey(resourceId2)) {
            string = localizer.get(resourceId2);
        }
        return string;
    }

    private static Integer A(Localizer localizer, ResourceId resourceId, int n) {
        String string;
        Integer n2 = null;
        ResourceId resourceId2 = resourceId.createSubResourceId(A);
        if (localizer.containsKey(resourceId2) && (string = localizer.get(resourceId2)) != null && string.length() > 0) {
            try {
                int n3 = Integer.parseInt(string);
                if (n3 < n) {
                    n2 = new Integer(n3);
                } else {
                    Services.logWarn("mnemonic index " + n3 + " too large in " + resourceId2 + ". Value is ignored.");
                }
            }
            catch (NumberFormatException numberFormatException) {
                Services.logError("[SwingFactory] Cannot parse mnemonic index in bundle " + resourceId2 + string);
            }
        }
        return n2;
    }

    public static Integer retrieveMnemonic(ResourceId resourceId) {
        Localizer localizer = Services.getInstance().getLocalizer();
        Integer n = ComponentResources.B(localizer, resourceId);
        return n;
    }

    private static Integer B(Localizer localizer, ResourceId resourceId) {
        String string;
        Integer n = null;
        ResourceId resourceId2 = resourceId.createSubResourceId(K);
        if (localizer.containsKey(resourceId2) && (string = localizer.get(resourceId2)).length() > 0) {
            char c;
            char c2 = c = string.charAt(0);
            n = new Integer(c2);
        }
        if (n == null) {
            n = new Integer(0);
        }
        return n;
    }

    public static String retrieveText(ResourceId resourceId) {
        Localizer localizer = Services.getInstance().getLocalizer();
        String string = ComponentResources.A(localizer, resourceId);
        return string;
    }

    private static String A(Localizer localizer, ResourceId resourceId) {
        String string = localizer.get(resourceId);
        return string;
    }

    public static String retrieveName(ResourceId resourceId) {
        Localizer localizer = Services.getInstance().getLocalizer();
        return ComponentResources.F(localizer, resourceId);
    }

    private static String F(Localizer localizer, ResourceId resourceId) {
        ResourceId resourceId2 = resourceId.createSubResourceId(H);
        String string = localizer.containsKey(resourceId2) ? localizer.get(resourceId2) : resourceId.getKey();
        return string;
    }

    public void configureAction(Action action) {
        action.putValue("Default", this.I);
        action.putValue("Name", this.C);
        action.putValue("SmallIcon", this.G);
        action.putValue("ShortDescription", this.S);
        action.putValue("AcceleratorKey", this.P);
        action.putValue("AcceleratorKey2", this.F);
        action.putValue("MnemonicKey", this.J);
        action.putValue("MnemonicIndex", this.L);
        action.putValue("enabled", this.Q ? Boolean.TRUE : Boolean.FALSE);
        action.putValue("ToggleAction", this.D ? Boolean.TRUE : Boolean.FALSE);
        action.setEnabled(this.Q);
    }

    public String getText() {
        return this.C;
    }

    public void setText(String string) {
        this.C = string;
    }

    public String getName() {
        return this.I;
    }

    public void setName(String string) {
        this.I = string;
    }

    public String getToolTip() {
        return this.S;
    }

    public void setToolTip(String string) {
        this.S = string;
    }

    public Integer getMnemonic() {
        return this.J;
    }

    public void setMnemonic(Integer n) {
        this.J = n;
    }

    public Integer getMnemonicIndex() {
        return this.L;
    }

    public void setMnemonicIndex(Integer n) {
        this.L = n;
    }

    public ImageIcon getIcon() {
        return this.G;
    }

    public void setIcon(ImageIcon imageIcon) {
        this.G = imageIcon;
    }

    public KeyStroke getAccelerator() {
        return this.P;
    }

    public KeyStroke getAccelerator2() {
        return this.F;
    }

    public void setAccelerator(KeyStroke keyStroke) {
        this.P = keyStroke;
    }

    public void setAccelerator2(KeyStroke keyStroke) {
        this.F = keyStroke;
    }

    public boolean isEnabled() {
        return this.Q;
    }

    public void setEnabled(boolean bl) {
        this.Q = bl;
    }

    public boolean isToggleAction() {
        return this.D;
    }

    public void setToggleAction(boolean bl) {
        this.D = bl;
    }
}

