/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.services.swingx;

import com.gentleware.services.IconLoader;
import com.gentleware.services.Localizer;
import com.gentleware.services.Services;
import com.gentleware.services.swingx.ComponentResources;
import com.gentleware.services.swingx.ResourceId;
import com.gentleware.services.swingx.XAbstractAction;
import com.gentleware.services.swingx.XButton;
import com.gentleware.services.swingx.XCheckBox;
import com.gentleware.services.swingx.XCheckBoxMenuItem;
import com.gentleware.services.swingx.XMenu;
import com.gentleware.services.swingx.XMenuItem;
import com.gentleware.services.swingx.XRadioButton;
import com.gentleware.services.swingx.XRadioButtonMenuItem;
import com.gentleware.services.swingx.XToggleButton;
import com.gentleware.services.util.SwingUtil;
import com.gentleware.services.util.WeakHashSet;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;

public class SwingFactory {
    private static ActionListener A = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            abstractButton.doClick();
        }
    };
    private static final String E = "RESOURCE_ID_KEY";
    private static Set C = new WeakHashSet();
    private static Localizer.Listener B = new Localizer.Listener(){

        public void localeChanged() {
            Iterator iterator = C.iterator();
            while (iterator.hasNext()) {
                JLabel jLabel = (JLabel)iterator.next();
                if (jLabel == null) continue;
                SwingFactory.A(jLabel);
            }
        }
    };
    private static boolean D;

    private static void A() {
        if (!D) {
            Services.getInstance().getLocalizer().addListener(B);
        }
        D = true;
    }

    public static void configureAction(Action action, ResourceId resourceId) {
        SwingFactory.A();
        ComponentResources componentResources = new ComponentResources(resourceId);
        componentResources.configureAction(action);
    }

    public static JMenu makeMenu(ResourceId resourceId) {
        SwingFactory.A();
        XAbstractAction xAbstractAction = new XAbstractAction(resourceId);
        XMenu xMenu = new XMenu(xAbstractAction);
        return xMenu;
    }

    public static JMenuItem makeMenuItem(Action action) {
        SwingFactory.A();
        XMenuItem xMenuItem = new XMenuItem(action);
        return xMenuItem;
    }

    public static JLabel makeLabel(ResourceId resourceId, JComponent jComponent) {
        SwingFactory.A();
        JLabel jLabel = new JLabel();
        jLabel.putClientProperty(E, resourceId);
        if (jComponent != null) {
            jLabel.setLabelFor(jComponent);
        }
        SwingFactory.A(jLabel);
        C.add(jLabel);
        return jLabel;
    }

    public static AbstractButton makeToolBarButton(Action action) {
        AbstractButton abstractButton = SwingFactory.makeButton(action);
        abstractButton.putClientProperty("hideActionText", Boolean.TRUE);
        SwingFactory.configureButton(abstractButton, action);
        return abstractButton;
    }

    public static AbstractButton makeToolBarButton(ResourceId resourceId) {
        XAbstractAction xAbstractAction = new XAbstractAction(resourceId);
        return SwingFactory.makeToolBarButton(xAbstractAction);
    }

    public static AbstractButton makeButton(Action action) {
        SwingFactory.A();
        AbstractButton abstractButton = Boolean.TRUE == action.getValue("ToggleAction") ? new XToggleButton(action) : new XButton(action);
        return abstractButton;
    }

    public static JButton makeJButton(ResourceId resourceId) {
        SwingFactory.A();
        XAbstractAction xAbstractAction = new XAbstractAction(resourceId);
        XButton xButton = new XButton(xAbstractAction);
        return xButton;
    }

    public static JButton makeJButton(Action action) {
        SwingFactory.A();
        XButton xButton = new XButton(action);
        return xButton;
    }

    public static AbstractButton makeButton(ResourceId resourceId) {
        SwingFactory.A();
        XAbstractAction xAbstractAction = new XAbstractAction(resourceId);
        AbstractButton abstractButton = SwingFactory.makeButton(xAbstractAction);
        return abstractButton;
    }

    public static JCheckBox makeCheckBox(ResourceId resourceId) {
        SwingFactory.A();
        XAbstractAction xAbstractAction = new XAbstractAction(resourceId);
        JCheckBox jCheckBox = SwingFactory.makeCheckBox(xAbstractAction);
        return jCheckBox;
    }

    public static JCheckBox makeCheckBox(Action action) {
        SwingFactory.A();
        XCheckBox xCheckBox = new XCheckBox(action);
        xCheckBox.setMargin(new Insets(0, 0, 0, 0));
        return xCheckBox;
    }

    public static JRadioButton makeRadioButton(Action action) {
        SwingFactory.A();
        XRadioButton xRadioButton = new XRadioButton(action);
        xRadioButton.setMargin(new Insets(0, 0, 0, 0));
        return xRadioButton;
    }

    public static JRadioButton makeRadioButton(ResourceId resourceId) {
        SwingFactory.A();
        XAbstractAction xAbstractAction = new XAbstractAction(resourceId);
        JRadioButton jRadioButton = SwingFactory.makeRadioButton(xAbstractAction);
        return jRadioButton;
    }

    public static JRadioButtonMenuItem makeRadioButtonMenuItem(Action action) {
        SwingFactory.A();
        XRadioButtonMenuItem xRadioButtonMenuItem = new XRadioButtonMenuItem(action);
        return xRadioButtonMenuItem;
    }

    public static JCheckBoxMenuItem makeCheckBoxMenuItem(Action action) {
        SwingFactory.A();
        XCheckBoxMenuItem xCheckBoxMenuItem = new XCheckBoxMenuItem(action);
        return xCheckBoxMenuItem;
    }

    private static void A(AbstractButton abstractButton, ComponentResources componentResources) {
        SwingFactory.A();
        abstractButton.setName(componentResources.getName());
        boolean bl = componentResources.getIcon() != null;
        boolean bl2 = bl && abstractButton.getClientProperty("hideActionText") == Boolean.TRUE;
        abstractButton.setIcon(componentResources.getIcon());
        abstractButton.setText(bl2 ? null : componentResources.getText());
        SwingUtil.setToolTipText(abstractButton, bl2 && (componentResources.getToolTip() == null || componentResources.getToolTip().length() == 0) ? componentResources.getText() : componentResources.getToolTip());
        if (componentResources.getIcon() != null && componentResources.getIcon() != abstractButton.getIcon()) {
            abstractButton.setIcon(componentResources.getIcon());
        }
        if (componentResources.getAccelerator() != null && abstractButton.getActionForKeyStroke(componentResources.getAccelerator()) == null) {
            abstractButton.registerKeyboardAction(A, componentResources.getAccelerator(), 2);
            if (abstractButton instanceof JMenuItem) {
                ((JMenuItem)abstractButton).setAccelerator(componentResources.getAccelerator());
            }
        }
        if (componentResources.getAccelerator2() != null && abstractButton.getActionForKeyStroke(componentResources.getAccelerator2()) == null) {
            abstractButton.registerKeyboardAction(A, componentResources.getAccelerator2(), 2);
        }
        if (!bl2) {
            abstractButton.setMnemonic(componentResources.getMnemonic() == null || bl2 ? 0 : componentResources.getMnemonic());
            int n = componentResources.getMnemonicIndex() == null ? SwingFactory.A(componentResources.getText(), componentResources.getMnemonic()) : componentResources.getMnemonicIndex();
            try {
                abstractButton.setDisplayedMnemonicIndex(n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Services.logError("MNEMONIC NOT SET FOR: " + componentResources.getName());
            }
        }
        abstractButton.setEnabled(componentResources.isEnabled());
    }

    public static void configureButton(AbstractButton abstractButton, Action action) {
        SwingFactory.A();
        ComponentResources componentResources = new ComponentResources(action);
        if (action instanceof XAbstractAction) {
            XAbstractAction xAbstractAction = (XAbstractAction)action;
            abstractButton.setSelected(xAbstractAction.isSelected());
        }
        SwingFactory.A(abstractButton, componentResources);
    }

    public static ResourceId getLabelResourceId(JLabel jLabel) {
        ResourceId resourceId = (ResourceId)jLabel.getClientProperty(E);
        return resourceId;
    }

    private static void A(JLabel jLabel) {
        SwingFactory.A();
        ResourceId resourceId = (ResourceId)jLabel.getClientProperty(E);
        ComponentResources componentResources = new ComponentResources(resourceId);
        jLabel.setText(componentResources.getText());
        jLabel.setName(componentResources.getName());
        jLabel.setIcon(componentResources.getIcon());
        if (componentResources.getMnemonic() == null) {
            jLabel.setDisplayedMnemonic(0);
        } else {
            jLabel.setDisplayedMnemonic(componentResources.getMnemonic());
        }
        if (componentResources.getMnemonicIndex() == null) {
            if (componentResources.getText().length() > 0 && componentResources.getMnemonic() != null && componentResources.getMnemonic() != 0) {
                int n = SwingFactory.A(componentResources.getText(), componentResources.getMnemonic());
                jLabel.setDisplayedMnemonicIndex(n);
            }
        } else {
            jLabel.setDisplayedMnemonicIndex(componentResources.getMnemonicIndex());
        }
        if (componentResources.getToolTip() != null) {
            SwingUtil.setToolTipText(jLabel, componentResources.getToolTip());
        } else {
            Component component = jLabel.getLabelFor();
            if (component != null && component instanceof JComponent) {
                JComponent jComponent = (JComponent)component;
                String string = jComponent.getToolTipText();
                SwingUtil.setToolTipText(jLabel, string);
            }
        }
    }

    static int A(String string, Integer n) {
        SwingFactory.A();
        if (string == null || n == null || n == 0) {
            return -1;
        }
        int n2 = n;
        char c = Character.toUpperCase((char)n2);
        char c2 = Character.toLowerCase((char)n2);
        int n3 = string.indexOf(c);
        int n4 = string.indexOf(c2);
        if (n3 == -1) {
            return n4;
        }
        if (n4 == -1) {
            return n3;
        }
        return n4 < n3 ? n4 : n3;
    }

    public static Cursor makeCursor(ResourceId resourceId) {
        Cursor cursor = SwingFactory.makeCursor(resourceId, null);
        if (cursor == null) {
            // empty if block
        }
        return cursor;
    }

    public static Cursor makeCursor(ResourceId resourceId, Cursor cursor) {
        Cursor cursor2;
        Object object;
        Boolean bl = Boolean.valueOf(System.getProperty("java.awt.headless"));
        if (Boolean.TRUE.equals(bl)) {
            return null;
        }
        Image image = null;
        int n = 0;
        int n2 = 0;
        if (Services.getInstance().getLocalizer().containsKey(resourceId)) {
            object = Services.localize(resourceId);
            StringTokenizer stringTokenizer = new StringTokenizer((String)object, ",");
            int n3 = stringTokenizer.countTokens();
            if (n3 != 1 && n3 != 3) {
                Services.logError("[SwingFactory] Invalid cursor definition for resource id " + resourceId + ": " + (String)object + "\nFormat must be either <iconname> or <iconname>,<hotX>,<hotY>");
            } else {
                String string = stringTokenizer.nextToken();
                IconLoader iconLoader = Services.getInstance().getIconLoader();
                ImageIcon imageIcon = iconLoader.get(string, "");
                if (imageIcon == null) {
                    Services.logError("[SwingFactory] Cursor icon not found for resource id " + resourceId + ": " + (String)object);
                } else {
                    image = imageIcon.getImage();
                    if (n3 == 3) {
                        n = Integer.parseInt(stringTokenizer.nextToken().trim());
                        n2 = Integer.parseInt(stringTokenizer.nextToken().trim());
                    }
                }
            }
        }
        if (image != null) {
            object = new Point(n, n2);
            cursor2 = Toolkit.getDefaultToolkit().createCustomCursor(image, (Point)object, "");
        } else {
            cursor2 = cursor;
        }
        return cursor2;
    }
}

