/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.services.swingx;

import com.gentleware.services.swingx.XThinBevelBorder;
import com.gentleware.services.util.CollectionFactory;
import com.gentleware.services.util.SwingUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;

public class XColorPanel
extends JPanel {
    private final ActionListener F;
    private final MouseListener R = new MouseAdapter(){

        public void mousePressed(MouseEvent mouseEvent) {
            if ((mouseEvent.getModifiers() & 0x10) > 0) {
                XColorPanel.this.A(mouseEvent);
            }
        }
    };
    private final Color[] Q;
    private final int N;
    private final int K;
    private Color S;
    private static final Color M = null;
    private static final Color D = Color.lightGray;
    private static final Color O = Color.lightGray;
    private static final int H = 0;
    private static final int E = 0;
    private static final Border T = XThinBevelBorder.getRaisedBorder();
    private static final Border L = XThinBevelBorder.getLoweredBorder();
    private static final Border G = BorderFactory.createEtchedBorder();
    private static final int A = 8;
    private static final int J = 8;
    private static final int C = 13;
    private static final int P = 13;
    private static final int I = 20;
    private static final int B = 20;
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;

    public XColorPanel(ActionListener actionListener, Color color, int n) {
        this.F = actionListener;
        this.S = color;
        List list = CollectionFactory.createArrayList();
        this.N = n * n;
        this.K = n;
        float f = 256.0f / (float)(n - 1);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                for (int k = 0; k < n; ++k) {
                    list.add(XColorPanel.A((float)j * f, (float)k * f, (float)i * f));
                }
            }
        }
        this.Q = list.toArray(new Color[list.size()]);
        this.A();
    }

    public XColorPanel(ActionListener actionListener, Color color, int n, float[][] fArray) {
        this.F = actionListener;
        this.S = color;
        this.K = fArray.length;
        this.N = 6 * n;
        this.Q = new Color[this.K * this.N];
        float[] fArray2 = this.A(n);
        for (int i = 0; i < fArray2.length; ++i) {
            int n2 = 0;
            while (n2 < fArray.length) {
                float f = fArray2[i];
                float f2 = fArray[n2][0];
                float f3 = fArray[n2][1];
                Color color2 = Color.getHSBColor(f, f2, f3);
                int n3 = i;
                int n4 = n2++;
                this.Q[n3 + this.N * n4] = color2;
            }
        }
        this.A();
    }

    public XColorPanel(ActionListener actionListener, Color color, int n, int n2, int n3) {
        int n4;
        this.F = actionListener;
        this.S = color;
        this.K = n2 * n3;
        this.N = 6 * n;
        this.Q = new Color[this.K * this.N];
        float[] fArray = this.A(n);
        float[] fArray2 = new float[n2];
        float f = 1.0f / (float)n2;
        for (int i = 0; i < n2; ++i) {
            fArray2[i] = 1.0f - (float)i * f;
        }
        float[] fArray3 = new float[n3];
        float f2 = 1.0f / (float)n3;
        for (n4 = 0; n4 < n3; ++n4) {
            fArray3[n4] = 1.0f - (float)n4 * f2;
        }
        for (n4 = 0; n4 < fArray.length; ++n4) {
            for (int i = 0; i < fArray2.length; ++i) {
                for (int j = 0; j < fArray3.length; ++j) {
                    float f3 = fArray[n4];
                    float f4 = fArray2[i];
                    float f5 = fArray3[j];
                    Color color2 = Color.getHSBColor(f3, f4, f5);
                    int n5 = n4;
                    int n6 = j * n2 + i;
                    this.Q[n5 + this.N * n6] = color2;
                }
            }
        }
        this.A();
    }

    private float[] A(int n) {
        float[] fArray = new float[]{0.0f, 0.083333336f, 0.16666667f, 0.33333334f, 0.6666667f, 0.8333333f, 1.0f};
        float[] fArray2 = new float[6 * n];
        for (int i = 0; i < fArray2.length; ++i) {
            int n2 = i / n;
            int n3 = i % n;
            float f = (fArray[n2 + 1] - fArray[n2]) / (float)n;
            fArray2[i] = fArray[n2] + f * (float)n3;
        }
        return fArray2;
    }

    public XColorPanel(ActionListener actionListener, Color color, int n, int n2) {
        this.F = actionListener;
        this.S = color;
        if (n2 == 0) {
            this.K = 1;
            this.N = n;
        } else if (n2 == 1) {
            this.K = n;
            this.N = 1;
        } else {
            throw new IllegalArgumentException("axis must be one of X_AXIS or Y_AXIS");
        }
        this.Q = new Color[n];
        if (n == 1) {
            this.Q[0] = Color.white;
        } else {
            float f = 1.0f / (float)(n - 1);
            for (int i = 0; i < n; ++i) {
                Color color2;
                float f2 = 1.0f - f * (float)i;
                this.Q[i] = color2 = new Color(f2, f2, f2);
            }
        }
        this.A();
    }

    public XColorPanel(ActionListener actionListener, Color color, int n, int n2, String string) {
        this.F = actionListener;
        this.S = color;
        this.N = n;
        this.K = n2;
        this.Q = new Color[this.N * this.K];
        this.setColors(string);
        this.A();
    }

    public void setColors(String string) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            int n = 0;
            while (n < this.Q.length) {
                Color color = null;
                if (stringTokenizer.hasMoreTokens()) {
                    color = this.A(stringTokenizer.nextToken());
                }
                this.Q[n++] = color;
            }
        }
    }

    private void A() {
        this.addMouseListener(this.R);
        this.setBackground(M);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public Color getCurrentColor() {
        return this.S;
    }

    public void setCurrentColor(Color color) {
        this.S = color;
        this.repaint();
    }

    public String getColorText() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.Q.length; ++i) {
            stringBuffer.append(this.A(this.Q[i]));
            stringBuffer.append(',');
        }
        return new String(stringBuffer);
    }

    private Color A(String string) {
        return "%".equals(string) || string == null || string.length() == 0 ? null : new Color(Integer.parseInt(string, 16));
    }

    private String A(Color color) {
        String string = color != null ? Integer.toString(color.getRGB(), 16) : "%";
        return string;
    }

    private static Color A(float f, float f2, float f3) {
        int n = Math.max(0, Math.min(255, (int)f));
        int n2 = Math.max(0, Math.min(255, (int)f2));
        int n3 = Math.max(0, Math.min(255, (int)f3));
        Color color = new Color(n, n2, n3);
        return color;
    }

    private Color A(int n, int n2) {
        Color color = null;
        int n3 = n2 * this.N + n;
        if (n3 < this.Q.length) {
            color = this.Q[n3];
        }
        return color;
    }

    public Dimension getPreferredSize() {
        Border border = this.getBorder();
        int n = 0;
        int n2 = 0;
        if (border != null) {
            Insets insets = border.getBorderInsets(this);
            n = insets.left + insets.right;
            n2 = insets.top + insets.bottom;
        }
        int n3 = 13 * this.N + 0 * (this.N - 1) + n;
        int n4 = 13 * this.K + 0 * (this.K - 1) + n2;
        return new Dimension(n3, n4);
    }

    public Dimension getMinimumSize() {
        Border border = this.getBorder();
        int n = 0;
        int n2 = 0;
        if (border != null) {
            Insets insets = border.getBorderInsets(this);
            n = insets.left + insets.right;
            n2 = insets.top + insets.bottom;
        }
        int n3 = 8 * this.N + 0 * (this.N - 1) + n;
        int n4 = 8 * this.K + 0 * (this.K - 1) + n2;
        return new Dimension(n3, n4);
    }

    public Dimension getMaximumSize() {
        Border border = this.getBorder();
        int n = 0;
        int n2 = 0;
        if (border != null) {
            Insets insets = border.getBorderInsets(this);
            n = insets.left + insets.right;
            n2 = insets.top + insets.bottom;
        }
        int n3 = 20 * this.N + 0 * (this.N - 1) + n;
        int n4 = 20 * this.K + 0 * (this.K - 1) + n2;
        return new Dimension(n3, n4);
    }

    private int C() {
        Border border = this.getBorder();
        int n = 0;
        if (border != null) {
            Insets insets = border.getBorderInsets(this);
            n = insets.left + insets.right;
        }
        int n2 = this.getWidth();
        int n3 = (n2 - n + 0) / this.N - 0;
        n3 = Math.max(8, n3);
        return n3;
    }

    private int B() {
        Border border = this.getBorder();
        int n = 0;
        if (border != null) {
            Insets insets = border.getBorderInsets(this);
            n = insets.top + insets.bottom;
        }
        int n2 = this.getHeight();
        int n3 = (n2 - n + 0) / this.K - 0;
        n3 = Math.max(8, n3);
        return n3;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        SwingUtil.setToolTipText(this, "");
        Point point = mouseEvent.getPoint();
        Color color = this.A(point);
        String string = null;
        if (color != null) {
            string = "RGB: " + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue();
        }
        return string;
    }

    private Color A(Point point) {
        Color color = null;
        Border border = this.getBorder();
        int n = 0;
        int n2 = 0;
        if (border != null) {
            Insets insets = border.getBorderInsets(this);
            n = insets.left;
            n2 = insets.top;
        }
        int n3 = point.x - n;
        int n4 = point.y - n2;
        if (n3 >= 0 && n4 >= 0) {
            int n5 = this.C();
            int n6 = this.B();
            int n7 = n3 / (n5 + 0);
            int n8 = n4 / (n6 + 0);
            if (n7 < this.N && n8 < this.K) {
                int n9 = n3 % (n5 + 0);
                int n10 = n4 % (n6 + 0);
                if (n9 < n5 && n10 < n6) {
                    color = this.A(n7, n8);
                }
            }
        }
        return color;
    }

    public void ensureContainsCurrentColor() {
        if (this.S != null) {
            boolean bl = false;
            int n = -1;
            for (int i = 0; i < this.Q.length; ++i) {
                Color color = this.Q[i];
                if (color == null && n == -1) {
                    n = i;
                }
                bl = bl || this.S.equals(color);
            }
            if (!bl) {
                if (n == -1) {
                    System.arraycopy(this.Q, 1, this.Q, 0, this.Q.length - 1);
                    n = this.Q.length - 1;
                }
                this.Q[n] = this.S;
            }
        }
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Color color = graphics.getColor();
        Border border = this.getBorder();
        int n = 0;
        int n2 = 0;
        if (border != null) {
            Insets insets = border.getBorderInsets(this);
            n = insets.left;
            n2 = insets.top;
        }
        boolean bl = this.isEnabled();
        int n3 = this.C();
        int n4 = this.B();
        for (int i = 0; i < this.N; ++i) {
            int n5 = n + i * (n3 + 0);
            for (int j = 0; j < this.K; ++j) {
                int n6 = n2 + j * (n4 + 0);
                Color color2 = bl ? this.A(i, j) : O;
                this.A(graphics, color2, n5, n6, n3, n4);
            }
        }
        graphics.setColor(color);
    }

    private void A(Graphics graphics, Color color, int n, int n2, int n3, int n4) {
        Border border = color == null ? G : (color.equals(this.S) ? L : T);
        Insets insets = border.getBorderInsets(this);
        border.paintBorder(this, graphics, n, n2, n3, n4);
        if (color == null && D != null) {
            color = D;
        }
        if (color != null) {
            graphics.setColor(color);
            graphics.fillRect(n + insets.left, n2 + insets.top, n3 - insets.left - insets.right, n4 - insets.top - insets.bottom);
        }
    }

    private void A(MouseEvent mouseEvent) {
        Point point;
        Color color;
        if (this.isEnabled() && (color = this.A(point = mouseEvent.getPoint())) != null) {
            this.S = color;
            this.repaint();
            ActionEvent actionEvent = new ActionEvent(mouseEvent.getSource(), mouseEvent.getID(), null, mouseEvent.getModifiers());
            this.F.actionPerformed(actionEvent);
        }
    }
}

