/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.services.util;

import com.gentleware.services.util.XArrayList;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class CollectionFactory {
    private CollectionFactory() {
    }

    public static Map createWeakHashMap() {
        return new WeakHashMap();
    }

    public static Map createWeakHashMap(int n) {
        return new WeakHashMap(n);
    }

    public static Map createWeakHashMap(int n, float f) {
        return new WeakHashMap(n, f);
    }

    public static Map createWeakHashMap(Map map) {
        return new WeakHashMap(map);
    }

    public static Map createHashMap() {
        return new THashMap();
    }

    public static Map createHashMap(int n) {
        return new THashMap(n);
    }

    public static Map createHashMap(int n, float f) {
        return new THashMap(n, f);
    }

    public static Map createHashMap(Map map) {
        return new THashMap(map);
    }

    public static List createLinkedList() {
        return new LinkedList();
    }

    public static List createLinkedList(Collection collection) {
        return new LinkedList(collection);
    }

    public static List createArrayList() {
        return new XArrayList();
    }

    public static List createArrayList(int n) {
        return new XArrayList(n);
    }

    public static List createArrayList(Collection collection) {
        return new XArrayList(collection);
    }

    public static Set createHashSet() {
        return new THashSet();
    }

    public static Set createHashSet(Collection collection) {
        return new THashSet(collection);
    }

    public static Set createHashSet(int n, float f) {
        return new THashSet(n, f);
    }

    public static Set createHashSet(int n) {
        return new THashSet(n);
    }
}

